<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XOSVersion StructType
 * @subpackage Structs
 */
class XOSVersion extends AbstractStructBase
{
    /**
     * The osName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $osName;
    /**
     * The osVersion
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $osVersion;
    /**
     * Constructor method for XOSVersion
     * @uses XOSVersion::setOsName()
     * @uses XOSVersion::setOsVersion()
     * @param string $osName
     * @param string $osVersion
     */
    public function __construct($osName = null, $osVersion = null)
    {
        $this
            ->setOsName($osName)
            ->setOsVersion($osVersion);
    }
    /**
     * Get osName value
     * @return string|null
     */
    public function getOsName()
    {
        return $this->osName;
    }
    /**
     * Set osName value
     * @param string $osName
     * @return \StructType\XOSVersion
     */
    public function setOsName($osName = null)
    {
        // validation for constraint: string
        if (!is_null($osName) && !is_string($osName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($osName, true), gettype($osName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($osName) && mb_strlen($osName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($osName)), __LINE__);
        }
        $this->osName = $osName;
        return $this;
    }
    /**
     * Get osVersion value
     * @return string|null
     */
    public function getOsVersion()
    {
        return $this->osVersion;
    }
    /**
     * Set osVersion value
     * @param string $osVersion
     * @return \StructType\XOSVersion
     */
    public function setOsVersion($osVersion = null)
    {
        // validation for constraint: string
        if (!is_null($osVersion) && !is_string($osVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($osVersion, true), gettype($osVersion)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($osVersion) && mb_strlen($osVersion) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($osVersion)), __LINE__);
        }
        $this->osVersion = $osVersion;
        return $this;
    }
}
