<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLocationRelationship StructType
 * @subpackage Structs
 */
class XLocationRelationship extends AbstractStructBase
{
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The rsvpSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rsvpSetting;
    /**
     * Constructor method for XLocationRelationship
     * @uses XLocationRelationship::setLocationName()
     * @uses XLocationRelationship::setRsvpSetting()
     * @param \StructType\XFkType $locationName
     * @param string $rsvpSetting
     */
    public function __construct(\StructType\XFkType $locationName = null, $rsvpSetting = null)
    {
        $this
            ->setLocationName($locationName)
            ->setRsvpSetting($rsvpSetting);
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\XLocationRelationship
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get rsvpSetting value
     * @return string
     */
    public function getRsvpSetting()
    {
        return $this->rsvpSetting;
    }
    /**
     * Set rsvpSetting value
     * @uses \EnumType\XMatrixValue::valueIsValid()
     * @uses \EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpSetting
     * @return \StructType\XLocationRelationship
     */
    public function setRsvpSetting($rsvpSetting = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMatrixValue::valueIsValid($rsvpSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMatrixValue', is_array($rsvpSetting) ? implode(', ', $rsvpSetting) : var_export($rsvpSetting, true), implode(', ', \EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->rsvpSetting = $rsvpSetting;
        return $this;
    }
}
