<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLdapDirectory StructType
 * @subpackage Structs
 */
class XLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userSearchBase;
    /**
     * The intervalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $intervalValue;
    /**
     * The nextExecTime
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Servers
     */
    public $servers;
    /**
     * The repeatable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The scheduleUnit
     * Meta information extracted from the WSDL
     * - default: DAY
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scheduleUnit;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The mailId
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailId;
    /**
     * The ldapFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $ldapFilter;
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUri;
    /**
     * The accessControlGroupInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The featureGroupTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $featureGroupTemplate;
    /**
     * The applyMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyMask;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mask;
    /**
     * The applyPoolList
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyPoolList;
    /**
     * The addDns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddDns
     */
    public $addDns;
    /**
     * Constructor method for XLdapDirectory
     * @uses XLdapDirectory::setName()
     * @uses XLdapDirectory::setLdapDn()
     * @uses XLdapDirectory::setLdapPassword()
     * @uses XLdapDirectory::setUserSearchBase()
     * @uses XLdapDirectory::setIntervalValue()
     * @uses XLdapDirectory::setNextExecTime()
     * @uses XLdapDirectory::setServers()
     * @uses XLdapDirectory::setRepeatable()
     * @uses XLdapDirectory::setScheduleUnit()
     * @uses XLdapDirectory::setMiddleName()
     * @uses XLdapDirectory::setPhoneNumber()
     * @uses XLdapDirectory::setMailId()
     * @uses XLdapDirectory::setLdapFilter()
     * @uses XLdapDirectory::setDirectoryUri()
     * @uses XLdapDirectory::setAccessControlGroupInfo()
     * @uses XLdapDirectory::setFeatureGroupTemplate()
     * @uses XLdapDirectory::setApplyMask()
     * @uses XLdapDirectory::setMask()
     * @uses XLdapDirectory::setApplyPoolList()
     * @uses XLdapDirectory::setAddDns()
     * @param string $name
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $intervalValue
     * @param string $nextExecTime
     * @param \StructType\Servers $servers
     * @param string $repeatable
     * @param string $scheduleUnit
     * @param string $middleName
     * @param string $phoneNumber
     * @param string $mailId
     * @param \StructType\XFkType $ldapFilter
     * @param string $directoryUri
     * @param \StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @param \StructType\XFkType $featureGroupTemplate
     * @param string $applyMask
     * @param string $mask
     * @param string $applyPoolList
     * @param \StructType\AddDns $addDns
     */
    public function __construct($name = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $intervalValue = null, $nextExecTime = null, \StructType\Servers $servers = null, $repeatable = null, $scheduleUnit = 'DAY', $middleName = null, $phoneNumber = null, $mailId = null, \StructType\XFkType $ldapFilter = null, $directoryUri = null, \StructType\AccessControlGroupInfo $accessControlGroupInfo = null, \StructType\XFkType $featureGroupTemplate = null, $applyMask = 'false', $mask = null, $applyPoolList = 'false', \StructType\AddDns $addDns = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setIntervalValue($intervalValue)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setRepeatable($repeatable)
            ->setScheduleUnit($scheduleUnit)
            ->setMiddleName($middleName)
            ->setPhoneNumber($phoneNumber)
            ->setMailId($mailId)
            ->setLdapFilter($ldapFilter)
            ->setDirectoryUri($directoryUri)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setFeatureGroupTemplate($featureGroupTemplate)
            ->setApplyMask($applyMask)
            ->setMask($mask)
            ->setApplyPoolList($applyPoolList)
            ->setAddDns($addDns);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XLdapDirectory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \StructType\XLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        // validation for constraint: string
        if (!is_null($ldapDn) && !is_string($ldapDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapDn, true), gettype($ldapDn)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapDn) && mb_strlen($ldapDn) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapDn)), __LINE__);
        }
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \StructType\XLdapDirectory
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapPassword, true), gettype($ldapPassword)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapPassword) && mb_strlen($ldapPassword) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \StructType\XLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userSearchBase, true), gettype($userSearchBase)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($userSearchBase) && mb_strlen($userSearchBase) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intervalValue
     * @return \StructType\XLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($intervalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($intervalValue) ? implode(', ', $intervalValue) : var_export($intervalValue, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \StructType\XLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        // validation for constraint: string
        if (!is_null($nextExecTime) && !is_string($nextExecTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextExecTime, true), gettype($nextExecTime)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($nextExecTime) && mb_strlen($nextExecTime) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($nextExecTime)), __LINE__);
        }
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return \StructType\Servers
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \StructType\Servers $servers
     * @return \StructType\XLdapDirectory
     */
    public function setServers(\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \StructType\XLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        // validation for constraint: string
        if (!is_null($repeatable) && !is_string($repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repeatable, true), gettype($repeatable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($repeatable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($repeatable, true)), __LINE__);
        }
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @uses \EnumType\XScheduleUnit::valueIsValid()
     * @uses \EnumType\XScheduleUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleUnit
     * @return \StructType\XLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = 'DAY')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XScheduleUnit::valueIsValid($scheduleUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XScheduleUnit', is_array($scheduleUnit) ? implode(', ', $scheduleUnit) : var_export($scheduleUnit, true), implode(', ', \EnumType\XScheduleUnit::getValidValues())), __LINE__);
        }
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\XLdapDirectory
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($middleName) && mb_strlen($middleName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \StructType\XLdapDirectory
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get mailId value
     * @return string|null
     */
    public function getMailId()
    {
        return $this->mailId;
    }
    /**
     * Set mailId value
     * @param string $mailId
     * @return \StructType\XLdapDirectory
     */
    public function setMailId($mailId = null)
    {
        // validation for constraint: string
        if (!is_null($mailId) && !is_string($mailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailId, true), gettype($mailId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($mailId) && mb_strlen($mailId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($mailId)), __LINE__);
        }
        $this->mailId = $mailId;
        return $this;
    }
    /**
     * Get ldapFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getLdapFilter()
    {
        return isset($this->ldapFilter) ? $this->ldapFilter : null;
    }
    /**
     * Set ldapFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $ldapFilter
     * @return \StructType\XLdapDirectory
     */
    public function setLdapFilter(\StructType\XFkType $ldapFilter = null)
    {
        if (is_null($ldapFilter) || (is_array($ldapFilter) && empty($ldapFilter))) {
            unset($this->ldapFilter);
        } else {
            $this->ldapFilter = $ldapFilter;
        }
        return $this;
    }
    /**
     * Get directoryUri value
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * Set directoryUri value
     * @param string $directoryUri
     * @return \StructType\XLdapDirectory
     */
    public function setDirectoryUri($directoryUri = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUri) && !is_string($directoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryUri, true), gettype($directoryUri)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($directoryUri) && mb_strlen($directoryUri) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($directoryUri)), __LINE__);
        }
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return \StructType\AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return $this->accessControlGroupInfo;
    }
    /**
     * Set accessControlGroupInfo value
     * @param \StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @return \StructType\XLdapDirectory
     */
    public function setAccessControlGroupInfo(\StructType\AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        $this->accessControlGroupInfo = $accessControlGroupInfo;
        return $this;
    }
    /**
     * Get featureGroupTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getFeatureGroupTemplate()
    {
        return isset($this->featureGroupTemplate) ? $this->featureGroupTemplate : null;
    }
    /**
     * Set featureGroupTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $featureGroupTemplate
     * @return \StructType\XLdapDirectory
     */
    public function setFeatureGroupTemplate(\StructType\XFkType $featureGroupTemplate = null)
    {
        if (is_null($featureGroupTemplate) || (is_array($featureGroupTemplate) && empty($featureGroupTemplate))) {
            unset($this->featureGroupTemplate);
        } else {
            $this->featureGroupTemplate = $featureGroupTemplate;
        }
        return $this;
    }
    /**
     * Get applyMask value
     * @return string|null
     */
    public function getApplyMask()
    {
        return $this->applyMask;
    }
    /**
     * Set applyMask value
     * @param string $applyMask
     * @return \StructType\XLdapDirectory
     */
    public function setApplyMask($applyMask = 'false')
    {
        // validation for constraint: string
        if (!is_null($applyMask) && !is_string($applyMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyMask, true), gettype($applyMask)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($applyMask) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applyMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($applyMask, true)), __LINE__);
        }
        $this->applyMask = $applyMask;
        return $this;
    }
    /**
     * Get mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMask()
    {
        return isset($this->mask) ? $this->mask : null;
    }
    /**
     * Set mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mask
     * @return \StructType\XLdapDirectory
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mask, true), gettype($mask)), __LINE__);
        }
        if (is_null($mask) || (is_array($mask) && empty($mask))) {
            unset($this->mask);
        } else {
            $this->mask = $mask;
        }
        return $this;
    }
    /**
     * Get applyPoolList value
     * @return string|null
     */
    public function getApplyPoolList()
    {
        return $this->applyPoolList;
    }
    /**
     * Set applyPoolList value
     * @param string $applyPoolList
     * @return \StructType\XLdapDirectory
     */
    public function setApplyPoolList($applyPoolList = 'false')
    {
        // validation for constraint: string
        if (!is_null($applyPoolList) && !is_string($applyPoolList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyPoolList, true), gettype($applyPoolList)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($applyPoolList) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applyPoolList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($applyPoolList, true)), __LINE__);
        }
        $this->applyPoolList = $applyPoolList;
        return $this;
    }
    /**
     * Get addDns value
     * @return \StructType\AddDns|null
     */
    public function getAddDns()
    {
        return $this->addDns;
    }
    /**
     * Set addDns value
     * @param \StructType\AddDns $addDns
     * @return \StructType\XLdapDirectory
     */
    public function setAddDns(\StructType\AddDns $addDns = null)
    {
        $this->addDns = $addDns;
        return $this;
    }
}
