<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XInterClusterServiceProfile StructType
 * @subpackage Structs
 */
class XInterClusterServiceProfile extends AbstractStructBase
{
    /**
     * The interClusterService
     * Meta information extracted from the WSDL
     * - default: EMCC
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $interClusterService;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for PSTN Access and RSVP Agent
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * Constructor method for XInterClusterServiceProfile
     * @uses XInterClusterServiceProfile::setInterClusterService()
     * @uses XInterClusterServiceProfile::setIsActivated()
     * @uses XInterClusterServiceProfile::setSipTrunkName()
     * @param string $interClusterService
     * @param string $isActivated
     * @param \StructType\XFkType $sipTrunkName
     */
    public function __construct($interClusterService = 'EMCC', $isActivated = 'false', \StructType\XFkType $sipTrunkName = null)
    {
        $this
            ->setInterClusterService($interClusterService)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName);
    }
    /**
     * Get interClusterService value
     * @return string
     */
    public function getInterClusterService()
    {
        return $this->interClusterService;
    }
    /**
     * Set interClusterService value
     * @uses \EnumType\XInterClusterService::valueIsValid()
     * @uses \EnumType\XInterClusterService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interClusterService
     * @return \StructType\XInterClusterServiceProfile
     */
    public function setInterClusterService($interClusterService = 'EMCC')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInterClusterService::valueIsValid($interClusterService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInterClusterService', is_array($interClusterService) ? implode(', ', $interClusterService) : var_export($interClusterService, true), implode(', ', \EnumType\XInterClusterService::getValidValues())), __LINE__);
        }
        $this->interClusterService = $interClusterService;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\XInterClusterServiceProfile
     */
    public function setIsActivated($isActivated = 'false')
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\XInterClusterServiceProfile
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
}
