<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeRouteFilterGroup StructType
 * @subpackage Structs
 */
class XImeRouteFilterGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The groupTrustSetting
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $groupTrustSetting;
    /**
     * Constructor method for XImeRouteFilterGroup
     * @uses XImeRouteFilterGroup::setName()
     * @uses XImeRouteFilterGroup::setDescription()
     * @uses XImeRouteFilterGroup::setGroupTrustSetting()
     * @param string $name
     * @param string $description
     * @param string $groupTrustSetting
     */
    public function __construct($name = null, $description = null, $groupTrustSetting = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setGroupTrustSetting($groupTrustSetting);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XImeRouteFilterGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XImeRouteFilterGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get groupTrustSetting value
     * @return string|null
     */
    public function getGroupTrustSetting()
    {
        return $this->groupTrustSetting;
    }
    /**
     * Set groupTrustSetting value
     * @param string $groupTrustSetting
     * @return \StructType\XImeRouteFilterGroup
     */
    public function setGroupTrustSetting($groupTrustSetting = null)
    {
        // validation for constraint: string
        if (!is_null($groupTrustSetting) && !is_string($groupTrustSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupTrustSetting, true), gettype($groupTrustSetting)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($groupTrustSetting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $groupTrustSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($groupTrustSetting, true)), __LINE__);
        }
        $this->groupTrustSetting = $groupTrustSetting;
        return $this;
    }
}
