<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeRouteFilterElement StructType
 * @subpackage Structs
 */
class XImeRouteFilterElement extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The imeRouteFilterGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $imeRouteFilterGroupName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The elementType
     * Meta information extracted from the WSDL
     * - default: Domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $elementType;
    /**
     * Constructor method for XImeRouteFilterElement
     * @uses XImeRouteFilterElement::setName()
     * @uses XImeRouteFilterElement::setImeRouteFilterGroupName()
     * @uses XImeRouteFilterElement::setDescription()
     * @uses XImeRouteFilterElement::setElementType()
     * @param string $name
     * @param \StructType\XFkType $imeRouteFilterGroupName
     * @param string $description
     * @param string $elementType
     */
    public function __construct($name = null, \StructType\XFkType $imeRouteFilterGroupName = null, $description = null, $elementType = 'Domain')
    {
        $this
            ->setName($name)
            ->setImeRouteFilterGroupName($imeRouteFilterGroupName)
            ->setDescription($description)
            ->setElementType($elementType);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XImeRouteFilterElement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get imeRouteFilterGroupName value
     * @return \StructType\XFkType
     */
    public function getImeRouteFilterGroupName()
    {
        return $this->imeRouteFilterGroupName;
    }
    /**
     * Set imeRouteFilterGroupName value
     * @param \StructType\XFkType $imeRouteFilterGroupName
     * @return \StructType\XImeRouteFilterElement
     */
    public function setImeRouteFilterGroupName(\StructType\XFkType $imeRouteFilterGroupName = null)
    {
        $this->imeRouteFilterGroupName = $imeRouteFilterGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XImeRouteFilterElement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get elementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->elementType;
    }
    /**
     * Set elementType value
     * @uses \EnumType\XViprFilterElement::valueIsValid()
     * @uses \EnumType\XViprFilterElement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elementType
     * @return \StructType\XImeRouteFilterElement
     */
    public function setElementType($elementType = 'Domain')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XViprFilterElement::valueIsValid($elementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XViprFilterElement', is_array($elementType) ? implode(', ', $elementType) : var_export($elementType, true), implode(', ', \EnumType\XViprFilterElement::getValidValues())), __LINE__);
        }
        $this->elementType = $elementType;
        return $this;
    }
}
