<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XHuntListMember StructType
 * @subpackage Structs
 */
class XHuntListMember extends AbstractStructBase
{
    /**
     * The lineGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $lineGroupName;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for XHuntListMember
     * @uses XHuntListMember::setLineGroupName()
     * @uses XHuntListMember::setSelectionOrder()
     * @param \StructType\XFkType $lineGroupName
     * @param string $selectionOrder
     */
    public function __construct(\StructType\XFkType $lineGroupName = null, $selectionOrder = null)
    {
        $this
            ->setLineGroupName($lineGroupName)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get lineGroupName value
     * @return \StructType\XFkType
     */
    public function getLineGroupName()
    {
        return $this->lineGroupName;
    }
    /**
     * Set lineGroupName value
     * @param \StructType\XFkType $lineGroupName
     * @return \StructType\XHuntListMember
     */
    public function setLineGroupName(\StructType\XFkType $lineGroupName = null)
    {
        $this->lineGroupName = $lineGroupName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\XHuntListMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
}
