<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XH323Trunk StructType
 * @subpackage Structs
 */
class XH323Trunk extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta information extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The waitForFarEndH245TerminalSet
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $waitForFarEndH245TerminalSet;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingLineIdPresentation
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The displayIEDelivery
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIEDelivery;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The enableInboundFaststart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableInboundFaststart;
    /**
     * The enableOutboundFaststart
     * Meta information extracted from the WSDL
     * - documentation: If set to True,mediaResourceList must be mentioned and mtpRequired must be set to True.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundFaststart;
    /**
     * The codecForOutboundFaststart
     * Meta information extracted from the WSDL
     * - documentation: enableOutboundFaststart must be set to true for it to be read.Not Nillable.
     * - default: G711 u-law 64K
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codecForOutboundFaststart;
    /**
     * The allowH235PassThrough
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowH235PassThrough;
    /**
     * The tunneledProtocol
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only if PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qsigVariant;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The signalingPort
     * Meta information extracted from the WSDL
     * - default: 1720
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $signalingPort;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Gateways and trunks
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Gateways and trunks
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Gateways and trunks
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Gateways and trunks
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The prefixDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefixDn;
    /**
     * The calledPartyIeNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyIeNumberType;
    /**
     * The callingPartyIeNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyIeNumberType;
    /**
     * The calledNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledNumberingPlan;
    /**
     * The callingNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingNumberingPlan;
    /**
     * The pathReplacementSupport
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The gateKeeperInfo
     * Meta information extracted from the WSDL
     * - choice: gateKeeperInfo
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GateKeeperInfo
     */
    public $gateKeeperInfo;
    /**
     * The ictPassingPrecedenceLevelThroughUuie
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Non-Gatekeeper controlled ICT trunk's.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ictPassingPrecedenceLevelThroughUuie;
    /**
     * The ictSecurityAccessLevel
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Non-Gatekeeper controlled ICT trunk's. Should be set only when ictPassingPrecendenceLevelThroughUUIE is set to true.
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ictSecurityAccessLevel;
    /**
     * The isSafEnabled
     * Meta information extracted from the WSDL
     * - documentation: If set to false its mandatory to specify a value for the tag server1(remoteServerInfo is its parent tag)
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isSafEnabled;
    /**
     * The callingPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Automated Alternate Routing. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The useDevicePoolCalledCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssNatl;
    /**
     * The useDevicePoolCalledCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssIntl;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The useDevicePoolCalledCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssSubs;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The runOnEveryNode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * The destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Destinations
     */
    public $destinations;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The cntdPnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XH323Trunk
     * @uses XH323Trunk::setName()
     * @uses XH323Trunk::setProduct()
     * @uses XH323Trunk::setClass()
     * @uses XH323Trunk::setProtocol()
     * @uses XH323Trunk::setProtocolSide()
     * @uses XH323Trunk::setDevicePoolName()
     * @uses XH323Trunk::setLocationName()
     * @uses XH323Trunk::setDescription()
     * @uses XH323Trunk::setCallingSearchSpaceName()
     * @uses XH323Trunk::setCommonDeviceConfigName()
     * @uses XH323Trunk::setNetworkLocation()
     * @uses XH323Trunk::setMediaResourceListName()
     * @uses XH323Trunk::setAarNeighborhoodName()
     * @uses XH323Trunk::setTraceFlag()
     * @uses XH323Trunk::setMlppDomainId()
     * @uses XH323Trunk::setMlppIndicationStatus()
     * @uses XH323Trunk::setPreemption()
     * @uses XH323Trunk::setUseTrustedRelayPoint()
     * @uses XH323Trunk::setRetryVideoCallAsAudio()
     * @uses XH323Trunk::setCgpnTransformationCssName()
     * @uses XH323Trunk::setUseDevicePoolCgpnTransformCss()
     * @uses XH323Trunk::setGeoLocationName()
     * @uses XH323Trunk::setGeoLocationFilterName()
     * @uses XH323Trunk::setSendGeoLocation()
     * @uses XH323Trunk::setCdpnTransformationCssName()
     * @uses XH323Trunk::setUseDevicePoolCdpnTransformCss()
     * @uses XH323Trunk::setPacketCaptureMode()
     * @uses XH323Trunk::setPacketCaptureDuration()
     * @uses XH323Trunk::setSrtpAllowed()
     * @uses XH323Trunk::setUnattendedPort()
     * @uses XH323Trunk::setWaitForFarEndH245TerminalSet()
     * @uses XH323Trunk::setMtpRequired()
     * @uses XH323Trunk::setCallerIdDn()
     * @uses XH323Trunk::setCallingPartySelection()
     * @uses XH323Trunk::setCallingLineIdPresentation()
     * @uses XH323Trunk::setDisplayIEDelivery()
     * @uses XH323Trunk::setRedirectOutboundNumberIe()
     * @uses XH323Trunk::setRedirectInboundNumberIe()
     * @uses XH323Trunk::setEnableInboundFaststart()
     * @uses XH323Trunk::setEnableOutboundFaststart()
     * @uses XH323Trunk::setCodecForOutboundFaststart()
     * @uses XH323Trunk::setAllowH235PassThrough()
     * @uses XH323Trunk::setTunneledProtocol()
     * @uses XH323Trunk::setAsn1RoseOidEncoding()
     * @uses XH323Trunk::setQsigVariant()
     * @uses XH323Trunk::setTransmitUtf8()
     * @uses XH323Trunk::setSignalingPort()
     * @uses XH323Trunk::setNationalPrefix()
     * @uses XH323Trunk::setInternationalPrefix()
     * @uses XH323Trunk::setUnknownPrefix()
     * @uses XH323Trunk::setSubscriberPrefix()
     * @uses XH323Trunk::setSigDigits()
     * @uses XH323Trunk::setPrefixDn()
     * @uses XH323Trunk::setCalledPartyIeNumberType()
     * @uses XH323Trunk::setCallingPartyIeNumberType()
     * @uses XH323Trunk::setCalledNumberingPlan()
     * @uses XH323Trunk::setCallingNumberingPlan()
     * @uses XH323Trunk::setPathReplacementSupport()
     * @uses XH323Trunk::setGateKeeperInfo()
     * @uses XH323Trunk::setIctPassingPrecedenceLevelThroughUuie()
     * @uses XH323Trunk::setIctSecurityAccessLevel()
     * @uses XH323Trunk::setIsSafEnabled()
     * @uses XH323Trunk::setCallingPartyNationalStripDigits()
     * @uses XH323Trunk::setCallingPartyInternationalStripDigits()
     * @uses XH323Trunk::setCallingPartyUnknownStripDigits()
     * @uses XH323Trunk::setCallingPartySubscriberStripDigits()
     * @uses XH323Trunk::setCallingPartyNationalTransformationCssName()
     * @uses XH323Trunk::setCallingPartyInternationalTransformationCssName()
     * @uses XH323Trunk::setCallingPartyUnknownTransformationCssName()
     * @uses XH323Trunk::setCallingPartySubscriberTransformationCssName()
     * @uses XH323Trunk::setCalledPartyNationalPrefix()
     * @uses XH323Trunk::setCalledPartyInternationalPrefix()
     * @uses XH323Trunk::setCalledPartyUnknownPrefix()
     * @uses XH323Trunk::setCalledPartySubscriberPrefix()
     * @uses XH323Trunk::setPstnAccess()
     * @uses XH323Trunk::setImeE164TransformationName()
     * @uses XH323Trunk::setAutomatedAlternateRoutingCssName()
     * @uses XH323Trunk::setUseDevicePoolCgpnTransformCssNatl()
     * @uses XH323Trunk::setUseDevicePoolCgpnTransformCssIntl()
     * @uses XH323Trunk::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses XH323Trunk::setUseDevicePoolCgpnTransformCssSubs()
     * @uses XH323Trunk::setUseDevicePoolCalledCssNatl()
     * @uses XH323Trunk::setUseDevicePoolCalledCssIntl()
     * @uses XH323Trunk::setUseDevicePoolCalledCssUnkn()
     * @uses XH323Trunk::setUseDevicePoolCalledCssSubs()
     * @uses XH323Trunk::setCalledPartyNationalStripDigits()
     * @uses XH323Trunk::setCalledPartyInternationalStripDigits()
     * @uses XH323Trunk::setCalledPartyUnknownStripDigits()
     * @uses XH323Trunk::setCalledPartySubscriberStripDigits()
     * @uses XH323Trunk::setCalledPartyNationalTransformationCssName()
     * @uses XH323Trunk::setCalledPartyInternationalTransformationCssName()
     * @uses XH323Trunk::setCalledPartyUnknownTransformationCssName()
     * @uses XH323Trunk::setCalledPartySubscriberTransformationCssName()
     * @uses XH323Trunk::setRunOnEveryNode()
     * @uses XH323Trunk::setDestinations()
     * @uses XH323Trunk::setUseDevicePoolCntdPnTransformationCss()
     * @uses XH323Trunk::setCntdPnTransformationCssName()
     * @uses XH323Trunk::setConfidentialAccess()
     * @uses XH323Trunk::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $locationName
     * @param string $description
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \StructType\XFkType $mediaResourceListName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $srtpAllowed
     * @param string $unattendedPort
     * @param string $waitForFarEndH245TerminalSet
     * @param string $mtpRequired
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingLineIdPresentation
     * @param string $displayIEDelivery
     * @param string $redirectOutboundNumberIe
     * @param string $redirectInboundNumberIe
     * @param string $enableInboundFaststart
     * @param string $enableOutboundFaststart
     * @param string $codecForOutboundFaststart
     * @param string $allowH235PassThrough
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param string $transmitUtf8
     * @param string $signalingPort
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param \StructType\SigDigits $sigDigits
     * @param string $prefixDn
     * @param string $calledPartyIeNumberType
     * @param string $callingPartyIeNumberType
     * @param string $calledNumberingPlan
     * @param string $callingNumberingPlan
     * @param string $pathReplacementSupport
     * @param \StructType\GateKeeperInfo $gateKeeperInfo
     * @param string $ictPassingPrecedenceLevelThroughUuie
     * @param string $ictSecurityAccessLevel
     * @param string $isSafEnabled
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $pstnAccess
     * @param \StructType\XFkType $imeE164TransformationName
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $useDevicePoolCalledCssNatl
     * @param string $useDevicePoolCalledCssIntl
     * @param string $useDevicePoolCalledCssUnkn
     * @param string $useDevicePoolCalledCssSubs
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param string $runOnEveryNode
     * @param \StructType\Destinations $destinations
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \StructType\XFkType $devicePoolName = null, \StructType\XFkType $locationName = null, $description = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \StructType\XFkType $mediaResourceListName = null, \StructType\XFkType $aarNeighborhoodName = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', $useTrustedRelayPoint = 'Default', $retryVideoCallAsAudio = 'true', \StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = 'true', \StructType\XFkType $geoLocationName = null, \StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = 'true', $packetCaptureMode = 'None', $packetCaptureDuration = '0', $srtpAllowed = 'false', $unattendedPort = 'false', $waitForFarEndH245TerminalSet = null, $mtpRequired = null, $callerIdDn = null, $callingPartySelection = 'Originator', $callingLineIdPresentation = 'Default', $displayIEDelivery = null, $redirectOutboundNumberIe = null, $redirectInboundNumberIe = null, $enableInboundFaststart = null, $enableOutboundFaststart = null, $codecForOutboundFaststart = 'G711 u-law 64K', $allowH235PassThrough = 'false', $tunneledProtocol = 'None', $asn1RoseOidEncoding = 'No Changes', $qsigVariant = 'No Changes', $transmitUtf8 = 'false', $signalingPort = '1720', $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, \StructType\SigDigits $sigDigits = '0', $prefixDn = null, $calledPartyIeNumberType = 'Cisco CallManager', $callingPartyIeNumberType = 'Cisco CallManager', $calledNumberingPlan = 'Cisco CallManager', $callingNumberingPlan = 'Cisco CallManager', $pathReplacementSupport = 'false', \StructType\GateKeeperInfo $gateKeeperInfo = null, $ictPassingPrecedenceLevelThroughUuie = null, $ictSecurityAccessLevel = '2', $isSafEnabled = 'false', $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \StructType\XFkType $callingPartyNationalTransformationCssName = null, \StructType\XFkType $callingPartyInternationalTransformationCssName = null, \StructType\XFkType $callingPartyUnknownTransformationCssName = null, \StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $pstnAccess = 'true', \StructType\XFkType $imeE164TransformationName = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, $useDevicePoolCgpnTransformCssNatl = 'true', $useDevicePoolCgpnTransformCssIntl = 'true', $useDevicePoolCgpnTransformCssUnkn = 'true', $useDevicePoolCgpnTransformCssSubs = 'true', $useDevicePoolCalledCssNatl = 'true', $useDevicePoolCalledCssIntl = 'true', $useDevicePoolCalledCssUnkn = 'true', $useDevicePoolCalledCssSubs = 'true', $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \StructType\XFkType $calledPartyNationalTransformationCssName = null, \StructType\XFkType $calledPartyInternationalTransformationCssName = null, \StructType\XFkType $calledPartyUnknownTransformationCssName = null, \StructType\XFkType $calledPartySubscriberTransformationCssName = null, $runOnEveryNode = 'false', \StructType\Destinations $destinations = null, $useDevicePoolCntdPnTransformationCss = 'true', \StructType\XFkType $cntdPnTransformationCssName = null, \StructType\ConfidentialAccess $confidentialAccess = null, $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSrtpAllowed($srtpAllowed)
            ->setUnattendedPort($unattendedPort)
            ->setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet)
            ->setMtpRequired($mtpRequired)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setDisplayIEDelivery($displayIEDelivery)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setEnableInboundFaststart($enableInboundFaststart)
            ->setEnableOutboundFaststart($enableOutboundFaststart)
            ->setCodecForOutboundFaststart($codecForOutboundFaststart)
            ->setAllowH235PassThrough($allowH235PassThrough)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setTransmitUtf8($transmitUtf8)
            ->setSignalingPort($signalingPort)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setSigDigits($sigDigits)
            ->setPrefixDn($prefixDn)
            ->setCalledPartyIeNumberType($calledPartyIeNumberType)
            ->setCallingPartyIeNumberType($callingPartyIeNumberType)
            ->setCalledNumberingPlan($calledNumberingPlan)
            ->setCallingNumberingPlan($callingNumberingPlan)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setGateKeeperInfo($gateKeeperInfo)
            ->setIctPassingPrecedenceLevelThroughUuie($ictPassingPrecedenceLevelThroughUuie)
            ->setIctSecurityAccessLevel($ictSecurityAccessLevel)
            ->setIsSafEnabled($isSafEnabled)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl)
            ->setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setRunOnEveryNode($runOnEveryNode)
            ->setDestinations($destinations)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setConfidentialAccess($confidentialAccess)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XH323Trunk
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\XH323Trunk
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\XClass::valueIsValid()
     * @uses \EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\XH323Trunk
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\XH323Trunk
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \EnumType\XProtocolSide::valueIsValid()
     * @uses \EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \StructType\XH323Trunk
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProtocolSide', is_array($protocolSide) ? implode(', ', $protocolSide) : var_export($protocolSide, true), implode(', ', \EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\XH323Trunk
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\XH323Trunk
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XH323Trunk
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\XH323Trunk
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\XH323Trunk
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \EnumType\XNetworkLocation::valueIsValid()
     * @uses \EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \StructType\XH323Trunk
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XNetworkLocation', is_array($networkLocation) ? implode(', ', $networkLocation) : var_export($networkLocation, true), implode(', ', \EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\XH323Trunk
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\XH323Trunk
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \StructType\XH323Trunk
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceFlag, true), gettype($traceFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($traceFlag, true)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \StructType\XH323Trunk
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mlppDomainId, true), gettype($mlppDomainId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($mlppDomainId) && mb_strlen($mlppDomainId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \StructType\XH323Trunk
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($mlppIndicationStatus) ? implode(', ', $mlppIndicationStatus) : var_export($mlppIndicationStatus, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\XH323Trunk
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPreemption', is_array($preemption) ? implode(', ', $preemption) : var_export($preemption, true), implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\XH323Trunk
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\XH323Trunk
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = 'true')
    {
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retryVideoCallAsAudio, true), gettype($retryVideoCallAsAudio)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCss, true), gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\XH323Trunk
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\XH323Trunk
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \StructType\XH323Trunk
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendGeoLocation, true), gettype($sendGeoLocation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sendGeoLocation, true)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCdpnTransformCss, true), gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \StructType\XH323Trunk
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPacketCaptureMode', is_array($packetCaptureMode) ? implode(', ', $packetCaptureMode) : var_export($packetCaptureMode, true), implode(', ', \EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \StructType\XH323Trunk
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($packetCaptureDuration) ? implode(', ', $packetCaptureDuration) : var_export($packetCaptureDuration, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \StructType\XH323Trunk
     */
    public function setSrtpAllowed($srtpAllowed = 'false')
    {
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srtpAllowed, true), gettype($srtpAllowed)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($srtpAllowed, true)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \StructType\XH323Trunk
     */
    public function setUnattendedPort($unattendedPort = 'false')
    {
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unattendedPort, true), gettype($unattendedPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($unattendedPort, true)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get waitForFarEndH245TerminalSet value
     * @return string|null
     */
    public function getWaitForFarEndH245TerminalSet()
    {
        return $this->waitForFarEndH245TerminalSet;
    }
    /**
     * Set waitForFarEndH245TerminalSet value
     * @param string $waitForFarEndH245TerminalSet
     * @return \StructType\XH323Trunk
     */
    public function setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet = null)
    {
        // validation for constraint: string
        if (!is_null($waitForFarEndH245TerminalSet) && !is_string($waitForFarEndH245TerminalSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waitForFarEndH245TerminalSet, true), gettype($waitForFarEndH245TerminalSet)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($waitForFarEndH245TerminalSet) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $waitForFarEndH245TerminalSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($waitForFarEndH245TerminalSet, true)), __LINE__);
        }
        $this->waitForFarEndH245TerminalSet = $waitForFarEndH245TerminalSet;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \StructType\XH323Trunk
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mtpRequired, true), gettype($mtpRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($mtpRequired, true)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \StructType\XH323Trunk
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDn, true), gettype($callerIdDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callerIdDn) && mb_strlen($callerIdDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \EnumType\XCallingPartySelection::valueIsValid()
     * @uses \EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCallingPartySelection', is_array($callingPartySelection) ? implode(', ', $callingPartySelection) : var_export($callingPartySelection, true), implode(', ', \EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return \StructType\XH323Trunk
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPresentationBit', is_array($callingLineIdPresentation) ? implode(', ', $callingLineIdPresentation) : var_export($callingLineIdPresentation, true), implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get displayIEDelivery value
     * @return string|null
     */
    public function getDisplayIEDelivery()
    {
        return $this->displayIEDelivery;
    }
    /**
     * Set displayIEDelivery value
     * @param string $displayIEDelivery
     * @return \StructType\XH323Trunk
     */
    public function setDisplayIEDelivery($displayIEDelivery = null)
    {
        // validation for constraint: string
        if (!is_null($displayIEDelivery) && !is_string($displayIEDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayIEDelivery, true), gettype($displayIEDelivery)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($displayIEDelivery) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $displayIEDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($displayIEDelivery, true)), __LINE__);
        }
        $this->displayIEDelivery = $displayIEDelivery;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \StructType\XH323Trunk
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        // validation for constraint: string
        if (!is_null($redirectOutboundNumberIe) && !is_string($redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectOutboundNumberIe, true), gettype($redirectOutboundNumberIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($redirectOutboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($redirectOutboundNumberIe, true)), __LINE__);
        }
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \StructType\XH323Trunk
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        // validation for constraint: string
        if (!is_null($redirectInboundNumberIe) && !is_string($redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectInboundNumberIe, true), gettype($redirectInboundNumberIe)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($redirectInboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($redirectInboundNumberIe, true)), __LINE__);
        }
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get enableInboundFaststart value
     * @return string|null
     */
    public function getEnableInboundFaststart()
    {
        return $this->enableInboundFaststart;
    }
    /**
     * Set enableInboundFaststart value
     * @param string $enableInboundFaststart
     * @return \StructType\XH323Trunk
     */
    public function setEnableInboundFaststart($enableInboundFaststart = null)
    {
        // validation for constraint: string
        if (!is_null($enableInboundFaststart) && !is_string($enableInboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableInboundFaststart, true), gettype($enableInboundFaststart)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableInboundFaststart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableInboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableInboundFaststart, true)), __LINE__);
        }
        $this->enableInboundFaststart = $enableInboundFaststart;
        return $this;
    }
    /**
     * Get enableOutboundFaststart value
     * @return string|null
     */
    public function getEnableOutboundFaststart()
    {
        return $this->enableOutboundFaststart;
    }
    /**
     * Set enableOutboundFaststart value
     * @param string $enableOutboundFaststart
     * @return \StructType\XH323Trunk
     */
    public function setEnableOutboundFaststart($enableOutboundFaststart = null)
    {
        // validation for constraint: string
        if (!is_null($enableOutboundFaststart) && !is_string($enableOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableOutboundFaststart, true), gettype($enableOutboundFaststart)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableOutboundFaststart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableOutboundFaststart, true)), __LINE__);
        }
        $this->enableOutboundFaststart = $enableOutboundFaststart;
        return $this;
    }
    /**
     * Get codecForOutboundFaststart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodecForOutboundFaststart()
    {
        return isset($this->codecForOutboundFaststart) ? $this->codecForOutboundFaststart : null;
    }
    /**
     * Set codecForOutboundFaststart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMediaPayload::valueIsValid()
     * @uses \EnumType\XMediaPayload::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codecForOutboundFaststart
     * @return \StructType\XH323Trunk
     */
    public function setCodecForOutboundFaststart($codecForOutboundFaststart = 'G711 u-law 64K')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMediaPayload::valueIsValid($codecForOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMediaPayload', is_array($codecForOutboundFaststart) ? implode(', ', $codecForOutboundFaststart) : var_export($codecForOutboundFaststart, true), implode(', ', \EnumType\XMediaPayload::getValidValues())), __LINE__);
        }
        if (is_null($codecForOutboundFaststart) || (is_array($codecForOutboundFaststart) && empty($codecForOutboundFaststart))) {
            unset($this->codecForOutboundFaststart);
        } else {
            $this->codecForOutboundFaststart = $codecForOutboundFaststart;
        }
        return $this;
    }
    /**
     * Get allowH235PassThrough value
     * @return string|null
     */
    public function getAllowH235PassThrough()
    {
        return $this->allowH235PassThrough;
    }
    /**
     * Set allowH235PassThrough value
     * @param string $allowH235PassThrough
     * @return \StructType\XH323Trunk
     */
    public function setAllowH235PassThrough($allowH235PassThrough = 'false')
    {
        // validation for constraint: string
        if (!is_null($allowH235PassThrough) && !is_string($allowH235PassThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowH235PassThrough, true), gettype($allowH235PassThrough)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowH235PassThrough) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowH235PassThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowH235PassThrough, true)), __LINE__);
        }
        $this->allowH235PassThrough = $allowH235PassThrough;
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @uses \EnumType\XTunneledProtocol::valueIsValid()
     * @uses \EnumType\XTunneledProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunneledProtocol
     * @return \StructType\XH323Trunk
     */
    public function setTunneledProtocol($tunneledProtocol = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTunneledProtocol::valueIsValid($tunneledProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTunneledProtocol', is_array($tunneledProtocol) ? implode(', ', $tunneledProtocol) : var_export($tunneledProtocol, true), implode(', ', \EnumType\XTunneledProtocol::getValidValues())), __LINE__);
        }
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses \EnumType\XASN1RoseOidEncoding::valueIsValid()
     * @uses \EnumType\XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return \StructType\XH323Trunk
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XASN1RoseOidEncoding', is_array($asn1RoseOidEncoding) ? implode(', ', $asn1RoseOidEncoding) : var_export($asn1RoseOidEncoding, true), implode(', ', \EnumType\XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @uses \EnumType\XQSIGVariant::valueIsValid()
     * @uses \EnumType\XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qsigVariant
     * @return \StructType\XH323Trunk
     */
    public function setQsigVariant($qsigVariant = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XQSIGVariant::valueIsValid($qsigVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XQSIGVariant', is_array($qsigVariant) ? implode(', ', $qsigVariant) : var_export($qsigVariant, true), implode(', ', \EnumType\XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \StructType\XH323Trunk
     */
    public function setTransmitUtf8($transmitUtf8 = 'false')
    {
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmitUtf8, true), gettype($transmitUtf8)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($transmitUtf8, true)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get signalingPort value
     * @return string|null
     */
    public function getSignalingPort()
    {
        return $this->signalingPort;
    }
    /**
     * Set signalingPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $signalingPort
     * @return \StructType\XH323Trunk
     */
    public function setSignalingPort($signalingPort = '1720')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($signalingPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($signalingPort) ? implode(', ', $signalingPort) : var_export($signalingPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->signalingPort = $signalingPort;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \StructType\XH323Trunk
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($nationalPrefix) && !is_string($nationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalPrefix, true), gettype($nationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($nationalPrefix) && mb_strlen($nationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($nationalPrefix)), __LINE__);
        }
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \StructType\XH323Trunk
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($internationalPrefix) && !is_string($internationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalPrefix, true), gettype($internationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($internationalPrefix) && mb_strlen($internationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($internationalPrefix)), __LINE__);
        }
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \StructType\XH323Trunk
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unknownPrefix, true), gettype($unknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unknownPrefix) && mb_strlen($unknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \StructType\XH323Trunk
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberPrefix) && !is_string($subscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberPrefix, true), gettype($subscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($subscriberPrefix) && mb_strlen($subscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($subscriberPrefix)), __LINE__);
        }
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \StructType\SigDigits $sigDigits
     * @return \StructType\XH323Trunk
     */
    public function setSigDigits(\StructType\SigDigits $sigDigits = '0')
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get prefixDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDn()
    {
        return isset($this->prefixDn) ? $this->prefixDn : null;
    }
    /**
     * Set prefixDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDn
     * @return \StructType\XH323Trunk
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDn, true), gettype($prefixDn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($prefixDn) && mb_strlen($prefixDn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($prefixDn)), __LINE__);
        }
        if (is_null($prefixDn) || (is_array($prefixDn) && empty($prefixDn))) {
            unset($this->prefixDn);
        } else {
            $this->prefixDn = $prefixDn;
        }
        return $this;
    }
    /**
     * Get calledPartyIeNumberType value
     * @return string|null
     */
    public function getCalledPartyIeNumberType()
    {
        return $this->calledPartyIeNumberType;
    }
    /**
     * Set calledPartyIeNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyIeNumberType
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyIeNumberType($calledPartyIeNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($calledPartyIeNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPriOfNumber', is_array($calledPartyIeNumberType) ? implode(', ', $calledPartyIeNumberType) : var_export($calledPartyIeNumberType, true), implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyIeNumberType = $calledPartyIeNumberType;
        return $this;
    }
    /**
     * Get callingPartyIeNumberType value
     * @return string|null
     */
    public function getCallingPartyIeNumberType()
    {
        return $this->callingPartyIeNumberType;
    }
    /**
     * Set callingPartyIeNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyIeNumberType
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartyIeNumberType($callingPartyIeNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($callingPartyIeNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPriOfNumber', is_array($callingPartyIeNumberType) ? implode(', ', $callingPartyIeNumberType) : var_export($callingPartyIeNumberType, true), implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyIeNumberType = $callingPartyIeNumberType;
        return $this;
    }
    /**
     * Get calledNumberingPlan value
     * @return string|null
     */
    public function getCalledNumberingPlan()
    {
        return $this->calledNumberingPlan;
    }
    /**
     * Set calledNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledNumberingPlan
     * @return \StructType\XH323Trunk
     */
    public function setCalledNumberingPlan($calledNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($calledNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XNumberingPlan', is_array($calledNumberingPlan) ? implode(', ', $calledNumberingPlan) : var_export($calledNumberingPlan, true), implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledNumberingPlan = $calledNumberingPlan;
        return $this;
    }
    /**
     * Get callingNumberingPlan value
     * @return string|null
     */
    public function getCallingNumberingPlan()
    {
        return $this->callingNumberingPlan;
    }
    /**
     * Set callingNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNumberingPlan
     * @return \StructType\XH323Trunk
     */
    public function setCallingNumberingPlan($callingNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($callingNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XNumberingPlan', is_array($callingNumberingPlan) ? implode(', ', $callingNumberingPlan) : var_export($callingNumberingPlan, true), implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingNumberingPlan = $callingNumberingPlan;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \StructType\XH323Trunk
     */
    public function setPathReplacementSupport($pathReplacementSupport = 'false')
    {
        // validation for constraint: string
        if (!is_null($pathReplacementSupport) && !is_string($pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pathReplacementSupport, true), gettype($pathReplacementSupport)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pathReplacementSupport) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pathReplacementSupport, true)), __LINE__);
        }
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get gateKeeperInfo value
     * @return \StructType\GateKeeperInfo|null
     */
    public function getGateKeeperInfo()
    {
        return isset($this->gateKeeperInfo) ? $this->gateKeeperInfo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGateKeeperInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGateKeeperInfo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGateKeeperInfoForChoiceConstraintsFromSetGateKeeperInfo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property gateKeeperInfo can\'t be set as the property %s is already set. Only one property must be set among these properties: gateKeeperInfo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set gateKeeperInfo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GateKeeperInfo $gateKeeperInfo
     * @return \StructType\XH323Trunk
     */
    public function setGateKeeperInfo(\StructType\GateKeeperInfo $gateKeeperInfo = null)
    {
        // validation for constraint: choice(gateKeeperInfo)
        if ('' !== ($gateKeeperInfoChoiceErrorMessage = self::validateGateKeeperInfoForChoiceConstraintsFromSetGateKeeperInfo($gateKeeperInfo))) {
            throw new \InvalidArgumentException($gateKeeperInfoChoiceErrorMessage, __LINE__);
        }
        if (is_null($gateKeeperInfo) || (is_array($gateKeeperInfo) && empty($gateKeeperInfo))) {
            unset($this->gateKeeperInfo);
        } else {
            $this->gateKeeperInfo = $gateKeeperInfo;
        }
        return $this;
    }
    /**
     * Get ictPassingPrecedenceLevelThroughUuie value
     * @return string|null
     */
    public function getIctPassingPrecedenceLevelThroughUuie()
    {
        return $this->ictPassingPrecedenceLevelThroughUuie;
    }
    /**
     * Set ictPassingPrecedenceLevelThroughUuie value
     * @param string $ictPassingPrecedenceLevelThroughUuie
     * @return \StructType\XH323Trunk
     */
    public function setIctPassingPrecedenceLevelThroughUuie($ictPassingPrecedenceLevelThroughUuie = null)
    {
        // validation for constraint: string
        if (!is_null($ictPassingPrecedenceLevelThroughUuie) && !is_string($ictPassingPrecedenceLevelThroughUuie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ictPassingPrecedenceLevelThroughUuie, true), gettype($ictPassingPrecedenceLevelThroughUuie)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($ictPassingPrecedenceLevelThroughUuie) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ictPassingPrecedenceLevelThroughUuie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($ictPassingPrecedenceLevelThroughUuie, true)), __LINE__);
        }
        $this->ictPassingPrecedenceLevelThroughUuie = $ictPassingPrecedenceLevelThroughUuie;
        return $this;
    }
    /**
     * Get ictSecurityAccessLevel value
     * @return string|null
     */
    public function getIctSecurityAccessLevel()
    {
        return $this->ictSecurityAccessLevel;
    }
    /**
     * Set ictSecurityAccessLevel value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ictSecurityAccessLevel
     * @return \StructType\XH323Trunk
     */
    public function setIctSecurityAccessLevel($ictSecurityAccessLevel = '2')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ictSecurityAccessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($ictSecurityAccessLevel) ? implode(', ', $ictSecurityAccessLevel) : var_export($ictSecurityAccessLevel, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ictSecurityAccessLevel = $ictSecurityAccessLevel;
        return $this;
    }
    /**
     * Get isSafEnabled value
     * @return string|null
     */
    public function getIsSafEnabled()
    {
        return $this->isSafEnabled;
    }
    /**
     * Set isSafEnabled value
     * @param string $isSafEnabled
     * @return \StructType\XH323Trunk
     */
    public function setIsSafEnabled($isSafEnabled = 'false')
    {
        // validation for constraint: string
        if (!is_null($isSafEnabled) && !is_string($isSafEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isSafEnabled, true), gettype($isSafEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isSafEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isSafEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isSafEnabled, true)), __LINE__);
        }
        $this->isSafEnabled = $isSafEnabled;
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return isset($this->callingPartyNationalStripDigits) ? $this->callingPartyNationalStripDigits : null;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNationalStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyNationalStripDigits) ? implode(', ', $callingPartyNationalStripDigits) : var_export($callingPartyNationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyNationalStripDigits) || (is_array($callingPartyNationalStripDigits) && empty($callingPartyNationalStripDigits))) {
            unset($this->callingPartyNationalStripDigits);
        } else {
            $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return isset($this->callingPartyInternationalStripDigits) ? $this->callingPartyInternationalStripDigits : null;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyInternationalStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyInternationalStripDigits) ? implode(', ', $callingPartyInternationalStripDigits) : var_export($callingPartyInternationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyInternationalStripDigits) || (is_array($callingPartyInternationalStripDigits) && empty($callingPartyInternationalStripDigits))) {
            unset($this->callingPartyInternationalStripDigits);
        } else {
            $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return isset($this->callingPartyUnknownStripDigits) ? $this->callingPartyUnknownStripDigits : null;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyUnknownStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartyUnknownStripDigits) ? implode(', ', $callingPartyUnknownStripDigits) : var_export($callingPartyUnknownStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyUnknownStripDigits) || (is_array($callingPartyUnknownStripDigits) && empty($callingPartyUnknownStripDigits))) {
            unset($this->callingPartyUnknownStripDigits);
        } else {
            $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return isset($this->callingPartySubscriberStripDigits) ? $this->callingPartySubscriberStripDigits : null;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySubscriberStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($callingPartySubscriberStripDigits) ? implode(', ', $callingPartySubscriberStripDigits) : var_export($callingPartySubscriberStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartySubscriberStripDigits) || (is_array($callingPartySubscriberStripDigits) && empty($callingPartySubscriberStripDigits))) {
            unset($this->callingPartySubscriberStripDigits);
        } else {
            $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return isset($this->callingPartyNationalTransformationCssName) ? $this->callingPartyNationalTransformationCssName : null;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartyNationalTransformationCssName(\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        if (is_null($callingPartyNationalTransformationCssName) || (is_array($callingPartyNationalTransformationCssName) && empty($callingPartyNationalTransformationCssName))) {
            unset($this->callingPartyNationalTransformationCssName);
        } else {
            $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return isset($this->callingPartyInternationalTransformationCssName) ? $this->callingPartyInternationalTransformationCssName : null;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartyInternationalTransformationCssName(\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        if (is_null($callingPartyInternationalTransformationCssName) || (is_array($callingPartyInternationalTransformationCssName) && empty($callingPartyInternationalTransformationCssName))) {
            unset($this->callingPartyInternationalTransformationCssName);
        } else {
            $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return isset($this->callingPartyUnknownTransformationCssName) ? $this->callingPartyUnknownTransformationCssName : null;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartyUnknownTransformationCssName(\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        if (is_null($callingPartyUnknownTransformationCssName) || (is_array($callingPartyUnknownTransformationCssName) && empty($callingPartyUnknownTransformationCssName))) {
            unset($this->callingPartyUnknownTransformationCssName);
        } else {
            $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return isset($this->callingPartySubscriberTransformationCssName) ? $this->callingPartySubscriberTransformationCssName : null;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCallingPartySubscriberTransformationCssName(\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        if (is_null($callingPartySubscriberTransformationCssName) || (is_array($callingPartySubscriberTransformationCssName) && empty($callingPartySubscriberTransformationCssName))) {
            unset($this->callingPartySubscriberTransformationCssName);
        } else {
            $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyNationalPrefix) && !is_string($calledPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyNationalPrefix, true), gettype($calledPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyNationalPrefix) && mb_strlen($calledPartyNationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyNationalPrefix)), __LINE__);
        }
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyInternationalPrefix) && !is_string($calledPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyInternationalPrefix, true), gettype($calledPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyInternationalPrefix) && mb_strlen($calledPartyInternationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyInternationalPrefix)), __LINE__);
        }
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartyUnknownPrefix, true), gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartyUnknownPrefix) && mb_strlen($calledPartyUnknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartySubscriberPrefix) && !is_string($calledPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calledPartySubscriberPrefix, true), gettype($calledPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($calledPartySubscriberPrefix) && mb_strlen($calledPartySubscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($calledPartySubscriberPrefix)), __LINE__);
        }
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \StructType\XH323Trunk
     */
    public function setPstnAccess($pstnAccess = 'true')
    {
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnAccess, true), gettype($pstnAccess)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($pstnAccess, true)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $imeE164TransformationName
     * @return \StructType\XH323Trunk
     */
    public function setImeE164TransformationName(\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\XH323Trunk
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !is_string($useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssNatl, true), gettype($useDevicePoolCgpnTransformCssNatl)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssNatl, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !is_string($useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssIntl, true), gettype($useDevicePoolCgpnTransformCssIntl)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssIntl, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssUnkn, true), gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !is_string($useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCssSubs, true), gettype($useDevicePoolCgpnTransformCssSubs)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCssSubs, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssNatl()
    {
        return $this->useDevicePoolCalledCssNatl;
    }
    /**
     * Set useDevicePoolCalledCssNatl value
     * @param string $useDevicePoolCalledCssNatl
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssNatl) && !is_string($useDevicePoolCalledCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCalledCssNatl, true), gettype($useDevicePoolCalledCssNatl)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCalledCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCalledCssNatl, true)), __LINE__);
        }
        $this->useDevicePoolCalledCssNatl = $useDevicePoolCalledCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssIntl()
    {
        return $this->useDevicePoolCalledCssIntl;
    }
    /**
     * Set useDevicePoolCalledCssIntl value
     * @param string $useDevicePoolCalledCssIntl
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssIntl) && !is_string($useDevicePoolCalledCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCalledCssIntl, true), gettype($useDevicePoolCalledCssIntl)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCalledCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCalledCssIntl, true)), __LINE__);
        }
        $this->useDevicePoolCalledCssIntl = $useDevicePoolCalledCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssUnkn) && !is_string($useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCalledCssUnkn, true), gettype($useDevicePoolCalledCssUnkn)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCalledCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCalledCssUnkn, true)), __LINE__);
        }
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssSubs()
    {
        return $this->useDevicePoolCalledCssSubs;
    }
    /**
     * Set useDevicePoolCalledCssSubs value
     * @param string $useDevicePoolCalledCssSubs
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssSubs) && !is_string($useDevicePoolCalledCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCalledCssSubs, true), gettype($useDevicePoolCalledCssSubs)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCalledCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCalledCssSubs, true)), __LINE__);
        }
        $this->useDevicePoolCalledCssSubs = $useDevicePoolCalledCssSubs;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return isset($this->calledPartyNationalStripDigits) ? $this->calledPartyNationalStripDigits : null;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNationalStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyNationalStripDigits) ? implode(', ', $calledPartyNationalStripDigits) : var_export($calledPartyNationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyNationalStripDigits) || (is_array($calledPartyNationalStripDigits) && empty($calledPartyNationalStripDigits))) {
            unset($this->calledPartyNationalStripDigits);
        } else {
            $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return isset($this->calledPartyInternationalStripDigits) ? $this->calledPartyInternationalStripDigits : null;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyInternationalStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyInternationalStripDigits) ? implode(', ', $calledPartyInternationalStripDigits) : var_export($calledPartyInternationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyInternationalStripDigits) || (is_array($calledPartyInternationalStripDigits) && empty($calledPartyInternationalStripDigits))) {
            unset($this->calledPartyInternationalStripDigits);
        } else {
            $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartyUnknownStripDigits) ? implode(', ', $calledPartyUnknownStripDigits) : var_export($calledPartyUnknownStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return isset($this->calledPartySubscriberStripDigits) ? $this->calledPartySubscriberStripDigits : null;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartySubscriberStripDigits
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($calledPartySubscriberStripDigits) ? implode(', ', $calledPartySubscriberStripDigits) : var_export($calledPartySubscriberStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartySubscriberStripDigits) || (is_array($calledPartySubscriberStripDigits) && empty($calledPartySubscriberStripDigits))) {
            unset($this->calledPartySubscriberStripDigits);
        } else {
            $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return isset($this->calledPartyNationalTransformationCssName) ? $this->calledPartyNationalTransformationCssName : null;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyNationalTransformationCssName(\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        if (is_null($calledPartyNationalTransformationCssName) || (is_array($calledPartyNationalTransformationCssName) && empty($calledPartyNationalTransformationCssName))) {
            unset($this->calledPartyNationalTransformationCssName);
        } else {
            $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return isset($this->calledPartyInternationalTransformationCssName) ? $this->calledPartyInternationalTransformationCssName : null;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyInternationalTransformationCssName(\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        if (is_null($calledPartyInternationalTransformationCssName) || (is_array($calledPartyInternationalTransformationCssName) && empty($calledPartyInternationalTransformationCssName))) {
            unset($this->calledPartyInternationalTransformationCssName);
        } else {
            $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartyUnknownTransformationCssName(\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return isset($this->calledPartySubscriberTransformationCssName) ? $this->calledPartySubscriberTransformationCssName : null;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCalledPartySubscriberTransformationCssName(\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        if (is_null($calledPartySubscriberTransformationCssName) || (is_array($calledPartySubscriberTransformationCssName) && empty($calledPartySubscriberTransformationCssName))) {
            unset($this->calledPartySubscriberTransformationCssName);
        } else {
            $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return \StructType\XH323Trunk
     */
    public function setRunOnEveryNode($runOnEveryNode = 'false')
    {
        // validation for constraint: string
        if (!is_null($runOnEveryNode) && !is_string($runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runOnEveryNode, true), gettype($runOnEveryNode)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($runOnEveryNode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($runOnEveryNode, true)), __LINE__);
        }
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Get destinations value
     * @return \StructType\Destinations|null
     */
    public function getDestinations()
    {
        return $this->destinations;
    }
    /**
     * Set destinations value
     * @param \StructType\Destinations $destinations
     * @return \StructType\XH323Trunk
     */
    public function setDestinations(\StructType\Destinations $destinations = null)
    {
        $this->destinations = $destinations;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return \StructType\XH323Trunk
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = 'true')
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !is_string($useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCntdPnTransformationCss, true), gettype($useDevicePoolCntdPnTransformationCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCntdPnTransformationCss, true)), __LINE__);
        }
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @return \StructType\XH323Trunk
     */
    public function setCntdPnTransformationCssName(\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\XH323Trunk
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\XH323Trunk
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
}
