<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGatewaySubunits StructType
 * @subpackage Structs
 */
class XGatewaySubunits extends AbstractStructBase
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta information extracted from the WSDL
     * - documentation: pkid of the Gateway
     * - base: xsd:string
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $unit;
    /**
     * The subunits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Subunits
     */
    public $subunits;
    /**
     * Constructor method for XGatewaySubunits
     * @uses XGatewaySubunits::setDomainName()
     * @uses XGatewaySubunits::setGatewayUuid()
     * @uses XGatewaySubunits::setUnit()
     * @uses XGatewaySubunits::setSubunits()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param string $unit
     * @param \StructType\Subunits $subunits
     */
    public function __construct($domainName = null, $gatewayUuid = null, $unit = '0', \StructType\Subunits $subunits = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnit($unit)
            ->setSubunits($subunits);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDomainName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDomainName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDomainNameForChoiceConstraintsFromSetDomainName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'gatewayUuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property domainName can\'t be set as the property %s is already set. Only one property must be set among these properties: domainName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $domainName
     * @return \StructType\XGatewaySubunits
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainName, true), gettype($domainName)), __LINE__);
        }
        // validation for constraint: choice(domainName, gatewayUuid)
        if ('' !== ($domainNameChoiceErrorMessage = self::validateDomainNameForChoiceConstraintsFromSetDomainName($domainName))) {
            throw new \InvalidArgumentException($domainNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string
     */
    public function getGatewayUuid()
    {
        return isset($this->gatewayUuid) ? $this->gatewayUuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGatewayUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGatewayUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGatewayUuidForChoiceConstraintsFromSetGatewayUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'domainName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property gatewayUuid can\'t be set as the property %s is already set. Only one property must be set among these properties: gatewayUuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set gatewayUuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $gatewayUuid
     * @return \StructType\XGatewaySubunits
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        // validation for constraint: string
        if (!is_null($gatewayUuid) && !is_string($gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatewayUuid, true), gettype($gatewayUuid)), __LINE__);
        }
        // validation for constraint: choice(domainName, gatewayUuid)
        if ('' !== ($gatewayUuidChoiceErrorMessage = self::validateGatewayUuidForChoiceConstraintsFromSetGatewayUuid($gatewayUuid))) {
            throw new \InvalidArgumentException($gatewayUuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($gatewayUuid) && !preg_match('/\\{........-....-....-....-............\\}/', $gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($gatewayUuid, true)), __LINE__);
        }
        if (is_null($gatewayUuid) || (is_array($gatewayUuid) && empty($gatewayUuid))) {
            unset($this->gatewayUuid);
        } else {
            $this->gatewayUuid = $gatewayUuid;
        }
        return $this;
    }
    /**
     * Get unit value
     * @return string
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\XGatewaySubunits
     */
    public function setUnit($unit = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($unit) ? implode(', ', $unit) : var_export($unit, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunits value
     * @return \StructType\Subunits
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \StructType\Subunits $subunits
     * @return \StructType\XGatewaySubunits
     */
    public function setSubunits(\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
}
