<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XFeatureControlPolicy StructType
 * @subpackage Structs
 */
class XFeatureControlPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The features
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Features
     */
    public $features;
    /**
     * Constructor method for XFeatureControlPolicy
     * @uses XFeatureControlPolicy::setName()
     * @uses XFeatureControlPolicy::setDescription()
     * @uses XFeatureControlPolicy::setFeatures()
     * @param string $name
     * @param string $description
     * @param \StructType\Features $features
     */
    public function __construct($name = null, $description = null, \StructType\Features $features = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFeatures($features);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XFeatureControlPolicy
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XFeatureControlPolicy
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($description) && mb_strlen($description) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get features value
     * @return \StructType\Features|null
     */
    public function getFeatures()
    {
        return $this->features;
    }
    /**
     * Set features value
     * @param \StructType\Features $features
     * @return \StructType\XFeatureControlPolicy
     */
    public function setFeatures(\StructType\Features $features = null)
    {
        $this->features = $features;
        return $this;
    }
}
