<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XEnterpriseAltNum StructType
 * @subpackage Structs
 */
class XEnterpriseAltNum extends AbstractStructBase
{
    /**
     * The numberMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numberMask;
    /**
     * The addToLocalRoutePartition
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $addToLocalRoutePartition;
    /**
     * The routePartition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartition;
    /**
     * The isUrgent
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isUrgent;
    /**
     * The advertiseGloballyIls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $advertiseGloballyIls;
    /**
     * Constructor method for XEnterpriseAltNum
     * @uses XEnterpriseAltNum::setNumberMask()
     * @uses XEnterpriseAltNum::setAddToLocalRoutePartition()
     * @uses XEnterpriseAltNum::setRoutePartition()
     * @uses XEnterpriseAltNum::setIsUrgent()
     * @uses XEnterpriseAltNum::setAdvertiseGloballyIls()
     * @param string $numberMask
     * @param string $addToLocalRoutePartition
     * @param \StructType\XFkType $routePartition
     * @param string $isUrgent
     * @param string $advertiseGloballyIls
     */
    public function __construct($numberMask = null, $addToLocalRoutePartition = null, \StructType\XFkType $routePartition = null, $isUrgent = null, $advertiseGloballyIls = null)
    {
        $this
            ->setNumberMask($numberMask)
            ->setAddToLocalRoutePartition($addToLocalRoutePartition)
            ->setRoutePartition($routePartition)
            ->setIsUrgent($isUrgent)
            ->setAdvertiseGloballyIls($advertiseGloballyIls);
    }
    /**
     * Get numberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberMask()
    {
        return isset($this->numberMask) ? $this->numberMask : null;
    }
    /**
     * Set numberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberMask
     * @return \StructType\XEnterpriseAltNum
     */
    public function setNumberMask($numberMask = null)
    {
        // validation for constraint: string
        if (!is_null($numberMask) && !is_string($numberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberMask, true), gettype($numberMask)), __LINE__);
        }
        if (is_null($numberMask) || (is_array($numberMask) && empty($numberMask))) {
            unset($this->numberMask);
        } else {
            $this->numberMask = $numberMask;
        }
        return $this;
    }
    /**
     * Get addToLocalRoutePartition value
     * @return string|null
     */
    public function getAddToLocalRoutePartition()
    {
        return $this->addToLocalRoutePartition;
    }
    /**
     * Set addToLocalRoutePartition value
     * @param string $addToLocalRoutePartition
     * @return \StructType\XEnterpriseAltNum
     */
    public function setAddToLocalRoutePartition($addToLocalRoutePartition = null)
    {
        // validation for constraint: string
        if (!is_null($addToLocalRoutePartition) && !is_string($addToLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addToLocalRoutePartition, true), gettype($addToLocalRoutePartition)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($addToLocalRoutePartition) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $addToLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($addToLocalRoutePartition, true)), __LINE__);
        }
        $this->addToLocalRoutePartition = $addToLocalRoutePartition;
        return $this;
    }
    /**
     * Get routePartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return isset($this->routePartition) ? $this->routePartition : null;
    }
    /**
     * Set routePartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routePartition
     * @return \StructType\XEnterpriseAltNum
     */
    public function setRoutePartition(\StructType\XFkType $routePartition = null)
    {
        if (is_null($routePartition) || (is_array($routePartition) && empty($routePartition))) {
            unset($this->routePartition);
        } else {
            $this->routePartition = $routePartition;
        }
        return $this;
    }
    /**
     * Get isUrgent value
     * @return string|null
     */
    public function getIsUrgent()
    {
        return $this->isUrgent;
    }
    /**
     * Set isUrgent value
     * @param string $isUrgent
     * @return \StructType\XEnterpriseAltNum
     */
    public function setIsUrgent($isUrgent = null)
    {
        // validation for constraint: string
        if (!is_null($isUrgent) && !is_string($isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isUrgent, true), gettype($isUrgent)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isUrgent) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isUrgent, true)), __LINE__);
        }
        $this->isUrgent = $isUrgent;
        return $this;
    }
    /**
     * Get advertiseGloballyIls value
     * @return string|null
     */
    public function getAdvertiseGloballyIls()
    {
        return $this->advertiseGloballyIls;
    }
    /**
     * Set advertiseGloballyIls value
     * @param string $advertiseGloballyIls
     * @return \StructType\XEnterpriseAltNum
     */
    public function setAdvertiseGloballyIls($advertiseGloballyIls = null)
    {
        // validation for constraint: string
        if (!is_null($advertiseGloballyIls) && !is_string($advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advertiseGloballyIls, true), gettype($advertiseGloballyIls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($advertiseGloballyIls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($advertiseGloballyIls, true)), __LINE__);
        }
        $this->advertiseGloballyIls = $advertiseGloballyIls;
        return $this;
    }
}
