<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XEmccFeatureConfig StructType
 * @subpackage Structs
 */
class XEmccFeatureConfig extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: Name of the Emcc Parameter
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $parameterName;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * Constructor method for XEmccFeatureConfig
     * @uses XEmccFeatureConfig::setParameterName()
     * @uses XEmccFeatureConfig::setValue()
     * @param string $parameterName
     * @param string $value
     */
    public function __construct($parameterName = null, $value = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setValue($value);
    }
    /**
     * Get parameterName value
     * @return string
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return \StructType\XEmccFeatureConfig
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($parameterName) && mb_strlen($parameterName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($parameterName)), __LINE__);
        }
        $this->parameterName = $parameterName;
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\XEmccFeatureConfig
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($value) && mb_strlen($value) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
}
