<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVpnGatewayReq StructType
 * @subpackage Structs
 */
class UpdateVpnGatewayReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $url;
    /**
     * The certificates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Certificates
     */
    public $certificates;
    /**
     * Constructor method for UpdateVpnGatewayReq
     * @uses UpdateVpnGatewayReq::setNewName()
     * @uses UpdateVpnGatewayReq::setDescription()
     * @uses UpdateVpnGatewayReq::setUrl()
     * @uses UpdateVpnGatewayReq::setCertificates()
     * @param string $newName
     * @param string $description
     * @param string $url
     * @param \StructType\Certificates $certificates
     */
    public function __construct($newName = null, $description = null, $url = null, \StructType\Certificates $certificates = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setUrl($url)
            ->setCertificates($certificates);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateVpnGatewayReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateVpnGatewayReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\UpdateVpnGatewayReq
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($url) && mb_strlen($url) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get certificates value
     * @return \StructType\Certificates|null
     */
    public function getCertificates()
    {
        return $this->certificates;
    }
    /**
     * Set certificates value
     * @param \StructType\Certificates $certificates
     * @return \StructType\UpdateVpnGatewayReq
     */
    public function setCertificates(\StructType\Certificates $certificates = null)
    {
        $this->certificates = $certificates;
        return $this;
    }
}
