<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVoiceMailProfileReq StructType
 * @subpackage Structs
 */
class UpdateVoiceMailProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailProfile as Default. Instead, the corresponding tag of another VoiceMailProfile should be set to true.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The voiceMailboxMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voiceMailboxMask;
    /**
     * The voiceMailPilot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVmPilot
     */
    public $voiceMailPilot;
    /**
     * Constructor method for UpdateVoiceMailProfileReq
     * @uses UpdateVoiceMailProfileReq::setNewName()
     * @uses UpdateVoiceMailProfileReq::setDescription()
     * @uses UpdateVoiceMailProfileReq::setIsDefault()
     * @uses UpdateVoiceMailProfileReq::setVoiceMailboxMask()
     * @uses UpdateVoiceMailProfileReq::setVoiceMailPilot()
     * @param string $newName
     * @param string $description
     * @param string $isDefault
     * @param string $voiceMailboxMask
     * @param \StructType\XVmPilot $voiceMailPilot
     */
    public function __construct($newName = null, $description = null, $isDefault = 'false', $voiceMailboxMask = null, \StructType\XVmPilot $voiceMailPilot = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setVoiceMailboxMask($voiceMailboxMask)
            ->setVoiceMailPilot($voiceMailPilot);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateVoiceMailProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateVoiceMailProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\UpdateVoiceMailProfileReq
     */
    public function setIsDefault($isDefault = 'false')
    {
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isDefault, true)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get voiceMailboxMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoiceMailboxMask()
    {
        return isset($this->voiceMailboxMask) ? $this->voiceMailboxMask : null;
    }
    /**
     * Set voiceMailboxMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voiceMailboxMask
     * @return \StructType\UpdateVoiceMailProfileReq
     */
    public function setVoiceMailboxMask($voiceMailboxMask = null)
    {
        // validation for constraint: string
        if (!is_null($voiceMailboxMask) && !is_string($voiceMailboxMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voiceMailboxMask, true), gettype($voiceMailboxMask)), __LINE__);
        }
        if (is_null($voiceMailboxMask) || (is_array($voiceMailboxMask) && empty($voiceMailboxMask))) {
            unset($this->voiceMailboxMask);
        } else {
            $this->voiceMailboxMask = $voiceMailboxMask;
        }
        return $this;
    }
    /**
     * Get voiceMailPilot value
     * @return \StructType\XVmPilot|null
     */
    public function getVoiceMailPilot()
    {
        return $this->voiceMailPilot;
    }
    /**
     * Set voiceMailPilot value
     * @param \StructType\XVmPilot $voiceMailPilot
     * @return \StructType\UpdateVoiceMailProfileReq
     */
    public function setVoiceMailPilot(\StructType\XVmPilot $voiceMailPilot = null)
    {
        $this->voiceMailPilot = $voiceMailPilot;
        return $this;
    }
}
