<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserProfileProvisionReq StructType
 * @subpackage Structs
 */
class UpdateUserProfileProvisionReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The deskPhones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $deskPhones;
    /**
     * The mobileDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $mobileDevices;
    /**
     * The profile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $profile;
    /**
     * The universalLineTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $universalLineTemplate;
    /**
     * The allowProvision
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowProvision;
    /**
     * The limitProvision
     * Meta information extracted from the WSDL
     * - default: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $limitProvision;
    /**
     * The defaultUserProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $defaultUserProfile;
    /**
     * Constructor method for UpdateUserProfileProvisionReq
     * @uses UpdateUserProfileProvisionReq::setNewName()
     * @uses UpdateUserProfileProvisionReq::setDescription()
     * @uses UpdateUserProfileProvisionReq::setDeskPhones()
     * @uses UpdateUserProfileProvisionReq::setMobileDevices()
     * @uses UpdateUserProfileProvisionReq::setProfile()
     * @uses UpdateUserProfileProvisionReq::setUniversalLineTemplate()
     * @uses UpdateUserProfileProvisionReq::setAllowProvision()
     * @uses UpdateUserProfileProvisionReq::setLimitProvision()
     * @uses UpdateUserProfileProvisionReq::setDefaultUserProfile()
     * @param string $newName
     * @param string $description
     * @param \StructType\XFkType $deskPhones
     * @param \StructType\XFkType $mobileDevices
     * @param \StructType\XFkType $profile
     * @param \StructType\XFkType $universalLineTemplate
     * @param string $allowProvision
     * @param string $limitProvision
     * @param \StructType\XFkType $defaultUserProfile
     */
    public function __construct($newName = null, $description = null, \StructType\XFkType $deskPhones = null, \StructType\XFkType $mobileDevices = null, \StructType\XFkType $profile = null, \StructType\XFkType $universalLineTemplate = null, $allowProvision = 'false', $limitProvision = '10', \StructType\XFkType $defaultUserProfile = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDeskPhones($deskPhones)
            ->setMobileDevices($mobileDevices)
            ->setProfile($profile)
            ->setUniversalLineTemplate($universalLineTemplate)
            ->setAllowProvision($allowProvision)
            ->setLimitProvision($limitProvision)
            ->setDefaultUserProfile($defaultUserProfile);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deskPhones value
     * @return \StructType\XFkType|null
     */
    public function getDeskPhones()
    {
        return $this->deskPhones;
    }
    /**
     * Set deskPhones value
     * @param \StructType\XFkType $deskPhones
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setDeskPhones(\StructType\XFkType $deskPhones = null)
    {
        $this->deskPhones = $deskPhones;
        return $this;
    }
    /**
     * Get mobileDevices value
     * @return \StructType\XFkType|null
     */
    public function getMobileDevices()
    {
        return $this->mobileDevices;
    }
    /**
     * Set mobileDevices value
     * @param \StructType\XFkType $mobileDevices
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setMobileDevices(\StructType\XFkType $mobileDevices = null)
    {
        $this->mobileDevices = $mobileDevices;
        return $this;
    }
    /**
     * Get profile value
     * @return \StructType\XFkType|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param \StructType\XFkType $profile
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setProfile(\StructType\XFkType $profile = null)
    {
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get universalLineTemplate value
     * @return \StructType\XFkType|null
     */
    public function getUniversalLineTemplate()
    {
        return $this->universalLineTemplate;
    }
    /**
     * Set universalLineTemplate value
     * @param \StructType\XFkType $universalLineTemplate
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setUniversalLineTemplate(\StructType\XFkType $universalLineTemplate = null)
    {
        $this->universalLineTemplate = $universalLineTemplate;
        return $this;
    }
    /**
     * Get allowProvision value
     * @return string|null
     */
    public function getAllowProvision()
    {
        return $this->allowProvision;
    }
    /**
     * Set allowProvision value
     * @param string $allowProvision
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setAllowProvision($allowProvision = 'false')
    {
        // validation for constraint: string
        if (!is_null($allowProvision) && !is_string($allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowProvision, true), gettype($allowProvision)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowProvision) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowProvision, true)), __LINE__);
        }
        $this->allowProvision = $allowProvision;
        return $this;
    }
    /**
     * Get limitProvision value
     * @return string|null
     */
    public function getLimitProvision()
    {
        return $this->limitProvision;
    }
    /**
     * Set limitProvision value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $limitProvision
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setLimitProvision($limitProvision = '10')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($limitProvision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($limitProvision) ? implode(', ', $limitProvision) : var_export($limitProvision, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->limitProvision = $limitProvision;
        return $this;
    }
    /**
     * Get defaultUserProfile value
     * @return \StructType\XFkType|null
     */
    public function getDefaultUserProfile()
    {
        return $this->defaultUserProfile;
    }
    /**
     * Set defaultUserProfile value
     * @param \StructType\XFkType $defaultUserProfile
     * @return \StructType\UpdateUserProfileProvisionReq
     */
    public function setDefaultUserProfile(\StructType\XFkType $defaultUserProfile = null)
    {
        $this->defaultUserProfile = $defaultUserProfile;
        return $this;
    }
}
