<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTimePeriodReq StructType
 * @subpackage Structs
 */
class UpdateTimePeriodReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endTime;
    /**
     * The startDay
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endDay;
    /**
     * The monthOfYear
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYear;
    /**
     * The dayOfMonth
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonth;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The dayOfMonthEnd
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonthEnd;
    /**
     * The monthOfYearEnd
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYearEnd;
    /**
     * Constructor method for UpdateTimePeriodReq
     * @uses UpdateTimePeriodReq::setNewName()
     * @uses UpdateTimePeriodReq::setStartTime()
     * @uses UpdateTimePeriodReq::setEndTime()
     * @uses UpdateTimePeriodReq::setStartDay()
     * @uses UpdateTimePeriodReq::setEndDay()
     * @uses UpdateTimePeriodReq::setMonthOfYear()
     * @uses UpdateTimePeriodReq::setDayOfMonth()
     * @uses UpdateTimePeriodReq::setDescription()
     * @uses UpdateTimePeriodReq::setDayOfMonthEnd()
     * @uses UpdateTimePeriodReq::setMonthOfYearEnd()
     * @param string $newName
     * @param string $startTime
     * @param string $endTime
     * @param string $startDay
     * @param string $endDay
     * @param string $monthOfYear
     * @param string $dayOfMonth
     * @param string $description
     * @param string $dayOfMonthEnd
     * @param string $monthOfYearEnd
     */
    public function __construct($newName = null, $startTime = 'No Office Hours', $endTime = 'No Office Hours', $startDay = 'None', $endDay = 'None', $monthOfYear = 'None', $dayOfMonth = '0', $description = null, $dayOfMonthEnd = '0', $monthOfYearEnd = 'None')
    {
        $this
            ->setNewName($newName)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setMonthOfYear($monthOfYear)
            ->setDayOfMonth($dayOfMonth)
            ->setDescription($description)
            ->setDayOfMonthEnd($dayOfMonthEnd)
            ->setMonthOfYearEnd($monthOfYearEnd);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startTime
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setStartTime($startTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeOfDay', is_array($startTime) ? implode(', ', $startTime) : var_export($startTime, true), implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTime
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setEndTime($endTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeOfDay', is_array($endTime) ? implode(', ', $endTime) : var_export($endTime, true), implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDay
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setStartDay($startDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDayOfWeek', is_array($startDay) ? implode(', ', $startDay) : var_export($startDay, true), implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endDay
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setEndDay($endDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($endDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDayOfWeek', is_array($endDay) ? implode(', ', $endDay) : var_export($endDay, true), implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get monthOfYear value
     * @return string|null
     */
    public function getMonthOfYear()
    {
        return $this->monthOfYear;
    }
    /**
     * Set monthOfYear value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYear
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setMonthOfYear($monthOfYear = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMonthOfYear', is_array($monthOfYear) ? implode(', ', $monthOfYear) : var_export($monthOfYear, true), implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYear = $monthOfYear;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string|null
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonth
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setDayOfMonth($dayOfMonth = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dayOfMonth) ? implode(', ', $dayOfMonth) : var_export($dayOfMonth, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dayOfMonthEnd value
     * @return string|null
     */
    public function getDayOfMonthEnd()
    {
        return $this->dayOfMonthEnd;
    }
    /**
     * Set dayOfMonthEnd value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonthEnd
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setDayOfMonthEnd($dayOfMonthEnd = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonthEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($dayOfMonthEnd) ? implode(', ', $dayOfMonthEnd) : var_export($dayOfMonthEnd, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonthEnd = $dayOfMonthEnd;
        return $this;
    }
    /**
     * Get monthOfYearEnd value
     * @return string|null
     */
    public function getMonthOfYearEnd()
    {
        return $this->monthOfYearEnd;
    }
    /**
     * Set monthOfYearEnd value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYearEnd
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setMonthOfYearEnd($monthOfYearEnd = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMonthOfYear', is_array($monthOfYearEnd) ? implode(', ', $monthOfYearEnd) : var_export($monthOfYearEnd, true), implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYearEnd = $monthOfYearEnd;
        return $this;
    }
}
