<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSyslogConfigurationRes StructType
 * @subpackage Structs
 */
class UpdateSyslogConfigurationRes extends APIResponse
{
    /**
     * The message
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * @var string
     */
    public $message;
    /**
     * Constructor method for UpdateSyslogConfigurationRes
     * @uses UpdateSyslogConfigurationRes::setMessage()
     * @param string $message
     */
    public function __construct($message = null)
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\UpdateSyslogConfigurationRes
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($message) && mb_strlen($message) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
