<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateServiceProfileReq StructType
 * @subpackage Structs
 */
class UpdateServiceProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The serviceProfileInfos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceProfileInfos
     */
    public $serviceProfileInfos;
    /**
     * Constructor method for UpdateServiceProfileReq
     * @uses UpdateServiceProfileReq::setNewName()
     * @uses UpdateServiceProfileReq::setDescription()
     * @uses UpdateServiceProfileReq::setIsDefault()
     * @uses UpdateServiceProfileReq::setServiceProfileInfos()
     * @param string $newName
     * @param string $description
     * @param string $isDefault
     * @param \StructType\ServiceProfileInfos $serviceProfileInfos
     */
    public function __construct($newName = null, $description = null, $isDefault = null, \StructType\ServiceProfileInfos $serviceProfileInfos = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setServiceProfileInfos($serviceProfileInfos);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateServiceProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateServiceProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\UpdateServiceProfileReq
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isDefault, true)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get serviceProfileInfos value
     * @return \StructType\ServiceProfileInfos|null
     */
    public function getServiceProfileInfos()
    {
        return $this->serviceProfileInfos;
    }
    /**
     * Set serviceProfileInfos value
     * @param \StructType\ServiceProfileInfos $serviceProfileInfos
     * @return \StructType\UpdateServiceProfileReq
     */
    public function setServiceProfileInfos(\StructType\ServiceProfileInfos $serviceProfileInfos = null)
    {
        $this->serviceProfileInfos = $serviceProfileInfos;
        return $this;
    }
}
