<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSelfProvisioningReq StructType
 * @subpackage Structs
 */
class UpdateSelfProvisioningReq extends APIRequest
{
    /**
     * The requireAuthentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requireAuthentication;
    /**
     * The allowAuthentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $allowAuthentication;
    /**
     * The authenticationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $authenticationCode;
    /**
     * The ctiRoutePoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ctiRoutePoint;
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $applicationUser;
    /**
     * The removeLanguages
     * Meta information extracted from the WSDL
     * - choice: removeLanguages | addLanguages | languages
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveLanguages
     */
    public $removeLanguages;
    /**
     * The addLanguages
     * Meta information extracted from the WSDL
     * - choice: removeLanguages | addLanguages | languages
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddLanguages
     */
    public $addLanguages;
    /**
     * The languages
     * Meta information extracted from the WSDL
     * - choice: removeLanguages | addLanguages | languages
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Languages
     */
    public $languages;
    /**
     * Constructor method for UpdateSelfProvisioningReq
     * @uses UpdateSelfProvisioningReq::setRequireAuthentication()
     * @uses UpdateSelfProvisioningReq::setAllowAuthentication()
     * @uses UpdateSelfProvisioningReq::setAuthenticationCode()
     * @uses UpdateSelfProvisioningReq::setCtiRoutePoint()
     * @uses UpdateSelfProvisioningReq::setApplicationUser()
     * @uses UpdateSelfProvisioningReq::setRemoveLanguages()
     * @uses UpdateSelfProvisioningReq::setAddLanguages()
     * @uses UpdateSelfProvisioningReq::setLanguages()
     * @param string $requireAuthentication
     * @param string $allowAuthentication
     * @param string $authenticationCode
     * @param string $ctiRoutePoint
     * @param string $applicationUser
     * @param \StructType\RemoveLanguages $removeLanguages
     * @param \StructType\AddLanguages $addLanguages
     * @param \StructType\Languages $languages
     */
    public function __construct($requireAuthentication = null, $allowAuthentication = null, $authenticationCode = null, $ctiRoutePoint = null, $applicationUser = null, \StructType\RemoveLanguages $removeLanguages = null, \StructType\AddLanguages $addLanguages = null, \StructType\Languages $languages = null)
    {
        $this
            ->setRequireAuthentication($requireAuthentication)
            ->setAllowAuthentication($allowAuthentication)
            ->setAuthenticationCode($authenticationCode)
            ->setCtiRoutePoint($ctiRoutePoint)
            ->setApplicationUser($applicationUser)
            ->setRemoveLanguages($removeLanguages)
            ->setAddLanguages($addLanguages)
            ->setLanguages($languages);
    }
    /**
     * Get requireAuthentication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequireAuthentication()
    {
        return isset($this->requireAuthentication) ? $this->requireAuthentication : null;
    }
    /**
     * Set requireAuthentication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requireAuthentication
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setRequireAuthentication($requireAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($requireAuthentication) && !is_string($requireAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requireAuthentication, true), gettype($requireAuthentication)), __LINE__);
        }
        if (is_null($requireAuthentication) || (is_array($requireAuthentication) && empty($requireAuthentication))) {
            unset($this->requireAuthentication);
        } else {
            $this->requireAuthentication = $requireAuthentication;
        }
        return $this;
    }
    /**
     * Get allowAuthentication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowAuthentication()
    {
        return isset($this->allowAuthentication) ? $this->allowAuthentication : null;
    }
    /**
     * Set allowAuthentication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowAuthentication
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setAllowAuthentication($allowAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($allowAuthentication) && !is_string($allowAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowAuthentication, true), gettype($allowAuthentication)), __LINE__);
        }
        if (is_null($allowAuthentication) || (is_array($allowAuthentication) && empty($allowAuthentication))) {
            unset($this->allowAuthentication);
        } else {
            $this->allowAuthentication = $allowAuthentication;
        }
        return $this;
    }
    /**
     * Get authenticationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthenticationCode()
    {
        return isset($this->authenticationCode) ? $this->authenticationCode : null;
    }
    /**
     * Set authenticationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authenticationCode
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setAuthenticationCode($authenticationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationCode) && !is_string($authenticationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationCode, true), gettype($authenticationCode)), __LINE__);
        }
        if (is_null($authenticationCode) || (is_array($authenticationCode) && empty($authenticationCode))) {
            unset($this->authenticationCode);
        } else {
            $this->authenticationCode = $authenticationCode;
        }
        return $this;
    }
    /**
     * Get ctiRoutePoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCtiRoutePoint()
    {
        return isset($this->ctiRoutePoint) ? $this->ctiRoutePoint : null;
    }
    /**
     * Set ctiRoutePoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ctiRoutePoint
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setCtiRoutePoint($ctiRoutePoint = null)
    {
        // validation for constraint: string
        if (!is_null($ctiRoutePoint) && !is_string($ctiRoutePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ctiRoutePoint, true), gettype($ctiRoutePoint)), __LINE__);
        }
        if (is_null($ctiRoutePoint) || (is_array($ctiRoutePoint) && empty($ctiRoutePoint))) {
            unset($this->ctiRoutePoint);
        } else {
            $this->ctiRoutePoint = $ctiRoutePoint;
        }
        return $this;
    }
    /**
     * Get applicationUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationUser()
    {
        return isset($this->applicationUser) ? $this->applicationUser : null;
    }
    /**
     * Set applicationUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationUser
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setApplicationUser($applicationUser = null)
    {
        // validation for constraint: string
        if (!is_null($applicationUser) && !is_string($applicationUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationUser, true), gettype($applicationUser)), __LINE__);
        }
        if (is_null($applicationUser) || (is_array($applicationUser) && empty($applicationUser))) {
            unset($this->applicationUser);
        } else {
            $this->applicationUser = $applicationUser;
        }
        return $this;
    }
    /**
     * Get removeLanguages value
     * @return \StructType\RemoveLanguages|null
     */
    public function getRemoveLanguages()
    {
        return isset($this->removeLanguages) ? $this->removeLanguages : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveLanguages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveLanguages method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveLanguagesForChoiceConstraintsFromSetRemoveLanguages($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addLanguages',
            'languages',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeLanguages can\'t be set as the property %s is already set. Only one property must be set among these properties: removeLanguages, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeLanguages value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RemoveLanguages $removeLanguages
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setRemoveLanguages(\StructType\RemoveLanguages $removeLanguages = null)
    {
        // validation for constraint: choice(removeLanguages, addLanguages, languages)
        if ('' !== ($removeLanguagesChoiceErrorMessage = self::validateRemoveLanguagesForChoiceConstraintsFromSetRemoveLanguages($removeLanguages))) {
            throw new \InvalidArgumentException($removeLanguagesChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeLanguages) || (is_array($removeLanguages) && empty($removeLanguages))) {
            unset($this->removeLanguages);
        } else {
            $this->removeLanguages = $removeLanguages;
        }
        return $this;
    }
    /**
     * Get addLanguages value
     * @return \StructType\AddLanguages|null
     */
    public function getAddLanguages()
    {
        return isset($this->addLanguages) ? $this->addLanguages : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddLanguages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddLanguages method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddLanguagesForChoiceConstraintsFromSetAddLanguages($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeLanguages',
            'languages',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addLanguages can\'t be set as the property %s is already set. Only one property must be set among these properties: addLanguages, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addLanguages value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddLanguages $addLanguages
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setAddLanguages(\StructType\AddLanguages $addLanguages = null)
    {
        // validation for constraint: choice(removeLanguages, addLanguages, languages)
        if ('' !== ($addLanguagesChoiceErrorMessage = self::validateAddLanguagesForChoiceConstraintsFromSetAddLanguages($addLanguages))) {
            throw new \InvalidArgumentException($addLanguagesChoiceErrorMessage, __LINE__);
        }
        if (is_null($addLanguages) || (is_array($addLanguages) && empty($addLanguages))) {
            unset($this->addLanguages);
        } else {
            $this->addLanguages = $addLanguages;
        }
        return $this;
    }
    /**
     * Get languages value
     * @return \StructType\Languages|null
     */
    public function getLanguages()
    {
        return isset($this->languages) ? $this->languages : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLanguages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguages method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLanguagesForChoiceConstraintsFromSetLanguages($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeLanguages',
            'addLanguages',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property languages can\'t be set as the property %s is already set. Only one property must be set among these properties: languages, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set languages value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Languages $languages
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setLanguages(\StructType\Languages $languages = null)
    {
        // validation for constraint: choice(removeLanguages, addLanguages, languages)
        if ('' !== ($languagesChoiceErrorMessage = self::validateLanguagesForChoiceConstraintsFromSetLanguages($languages))) {
            throw new \InvalidArgumentException($languagesChoiceErrorMessage, __LINE__);
        }
        if (is_null($languages) || (is_array($languages) && empty($languages))) {
            unset($this->languages);
        } else {
            $this->languages = $languages;
        }
        return $this;
    }
}
