<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSafCcdPurgeBlockLearnedRoutesReq StructType
 * @subpackage Structs
 */
class UpdateSafCcdPurgeBlockLearnedRoutesReq extends APIRequest
{
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | learnedPattern | learnedPatternPrefix | callControlIdentity | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The learnedPattern
     * Meta information extracted from the WSDL
     * - documentation: Either learnedPattern or learnedPatternPrefix has to be set
     * - base: xsd:string
     * - choice: uuid | learnedPattern | learnedPatternPrefix | callControlIdentity | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $learnedPattern;
    /**
     * The learnedPatternPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | learnedPattern | learnedPatternPrefix | callControlIdentity | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The callControlIdentity
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | learnedPattern | learnedPatternPrefix | callControlIdentity | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callControlIdentity;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | learnedPattern | learnedPatternPrefix | callControlIdentity | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The newLearnedPattern
     * Meta information extracted from the WSDL
     * - documentation: Either learnedPattern or learnedPatternPrefix has to be set
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newLearnedPattern;
    /**
     * The newLearnedPatternPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newLearnedPatternPrefix;
    /**
     * The newCallControlIdentity
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newCallControlIdentity;
    /**
     * The newIpAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newIpAddress;
    /**
     * Constructor method for UpdateSafCcdPurgeBlockLearnedRoutesReq
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setUuid()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setLearnedPattern()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setLearnedPatternPrefix()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setCallControlIdentity()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setIpAddress()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewLearnedPattern()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewLearnedPatternPrefix()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewCallControlIdentity()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewIpAddress()
     * @param string $uuid
     * @param string $learnedPattern
     * @param string $learnedPatternPrefix
     * @param string $callControlIdentity
     * @param string $ipAddress
     * @param string $newLearnedPattern
     * @param string $newLearnedPatternPrefix
     * @param string $newCallControlIdentity
     * @param string $newIpAddress
     */
    public function __construct($uuid = null, $learnedPattern = null, $learnedPatternPrefix = null, $callControlIdentity = null, $ipAddress = null, $newLearnedPattern = null, $newLearnedPatternPrefix = null, $newCallControlIdentity = null, $newIpAddress = null)
    {
        $this
            ->setUuid($uuid)
            ->setLearnedPattern($learnedPattern)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setCallControlIdentity($callControlIdentity)
            ->setIpAddress($ipAddress)
            ->setNewLearnedPattern($newLearnedPattern)
            ->setNewLearnedPatternPrefix($newLearnedPatternPrefix)
            ->setNewCallControlIdentity($newCallControlIdentity)
            ->setNewIpAddress($newIpAddress);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'learnedPattern',
            'learnedPatternPrefix',
            'callControlIdentity',
            'ipAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, learnedPattern, learnedPatternPrefix, callControlIdentity, ipAddress)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get learnedPattern value
     * @return string|null
     */
    public function getLearnedPattern()
    {
        return isset($this->learnedPattern) ? $this->learnedPattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLearnedPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLearnedPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLearnedPatternForChoiceConstraintsFromSetLearnedPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'learnedPatternPrefix',
            'callControlIdentity',
            'ipAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property learnedPattern can\'t be set as the property %s is already set. Only one property must be set among these properties: learnedPattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set learnedPattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $learnedPattern
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setLearnedPattern($learnedPattern = null)
    {
        // validation for constraint: string
        if (!is_null($learnedPattern) && !is_string($learnedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($learnedPattern, true), gettype($learnedPattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, learnedPattern, learnedPatternPrefix, callControlIdentity, ipAddress)
        if ('' !== ($learnedPatternChoiceErrorMessage = self::validateLearnedPatternForChoiceConstraintsFromSetLearnedPattern($learnedPattern))) {
            throw new \InvalidArgumentException($learnedPatternChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($learnedPattern) && mb_strlen($learnedPattern) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($learnedPattern)), __LINE__);
        }
        if (is_null($learnedPattern) || (is_array($learnedPattern) && empty($learnedPattern))) {
            unset($this->learnedPattern);
        } else {
            $this->learnedPattern = $learnedPattern;
        }
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return isset($this->learnedPatternPrefix) ? $this->learnedPatternPrefix : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLearnedPatternPrefix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLearnedPatternPrefix method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLearnedPatternPrefixForChoiceConstraintsFromSetLearnedPatternPrefix($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'learnedPattern',
            'callControlIdentity',
            'ipAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property learnedPatternPrefix can\'t be set as the property %s is already set. Only one property must be set among these properties: learnedPatternPrefix, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set learnedPatternPrefix value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $learnedPatternPrefix
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($learnedPatternPrefix, true), gettype($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: choice(uuid, learnedPattern, learnedPatternPrefix, callControlIdentity, ipAddress)
        if ('' !== ($learnedPatternPrefixChoiceErrorMessage = self::validateLearnedPatternPrefixForChoiceConstraintsFromSetLearnedPatternPrefix($learnedPatternPrefix))) {
            throw new \InvalidArgumentException($learnedPatternPrefixChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($learnedPatternPrefix) && mb_strlen($learnedPatternPrefix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($learnedPatternPrefix)), __LINE__);
        }
        if (is_null($learnedPatternPrefix) || (is_array($learnedPatternPrefix) && empty($learnedPatternPrefix))) {
            unset($this->learnedPatternPrefix);
        } else {
            $this->learnedPatternPrefix = $learnedPatternPrefix;
        }
        return $this;
    }
    /**
     * Get callControlIdentity value
     * @return string|null
     */
    public function getCallControlIdentity()
    {
        return isset($this->callControlIdentity) ? $this->callControlIdentity : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCallControlIdentity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCallControlIdentity method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCallControlIdentityForChoiceConstraintsFromSetCallControlIdentity($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'learnedPattern',
            'learnedPatternPrefix',
            'ipAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property callControlIdentity can\'t be set as the property %s is already set. Only one property must be set among these properties: callControlIdentity, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set callControlIdentity value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $callControlIdentity
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setCallControlIdentity($callControlIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($callControlIdentity) && !is_string($callControlIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callControlIdentity, true), gettype($callControlIdentity)), __LINE__);
        }
        // validation for constraint: choice(uuid, learnedPattern, learnedPatternPrefix, callControlIdentity, ipAddress)
        if ('' !== ($callControlIdentityChoiceErrorMessage = self::validateCallControlIdentityForChoiceConstraintsFromSetCallControlIdentity($callControlIdentity))) {
            throw new \InvalidArgumentException($callControlIdentityChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($callControlIdentity) && mb_strlen($callControlIdentity) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($callControlIdentity)), __LINE__);
        }
        if (is_null($callControlIdentity) || (is_array($callControlIdentity) && empty($callControlIdentity))) {
            unset($this->callControlIdentity);
        } else {
            $this->callControlIdentity = $callControlIdentity;
        }
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return isset($this->ipAddress) ? $this->ipAddress : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIpAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIpAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIpAddressForChoiceConstraintsFromSetIpAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'learnedPattern',
            'learnedPatternPrefix',
            'callControlIdentity',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ipAddress can\'t be set as the property %s is already set. Only one property must be set among these properties: ipAddress, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ipAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ipAddress
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        // validation for constraint: choice(uuid, learnedPattern, learnedPatternPrefix, callControlIdentity, ipAddress)
        if ('' !== ($ipAddressChoiceErrorMessage = self::validateIpAddressForChoiceConstraintsFromSetIpAddress($ipAddress))) {
            throw new \InvalidArgumentException($ipAddressChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ipAddress) && mb_strlen($ipAddress) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ipAddress)), __LINE__);
        }
        if (is_null($ipAddress) || (is_array($ipAddress) && empty($ipAddress))) {
            unset($this->ipAddress);
        } else {
            $this->ipAddress = $ipAddress;
        }
        return $this;
    }
    /**
     * Get newLearnedPattern value
     * @return string|null
     */
    public function getNewLearnedPattern()
    {
        return $this->newLearnedPattern;
    }
    /**
     * Set newLearnedPattern value
     * @param string $newLearnedPattern
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewLearnedPattern($newLearnedPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newLearnedPattern) && !is_string($newLearnedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLearnedPattern, true), gettype($newLearnedPattern)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newLearnedPattern) && mb_strlen($newLearnedPattern) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newLearnedPattern)), __LINE__);
        }
        $this->newLearnedPattern = $newLearnedPattern;
        return $this;
    }
    /**
     * Get newLearnedPatternPrefix value
     * @return string|null
     */
    public function getNewLearnedPatternPrefix()
    {
        return $this->newLearnedPatternPrefix;
    }
    /**
     * Set newLearnedPatternPrefix value
     * @param string $newLearnedPatternPrefix
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewLearnedPatternPrefix($newLearnedPatternPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($newLearnedPatternPrefix) && !is_string($newLearnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLearnedPatternPrefix, true), gettype($newLearnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newLearnedPatternPrefix) && mb_strlen($newLearnedPatternPrefix) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newLearnedPatternPrefix)), __LINE__);
        }
        $this->newLearnedPatternPrefix = $newLearnedPatternPrefix;
        return $this;
    }
    /**
     * Get newCallControlIdentity value
     * @return string|null
     */
    public function getNewCallControlIdentity()
    {
        return $this->newCallControlIdentity;
    }
    /**
     * Set newCallControlIdentity value
     * @param string $newCallControlIdentity
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewCallControlIdentity($newCallControlIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($newCallControlIdentity) && !is_string($newCallControlIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newCallControlIdentity, true), gettype($newCallControlIdentity)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newCallControlIdentity) && mb_strlen($newCallControlIdentity) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newCallControlIdentity)), __LINE__);
        }
        $this->newCallControlIdentity = $newCallControlIdentity;
        return $this;
    }
    /**
     * Get newIpAddress value
     * @return string|null
     */
    public function getNewIpAddress()
    {
        return $this->newIpAddress;
    }
    /**
     * Set newIpAddress value
     * @param string $newIpAddress
     * @return \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewIpAddress($newIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newIpAddress) && !is_string($newIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newIpAddress, true), gettype($newIpAddress)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newIpAddress) && mb_strlen($newIpAddress) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newIpAddress)), __LINE__);
        }
        $this->newIpAddress = $newIpAddress;
        return $this;
    }
}
