<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRemoteClusterReq StructType
 * @subpackage Structs
 */
class UpdateRemoteClusterReq extends APIRequest
{
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | clusterId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $clusterId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | clusterId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The emcc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $uds;
    /**
     * Constructor method for UpdateRemoteClusterReq
     * @uses UpdateRemoteClusterReq::setClusterId()
     * @uses UpdateRemoteClusterReq::setUuid()
     * @uses UpdateRemoteClusterReq::setEmcc()
     * @uses UpdateRemoteClusterReq::setPstnAccess()
     * @uses UpdateRemoteClusterReq::setRsvpAgent()
     * @uses UpdateRemoteClusterReq::setTftp()
     * @uses UpdateRemoteClusterReq::setLbm()
     * @uses UpdateRemoteClusterReq::setUds()
     * @param string $clusterId
     * @param string $uuid
     * @param \StructType\XRemoteClusterMember $emcc
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @param \StructType\XRemoteClusterMember $tftp
     * @param \StructType\XRemoteClusterMember $lbm
     * @param \StructType\XRemoteClusterMember $uds
     */
    public function __construct($clusterId = null, $uuid = null, \StructType\XRemoteClusterMember $emcc = null, \StructType\XRemoteClusterMember $pstnAccess = null, \StructType\XRemoteClusterMember $rsvpAgent = null, \StructType\XRemoteClusterMember $tftp = null, \StructType\XRemoteClusterMember $lbm = null, \StructType\XRemoteClusterMember $uds = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setUuid($uuid)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return isset($this->clusterId) ? $this->clusterId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClusterId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClusterId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClusterIdForChoiceConstraintsFromSetClusterId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property clusterId can\'t be set as the property %s is already set. Only one property must be set among these properties: clusterId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set clusterId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $clusterId
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clusterId, true), gettype($clusterId)), __LINE__);
        }
        // validation for constraint: choice(uuid, clusterId)
        if ('' !== ($clusterIdChoiceErrorMessage = self::validateClusterIdForChoiceConstraintsFromSetClusterId($clusterId))) {
            throw new \InvalidArgumentException($clusterIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($clusterId) && mb_strlen($clusterId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($clusterId)), __LINE__);
        }
        if (is_null($clusterId) || (is_array($clusterId) && empty($clusterId))) {
            unset($this->clusterId);
        } else {
            $this->clusterId = $clusterId;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'clusterId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, clusterId)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get emcc value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param \StructType\XRemoteClusterMember $emcc
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setEmcc(\StructType\XRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setPstnAccess(\StructType\XRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setRsvpAgent(\StructType\XRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param \StructType\XRemoteClusterMember $tftp
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setTftp(\StructType\XRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param \StructType\XRemoteClusterMember $lbm
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setLbm(\StructType\XRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param \StructType\XRemoteClusterMember $uds
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setUds(\StructType\XRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
}
