<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRegionReq StructType
 * @subpackage Structs
 */
class UpdateRegionReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The relatedRegions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedRegions
     */
    public $relatedRegions;
    /**
     * Constructor method for UpdateRegionReq
     * @uses UpdateRegionReq::setNewName()
     * @uses UpdateRegionReq::setRelatedRegions()
     * @param string $newName
     * @param \StructType\RelatedRegions $relatedRegions
     */
    public function __construct($newName = null, \StructType\RelatedRegions $relatedRegions = null)
    {
        $this
            ->setNewName($newName)
            ->setRelatedRegions($relatedRegions);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateRegionReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get relatedRegions value
     * @return \StructType\RelatedRegions|null
     */
    public function getRelatedRegions()
    {
        return $this->relatedRegions;
    }
    /**
     * Set relatedRegions value
     * @param \StructType\RelatedRegions $relatedRegions
     * @return \StructType\UpdateRegionReq
     */
    public function setRelatedRegions(\StructType\RelatedRegions $relatedRegions = null)
    {
        $this->relatedRegions = $relatedRegions;
        return $this;
    }
}
