<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProcessNodeReq StructType
 * @subpackage Structs
 */
class UpdateProcessNodeReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta information extracted from the WSDL
     * - documentation: The mac address of the host.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipv6Name;
    /**
     * The lbmHubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The cupDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cupDomain;
    /**
     * Constructor method for UpdateProcessNodeReq
     * @uses UpdateProcessNodeReq::setNewName()
     * @uses UpdateProcessNodeReq::setDescription()
     * @uses UpdateProcessNodeReq::setMac()
     * @uses UpdateProcessNodeReq::setIpv6Name()
     * @uses UpdateProcessNodeReq::setLbmHubGroup()
     * @uses UpdateProcessNodeReq::setCupDomain()
     * @param string $newName
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param \StructType\XFkType $lbmHubGroup
     * @param string $cupDomain
     */
    public function __construct($newName = null, $description = null, $mac = null, $ipv6Name = null, \StructType\XFkType $lbmHubGroup = null, $cupDomain = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setLbmHubGroup($lbmHubGroup)
            ->setCupDomain($cupDomain);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateProcessNodeReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($newName) && mb_strlen($newName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateProcessNodeReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \StructType\UpdateProcessNodeReq
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mac, true), gettype($mac)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]|[a-f]|[A-F]){12})
        if (!is_null($mac) && !preg_match('/([0-9]|[a-f]|[A-F]){12}/', $mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]|[a-f]|[A-F]){12}', var_export($mac, true)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \StructType\UpdateProcessNodeReq
     */
    public function setIpv6Name($ipv6Name = null)
    {
        // validation for constraint: string
        if (!is_null($ipv6Name) && !is_string($ipv6Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipv6Name, true), gettype($ipv6Name)), __LINE__);
        }
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return isset($this->lbmHubGroup) ? $this->lbmHubGroup : null;
    }
    /**
     * Set lbmHubGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $lbmHubGroup
     * @return \StructType\UpdateProcessNodeReq
     */
    public function setLbmHubGroup(\StructType\XFkType $lbmHubGroup = null)
    {
        if (is_null($lbmHubGroup) || (is_array($lbmHubGroup) && empty($lbmHubGroup))) {
            unset($this->lbmHubGroup);
        } else {
            $this->lbmHubGroup = $lbmHubGroup;
        }
        return $this;
    }
    /**
     * Get cupDomain value
     * @return string|null
     */
    public function getCupDomain()
    {
        return $this->cupDomain;
    }
    /**
     * Set cupDomain value
     * @param string $cupDomain
     * @return \StructType\UpdateProcessNodeReq
     */
    public function setCupDomain($cupDomain = null)
    {
        // validation for constraint: string
        if (!is_null($cupDomain) && !is_string($cupDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cupDomain, true), gettype($cupDomain)), __LINE__);
        }
        $this->cupDomain = $cupDomain;
        return $this;
    }
}
