<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePhoneButtonTemplateReq StructType
 * @subpackage Structs
 */
class UpdatePhoneButtonTemplateReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: The template's name
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The buttons
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Buttons
     */
    public $buttons;
    /**
     * Constructor method for UpdatePhoneButtonTemplateReq
     * @uses UpdatePhoneButtonTemplateReq::setNewName()
     * @uses UpdatePhoneButtonTemplateReq::setButtons()
     * @param string $newName
     * @param \StructType\Buttons $buttons
     */
    public function __construct($newName = null, \StructType\Buttons $buttons = null)
    {
        $this
            ->setNewName($newName)
            ->setButtons($buttons);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdatePhoneButtonTemplateReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get buttons value
     * @return \StructType\Buttons|null
     */
    public function getButtons()
    {
        return $this->buttons;
    }
    /**
     * Set buttons value
     * @param \StructType\Buttons $buttons
     * @return \StructType\UpdatePhoneButtonTemplateReq
     */
    public function setButtons(\StructType\Buttons $buttons = null)
    {
        $this->buttons = $buttons;
        return $this;
    }
}
