<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMtpReq StructType
 * @subpackage Structs
 */
class UpdateMtpReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The trustedRelayPoint
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trustedRelayPoint;
    /**
     * Constructor method for UpdateMtpReq
     * @uses UpdateMtpReq::setNewName()
     * @uses UpdateMtpReq::setDescription()
     * @uses UpdateMtpReq::setDevicePoolName()
     * @uses UpdateMtpReq::setTrustedRelayPoint()
     * @param string $newName
     * @param string $description
     * @param \StructType\XFkType $devicePoolName
     * @param string $trustedRelayPoint
     */
    public function __construct($newName = null, $description = null, \StructType\XFkType $devicePoolName = null, $trustedRelayPoint = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDevicePoolName($devicePoolName)
            ->setTrustedRelayPoint($trustedRelayPoint);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateMtpReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateMtpReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\UpdateMtpReq
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get trustedRelayPoint value
     * @return string|null
     */
    public function getTrustedRelayPoint()
    {
        return $this->trustedRelayPoint;
    }
    /**
     * Set trustedRelayPoint value
     * @param string $trustedRelayPoint
     * @return \StructType\UpdateMtpReq
     */
    public function setTrustedRelayPoint($trustedRelayPoint = null)
    {
        // validation for constraint: string
        if (!is_null($trustedRelayPoint) && !is_string($trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trustedRelayPoint, true), gettype($trustedRelayPoint)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($trustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($trustedRelayPoint, true)), __LINE__);
        }
        $this->trustedRelayPoint = $trustedRelayPoint;
        return $this;
    }
}
