<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInterClusterDirectoryUriReq StructType
 * @subpackage Structs
 */
class UpdateInterClusterDirectoryUriReq extends APIRequest
{
    /**
     * The exchangeDirectoryUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $exchangeDirectoryUri;
    /**
     * The routeString
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $routeString;
    /**
     * Constructor method for UpdateInterClusterDirectoryUriReq
     * @uses UpdateInterClusterDirectoryUriReq::setExchangeDirectoryUri()
     * @uses UpdateInterClusterDirectoryUriReq::setRouteString()
     * @param string $exchangeDirectoryUri
     * @param string $routeString
     */
    public function __construct($exchangeDirectoryUri = null, $routeString = null)
    {
        $this
            ->setExchangeDirectoryUri($exchangeDirectoryUri)
            ->setRouteString($routeString);
    }
    /**
     * Get exchangeDirectoryUri value
     * @return string|null
     */
    public function getExchangeDirectoryUri()
    {
        return $this->exchangeDirectoryUri;
    }
    /**
     * Set exchangeDirectoryUri value
     * @param string $exchangeDirectoryUri
     * @return \StructType\UpdateInterClusterDirectoryUriReq
     */
    public function setExchangeDirectoryUri($exchangeDirectoryUri = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeDirectoryUri) && !is_string($exchangeDirectoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeDirectoryUri, true), gettype($exchangeDirectoryUri)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($exchangeDirectoryUri) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $exchangeDirectoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($exchangeDirectoryUri, true)), __LINE__);
        }
        $this->exchangeDirectoryUri = $exchangeDirectoryUri;
        return $this;
    }
    /**
     * Get routeString value
     * @return string|null
     */
    public function getRouteString()
    {
        return $this->routeString;
    }
    /**
     * Set routeString value
     * @param string $routeString
     * @return \StructType\UpdateInterClusterDirectoryUriReq
     */
    public function setRouteString($routeString = null)
    {
        // validation for constraint: string
        if (!is_null($routeString) && !is_string($routeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeString, true), gettype($routeString)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($routeString) && mb_strlen($routeString) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($routeString)), __LINE__);
        }
        $this->routeString = $routeString;
        return $this;
    }
}
