<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImportedDirectoryUriCatalogsReq StructType
 * @subpackage Structs
 */
class UpdateImportedDirectoryUriCatalogsReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The routeString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $routeString;
    /**
     * Constructor method for UpdateImportedDirectoryUriCatalogsReq
     * @uses UpdateImportedDirectoryUriCatalogsReq::setNewName()
     * @uses UpdateImportedDirectoryUriCatalogsReq::setDescription()
     * @uses UpdateImportedDirectoryUriCatalogsReq::setRouteString()
     * @param string $newName
     * @param string $description
     * @param string $routeString
     */
    public function __construct($newName = null, $description = null, $routeString = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRouteString($routeString);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImportedDirectoryUriCatalogsReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\UpdateImportedDirectoryUriCatalogsReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get routeString value
     * @return string|null
     */
    public function getRouteString()
    {
        return $this->routeString;
    }
    /**
     * Set routeString value
     * @param string $routeString
     * @return \StructType\UpdateImportedDirectoryUriCatalogsReq
     */
    public function setRouteString($routeString = null)
    {
        // validation for constraint: string
        if (!is_null($routeString) && !is_string($routeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeString, true), gettype($routeString)), __LINE__);
        }
        $this->routeString = $routeString;
        return $this;
    }
}
