<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeEnrolledPatternGroupReq StructType
 * @subpackage Structs
 */
class UpdateImeEnrolledPatternGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The fallbackProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $fallbackProfileName;
    /**
     * The isPatternAllAlias
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPatternAllAlias;
    /**
     * Constructor method for UpdateImeEnrolledPatternGroupReq
     * @uses UpdateImeEnrolledPatternGroupReq::setNewName()
     * @uses UpdateImeEnrolledPatternGroupReq::setDescription()
     * @uses UpdateImeEnrolledPatternGroupReq::setFallbackProfileName()
     * @uses UpdateImeEnrolledPatternGroupReq::setIsPatternAllAlias()
     * @param string $newName
     * @param string $description
     * @param \StructType\XFkType $fallbackProfileName
     * @param string $isPatternAllAlias
     */
    public function __construct($newName = null, $description = null, \StructType\XFkType $fallbackProfileName = null, $isPatternAllAlias = 'false')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setFallbackProfileName($fallbackProfileName)
            ->setIsPatternAllAlias($isPatternAllAlias);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImeEnrolledPatternGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateImeEnrolledPatternGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fallbackProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getFallbackProfileName()
    {
        return isset($this->fallbackProfileName) ? $this->fallbackProfileName : null;
    }
    /**
     * Set fallbackProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $fallbackProfileName
     * @return \StructType\UpdateImeEnrolledPatternGroupReq
     */
    public function setFallbackProfileName(\StructType\XFkType $fallbackProfileName = null)
    {
        if (is_null($fallbackProfileName) || (is_array($fallbackProfileName) && empty($fallbackProfileName))) {
            unset($this->fallbackProfileName);
        } else {
            $this->fallbackProfileName = $fallbackProfileName;
        }
        return $this;
    }
    /**
     * Get isPatternAllAlias value
     * @return string|null
     */
    public function getIsPatternAllAlias()
    {
        return $this->isPatternAllAlias;
    }
    /**
     * Set isPatternAllAlias value
     * @param string $isPatternAllAlias
     * @return \StructType\UpdateImeEnrolledPatternGroupReq
     */
    public function setIsPatternAllAlias($isPatternAllAlias = 'false')
    {
        // validation for constraint: string
        if (!is_null($isPatternAllAlias) && !is_string($isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPatternAllAlias, true), gettype($isPatternAllAlias)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isPatternAllAlias) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isPatternAllAlias, true)), __LINE__);
        }
        $this->isPatternAllAlias = $isPatternAllAlias;
        return $this;
    }
}
