<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeClientReq StructType
 * @subpackage Structs
 */
class UpdateImeClientReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The domain
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $domain;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $primaryImeServerName;
    /**
     * The secondaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $firewallName;
    /**
     * The removeMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - choice: removeMembers | addMembers | members
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The removeCcmExternalIpMaps
     * Meta information extracted from the WSDL
     * - choice: removeCcmExternalIpMaps | addCcmExternalIpMaps | ccmExternalIpMaps
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveCcmExternalIpMaps
     */
    public $removeCcmExternalIpMaps;
    /**
     * The addCcmExternalIpMaps
     * Meta information extracted from the WSDL
     * - choice: removeCcmExternalIpMaps | addCcmExternalIpMaps | ccmExternalIpMaps
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddCcmExternalIpMaps
     */
    public $addCcmExternalIpMaps;
    /**
     * The ccmExternalIpMaps
     * Meta information extracted from the WSDL
     * - choice: removeCcmExternalIpMaps | addCcmExternalIpMaps | ccmExternalIpMaps
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var \StructType\CcmExternalIpMaps
     */
    public $ccmExternalIpMaps;
    /**
     * Constructor method for UpdateImeClientReq
     * @uses UpdateImeClientReq::setNewName()
     * @uses UpdateImeClientReq::setDescription()
     * @uses UpdateImeClientReq::setDomain()
     * @uses UpdateImeClientReq::setIsActivated()
     * @uses UpdateImeClientReq::setSipTrunkName()
     * @uses UpdateImeClientReq::setPrimaryImeServerName()
     * @uses UpdateImeClientReq::setSecondaryImeServerName()
     * @uses UpdateImeClientReq::setLearnedRouteFilterGroupName()
     * @uses UpdateImeClientReq::setExclusionNumberGroupName()
     * @uses UpdateImeClientReq::setFirewallName()
     * @uses UpdateImeClientReq::setRemoveMembers()
     * @uses UpdateImeClientReq::setAddMembers()
     * @uses UpdateImeClientReq::setMembers()
     * @uses UpdateImeClientReq::setRemoveCcmExternalIpMaps()
     * @uses UpdateImeClientReq::setAddCcmExternalIpMaps()
     * @uses UpdateImeClientReq::setCcmExternalIpMaps()
     * @param string $newName
     * @param string $description
     * @param string $domain
     * @param string $isActivated
     * @param \StructType\XFkType $sipTrunkName
     * @param \StructType\XFkType $primaryImeServerName
     * @param \StructType\XFkType $secondaryImeServerName
     * @param \StructType\XFkType $learnedRouteFilterGroupName
     * @param \StructType\XFkType $exclusionNumberGroupName
     * @param \StructType\XFkType $firewallName
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     * @param \StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps
     * @param \StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps
     * @param \StructType\CcmExternalIpMaps $ccmExternalIpMaps
     */
    public function __construct($newName = null, $description = null, $domain = null, $isActivated = 'false', \StructType\XFkType $sipTrunkName = null, \StructType\XFkType $primaryImeServerName = null, \StructType\XFkType $secondaryImeServerName = null, \StructType\XFkType $learnedRouteFilterGroupName = null, \StructType\XFkType $exclusionNumberGroupName = null, \StructType\XFkType $firewallName = null, \StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null, \StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps = null, \StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps = null, \StructType\CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDomain($domain)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setRemoveCcmExternalIpMaps($removeCcmExternalIpMaps)
            ->setAddCcmExternalIpMaps($addCcmExternalIpMaps)
            ->setCcmExternalIpMaps($ccmExternalIpMaps);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImeClientReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newName, true), gettype($newName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($newName) && mb_strlen($newName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateImeClientReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\UpdateImeClientReq
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($domain) && mb_strlen($domain) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\UpdateImeClientReq
     */
    public function setIsActivated($isActivated = 'false')
    {
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isActivated, true), gettype($isActivated)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isActivated, true)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\UpdateImeClientReq
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return \StructType\XFkType|null
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param \StructType\XFkType $primaryImeServerName
     * @return \StructType\UpdateImeClientReq
     */
    public function setPrimaryImeServerName(\StructType\XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return isset($this->secondaryImeServerName) ? $this->secondaryImeServerName : null;
    }
    /**
     * Set secondaryImeServerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $secondaryImeServerName
     * @return \StructType\UpdateImeClientReq
     */
    public function setSecondaryImeServerName(\StructType\XFkType $secondaryImeServerName = null)
    {
        if (is_null($secondaryImeServerName) || (is_array($secondaryImeServerName) && empty($secondaryImeServerName))) {
            unset($this->secondaryImeServerName);
        } else {
            $this->secondaryImeServerName = $secondaryImeServerName;
        }
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return isset($this->learnedRouteFilterGroupName) ? $this->learnedRouteFilterGroupName : null;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $learnedRouteFilterGroupName
     * @return \StructType\UpdateImeClientReq
     */
    public function setLearnedRouteFilterGroupName(\StructType\XFkType $learnedRouteFilterGroupName = null)
    {
        if (is_null($learnedRouteFilterGroupName) || (is_array($learnedRouteFilterGroupName) && empty($learnedRouteFilterGroupName))) {
            unset($this->learnedRouteFilterGroupName);
        } else {
            $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        }
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return isset($this->exclusionNumberGroupName) ? $this->exclusionNumberGroupName : null;
    }
    /**
     * Set exclusionNumberGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $exclusionNumberGroupName
     * @return \StructType\UpdateImeClientReq
     */
    public function setExclusionNumberGroupName(\StructType\XFkType $exclusionNumberGroupName = null)
    {
        if (is_null($exclusionNumberGroupName) || (is_array($exclusionNumberGroupName) && empty($exclusionNumberGroupName))) {
            unset($this->exclusionNumberGroupName);
        } else {
            $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        }
        return $this;
    }
    /**
     * Get firewallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getFirewallName()
    {
        return isset($this->firewallName) ? $this->firewallName : null;
    }
    /**
     * Set firewallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $firewallName
     * @return \StructType\UpdateImeClientReq
     */
    public function setFirewallName(\StructType\XFkType $firewallName = null)
    {
        if (is_null($firewallName) || (is_array($firewallName) && empty($firewallName))) {
            unset($this->firewallName);
        } else {
            $this->firewallName = $firewallName;
        }
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return isset($this->removeMembers) ? $this->removeMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: removeMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateImeClientReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($removeMembersChoiceErrorMessage = self::validateRemoveMembersForChoiceConstraintsFromSetRemoveMembers($removeMembers))) {
            throw new \InvalidArgumentException($removeMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeMembers) || (is_array($removeMembers) && empty($removeMembers))) {
            unset($this->removeMembers);
        } else {
            $this->removeMembers = $removeMembers;
        }
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return isset($this->addMembers) ? $this->addMembers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddMembersForChoiceConstraintsFromSetAddMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'members',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addMembers can\'t be set as the property %s is already set. Only one property must be set among these properties: addMembers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addMembers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateImeClientReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($addMembersChoiceErrorMessage = self::validateAddMembersForChoiceConstraintsFromSetAddMembers($addMembers))) {
            throw new \InvalidArgumentException($addMembersChoiceErrorMessage, __LINE__);
        }
        if (is_null($addMembers) || (is_array($addMembers) && empty($addMembers))) {
            unset($this->addMembers);
        } else {
            $this->addMembers = $addMembers;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return isset($this->members) ? $this->members : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMembers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMembersForChoiceConstraintsFromSetMembers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeMembers',
            'addMembers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property members can\'t be set as the property %s is already set. Only one property must be set among these properties: members, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set members value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Members $members
     * @return \StructType\UpdateImeClientReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        // validation for constraint: choice(removeMembers, addMembers, members)
        if ('' !== ($membersChoiceErrorMessage = self::validateMembersForChoiceConstraintsFromSetMembers($members))) {
            throw new \InvalidArgumentException($membersChoiceErrorMessage, __LINE__);
        }
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->members);
        } else {
            $this->members = $members;
        }
        return $this;
    }
    /**
     * Get removeCcmExternalIpMaps value
     * @return \StructType\RemoveCcmExternalIpMaps|null
     */
    public function getRemoveCcmExternalIpMaps()
    {
        return isset($this->removeCcmExternalIpMaps) ? $this->removeCcmExternalIpMaps : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRemoveCcmExternalIpMaps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemoveCcmExternalIpMaps method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRemoveCcmExternalIpMapsForChoiceConstraintsFromSetRemoveCcmExternalIpMaps($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'addCcmExternalIpMaps',
            'ccmExternalIpMaps',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property removeCcmExternalIpMaps can\'t be set as the property %s is already set. Only one property must be set among these properties: removeCcmExternalIpMaps, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set removeCcmExternalIpMaps value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps
     * @return \StructType\UpdateImeClientReq
     */
    public function setRemoveCcmExternalIpMaps(\StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps = null)
    {
        // validation for constraint: choice(removeCcmExternalIpMaps, addCcmExternalIpMaps, ccmExternalIpMaps)
        if ('' !== ($removeCcmExternalIpMapsChoiceErrorMessage = self::validateRemoveCcmExternalIpMapsForChoiceConstraintsFromSetRemoveCcmExternalIpMaps($removeCcmExternalIpMaps))) {
            throw new \InvalidArgumentException($removeCcmExternalIpMapsChoiceErrorMessage, __LINE__);
        }
        if (is_null($removeCcmExternalIpMaps) || (is_array($removeCcmExternalIpMaps) && empty($removeCcmExternalIpMaps))) {
            unset($this->removeCcmExternalIpMaps);
        } else {
            $this->removeCcmExternalIpMaps = $removeCcmExternalIpMaps;
        }
        return $this;
    }
    /**
     * Get addCcmExternalIpMaps value
     * @return \StructType\AddCcmExternalIpMaps|null
     */
    public function getAddCcmExternalIpMaps()
    {
        return isset($this->addCcmExternalIpMaps) ? $this->addCcmExternalIpMaps : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAddCcmExternalIpMaps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddCcmExternalIpMaps method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAddCcmExternalIpMapsForChoiceConstraintsFromSetAddCcmExternalIpMaps($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeCcmExternalIpMaps',
            'ccmExternalIpMaps',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property addCcmExternalIpMaps can\'t be set as the property %s is already set. Only one property must be set among these properties: addCcmExternalIpMaps, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set addCcmExternalIpMaps value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps
     * @return \StructType\UpdateImeClientReq
     */
    public function setAddCcmExternalIpMaps(\StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps = null)
    {
        // validation for constraint: choice(removeCcmExternalIpMaps, addCcmExternalIpMaps, ccmExternalIpMaps)
        if ('' !== ($addCcmExternalIpMapsChoiceErrorMessage = self::validateAddCcmExternalIpMapsForChoiceConstraintsFromSetAddCcmExternalIpMaps($addCcmExternalIpMaps))) {
            throw new \InvalidArgumentException($addCcmExternalIpMapsChoiceErrorMessage, __LINE__);
        }
        if (is_null($addCcmExternalIpMaps) || (is_array($addCcmExternalIpMaps) && empty($addCcmExternalIpMaps))) {
            unset($this->addCcmExternalIpMaps);
        } else {
            $this->addCcmExternalIpMaps = $addCcmExternalIpMaps;
        }
        return $this;
    }
    /**
     * Get ccmExternalIpMaps value
     * @return \StructType\CcmExternalIpMaps|null
     */
    public function getCcmExternalIpMaps()
    {
        return isset($this->ccmExternalIpMaps) ? $this->ccmExternalIpMaps : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCcmExternalIpMaps method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCcmExternalIpMaps method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCcmExternalIpMapsForChoiceConstraintsFromSetCcmExternalIpMaps($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'removeCcmExternalIpMaps',
            'addCcmExternalIpMaps',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ccmExternalIpMaps can\'t be set as the property %s is already set. Only one property must be set among these properties: ccmExternalIpMaps, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ccmExternalIpMaps value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CcmExternalIpMaps $ccmExternalIpMaps
     * @return \StructType\UpdateImeClientReq
     */
    public function setCcmExternalIpMaps(\StructType\CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        // validation for constraint: choice(removeCcmExternalIpMaps, addCcmExternalIpMaps, ccmExternalIpMaps)
        if ('' !== ($ccmExternalIpMapsChoiceErrorMessage = self::validateCcmExternalIpMapsForChoiceConstraintsFromSetCcmExternalIpMaps($ccmExternalIpMaps))) {
            throw new \InvalidArgumentException($ccmExternalIpMapsChoiceErrorMessage, __LINE__);
        }
        if (is_null($ccmExternalIpMaps) || (is_array($ccmExternalIpMaps) && empty($ccmExternalIpMaps))) {
            unset($this->ccmExternalIpMaps);
        } else {
            $this->ccmExternalIpMaps = $ccmExternalIpMaps;
        }
        return $this;
    }
}
