<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGatewayReq StructType
 * @subpackage Structs
 */
class UpdateGatewayReq extends APIRequest
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: uuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | domainName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newDomainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newDomainName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - default: Cisco VG200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - default: MGCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * Constructor method for UpdateGatewayReq
     * @uses UpdateGatewayReq::setDomainName()
     * @uses UpdateGatewayReq::setUuid()
     * @uses UpdateGatewayReq::setNewDomainName()
     * @uses UpdateGatewayReq::setDescription()
     * @uses UpdateGatewayReq::setProduct()
     * @uses UpdateGatewayReq::setProtocol()
     * @uses UpdateGatewayReq::setCallManagerGroupName()
     * @uses UpdateGatewayReq::setVendorConfig()
     * @param string $domainName
     * @param string $uuid
     * @param string $newDomainName
     * @param string $description
     * @param string $product
     * @param string $protocol
     * @param \StructType\XFkType $callManagerGroupName
     * @param \StructType\XVendorConfig $vendorConfig
     */
    public function __construct($domainName = null, $uuid = null, $newDomainName = null, $description = null, $product = 'Cisco VG200', $protocol = 'MGCP', \StructType\XFkType $callManagerGroupName = null, \StructType\XVendorConfig $vendorConfig = null)
    {
        $this
            ->setDomainName($domainName)
            ->setUuid($uuid)
            ->setNewDomainName($newDomainName)
            ->setDescription($description)
            ->setProduct($product)
            ->setProtocol($protocol)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setVendorConfig($vendorConfig);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDomainName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDomainName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDomainNameForChoiceConstraintsFromSetDomainName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property domainName can\'t be set as the property %s is already set. Only one property must be set among these properties: domainName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $domainName
     * @return \StructType\UpdateGatewayReq
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainName, true), gettype($domainName)), __LINE__);
        }
        // validation for constraint: choice(uuid, domainName)
        if ('' !== ($domainNameChoiceErrorMessage = self::validateDomainNameForChoiceConstraintsFromSetDomainName($domainName))) {
            throw new \InvalidArgumentException($domainNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'domainName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateGatewayReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, domainName)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newDomainName value
     * @return string|null
     */
    public function getNewDomainName()
    {
        return $this->newDomainName;
    }
    /**
     * Set newDomainName value
     * @param string $newDomainName
     * @return \StructType\UpdateGatewayReq
     */
    public function setNewDomainName($newDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($newDomainName) && !is_string($newDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newDomainName, true), gettype($newDomainName)), __LINE__);
        }
        $this->newDomainName = $newDomainName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateGatewayReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct()
    {
        return isset($this->product) ? $this->product : null;
    }
    /**
     * Set product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\UpdateGatewayReq
     */
    public function setProduct($product = 'Cisco VG200')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->product);
        } else {
            $this->product = $product;
        }
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\UpdateGatewayReq
     */
    public function setProtocol($protocol = 'MGCP')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return isset($this->callManagerGroupName) ? $this->callManagerGroupName : null;
    }
    /**
     * Set callManagerGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\UpdateGatewayReq
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        if (is_null($callManagerGroupName) || (is_array($callManagerGroupName) && empty($callManagerGroupName))) {
            unset($this->callManagerGroupName);
        } else {
            $this->callManagerGroupName = $callManagerGroupName;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XVendorConfig $vendorConfig
     * @return \StructType\UpdateGatewayReq
     */
    public function setVendorConfig(\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
}
