<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCCAProfilesReq StructType
 * @subpackage Structs
 */
class UpdateCCAProfilesReq extends APIRequest
{
    /**
     * The ccaId
     * Meta information extracted from the WSDL
     * - choice: uuid | ccaId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ccaId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | ccaId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newCcaId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newCcaId;
    /**
     * The primarySoftSwitchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $primarySoftSwitchId;
    /**
     * The secondarySoftSwitchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secondarySoftSwitchId;
    /**
     * The objectClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $objectClass;
    /**
     * The subscriberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberType;
    /**
     * The sipAliasSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sipAliasSuffix;
    /**
     * The sipUserNameSuffix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sipUserNameSuffix;
    /**
     * Constructor method for UpdateCCAProfilesReq
     * @uses UpdateCCAProfilesReq::setCcaId()
     * @uses UpdateCCAProfilesReq::setUuid()
     * @uses UpdateCCAProfilesReq::setNewCcaId()
     * @uses UpdateCCAProfilesReq::setPrimarySoftSwitchId()
     * @uses UpdateCCAProfilesReq::setSecondarySoftSwitchId()
     * @uses UpdateCCAProfilesReq::setObjectClass()
     * @uses UpdateCCAProfilesReq::setSubscriberType()
     * @uses UpdateCCAProfilesReq::setSipAliasSuffix()
     * @uses UpdateCCAProfilesReq::setSipUserNameSuffix()
     * @param string $ccaId
     * @param string $uuid
     * @param string $newCcaId
     * @param string $primarySoftSwitchId
     * @param string $secondarySoftSwitchId
     * @param string $objectClass
     * @param string $subscriberType
     * @param string $sipAliasSuffix
     * @param string $sipUserNameSuffix
     */
    public function __construct($ccaId = null, $uuid = null, $newCcaId = null, $primarySoftSwitchId = null, $secondarySoftSwitchId = null, $objectClass = null, $subscriberType = null, $sipAliasSuffix = null, $sipUserNameSuffix = null)
    {
        $this
            ->setCcaId($ccaId)
            ->setUuid($uuid)
            ->setNewCcaId($newCcaId)
            ->setPrimarySoftSwitchId($primarySoftSwitchId)
            ->setSecondarySoftSwitchId($secondarySoftSwitchId)
            ->setObjectClass($objectClass)
            ->setSubscriberType($subscriberType)
            ->setSipAliasSuffix($sipAliasSuffix)
            ->setSipUserNameSuffix($sipUserNameSuffix);
    }
    /**
     * Get ccaId value
     * @return string
     */
    public function getCcaId()
    {
        return isset($this->ccaId) ? $this->ccaId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCcaId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCcaId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCcaIdForChoiceConstraintsFromSetCcaId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ccaId can\'t be set as the property %s is already set. Only one property must be set among these properties: ccaId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ccaId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ccaId
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setCcaId($ccaId = null)
    {
        // validation for constraint: string
        if (!is_null($ccaId) && !is_string($ccaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccaId, true), gettype($ccaId)), __LINE__);
        }
        // validation for constraint: choice(uuid, ccaId)
        if ('' !== ($ccaIdChoiceErrorMessage = self::validateCcaIdForChoiceConstraintsFromSetCcaId($ccaId))) {
            throw new \InvalidArgumentException($ccaIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($ccaId) || (is_array($ccaId) && empty($ccaId))) {
            unset($this->ccaId);
        } else {
            $this->ccaId = $ccaId;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ccaId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, ccaId)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newCcaId value
     * @return string|null
     */
    public function getNewCcaId()
    {
        return $this->newCcaId;
    }
    /**
     * Set newCcaId value
     * @param string $newCcaId
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setNewCcaId($newCcaId = null)
    {
        // validation for constraint: string
        if (!is_null($newCcaId) && !is_string($newCcaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newCcaId, true), gettype($newCcaId)), __LINE__);
        }
        $this->newCcaId = $newCcaId;
        return $this;
    }
    /**
     * Get primarySoftSwitchId value
     * @return string|null
     */
    public function getPrimarySoftSwitchId()
    {
        return $this->primarySoftSwitchId;
    }
    /**
     * Set primarySoftSwitchId value
     * @param string $primarySoftSwitchId
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setPrimarySoftSwitchId($primarySoftSwitchId = null)
    {
        // validation for constraint: string
        if (!is_null($primarySoftSwitchId) && !is_string($primarySoftSwitchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primarySoftSwitchId, true), gettype($primarySoftSwitchId)), __LINE__);
        }
        $this->primarySoftSwitchId = $primarySoftSwitchId;
        return $this;
    }
    /**
     * Get secondarySoftSwitchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondarySoftSwitchId()
    {
        return isset($this->secondarySoftSwitchId) ? $this->secondarySoftSwitchId : null;
    }
    /**
     * Set secondarySoftSwitchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondarySoftSwitchId
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setSecondarySoftSwitchId($secondarySoftSwitchId = null)
    {
        // validation for constraint: string
        if (!is_null($secondarySoftSwitchId) && !is_string($secondarySoftSwitchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondarySoftSwitchId, true), gettype($secondarySoftSwitchId)), __LINE__);
        }
        if (is_null($secondarySoftSwitchId) || (is_array($secondarySoftSwitchId) && empty($secondarySoftSwitchId))) {
            unset($this->secondarySoftSwitchId);
        } else {
            $this->secondarySoftSwitchId = $secondarySoftSwitchId;
        }
        return $this;
    }
    /**
     * Get objectClass value
     * @return string|null
     */
    public function getObjectClass()
    {
        return $this->objectClass;
    }
    /**
     * Set objectClass value
     * @param string $objectClass
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setObjectClass($objectClass = null)
    {
        // validation for constraint: string
        if (!is_null($objectClass) && !is_string($objectClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectClass, true), gettype($objectClass)), __LINE__);
        }
        $this->objectClass = $objectClass;
        return $this;
    }
    /**
     * Get subscriberType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberType()
    {
        return isset($this->subscriberType) ? $this->subscriberType : null;
    }
    /**
     * Set subscriberType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberType
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setSubscriberType($subscriberType = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberType) && !is_string($subscriberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberType, true), gettype($subscriberType)), __LINE__);
        }
        if (is_null($subscriberType) || (is_array($subscriberType) && empty($subscriberType))) {
            unset($this->subscriberType);
        } else {
            $this->subscriberType = $subscriberType;
        }
        return $this;
    }
    /**
     * Get sipAliasSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSipAliasSuffix()
    {
        return isset($this->sipAliasSuffix) ? $this->sipAliasSuffix : null;
    }
    /**
     * Set sipAliasSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sipAliasSuffix
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setSipAliasSuffix($sipAliasSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipAliasSuffix) && !is_string($sipAliasSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sipAliasSuffix, true), gettype($sipAliasSuffix)), __LINE__);
        }
        if (is_null($sipAliasSuffix) || (is_array($sipAliasSuffix) && empty($sipAliasSuffix))) {
            unset($this->sipAliasSuffix);
        } else {
            $this->sipAliasSuffix = $sipAliasSuffix;
        }
        return $this;
    }
    /**
     * Get sipUserNameSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSipUserNameSuffix()
    {
        return isset($this->sipUserNameSuffix) ? $this->sipUserNameSuffix : null;
    }
    /**
     * Set sipUserNameSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sipUserNameSuffix
     * @return \StructType\UpdateCCAProfilesReq
     */
    public function setSipUserNameSuffix($sipUserNameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipUserNameSuffix) && !is_string($sipUserNameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sipUserNameSuffix, true), gettype($sipUserNameSuffix)), __LINE__);
        }
        if (is_null($sipUserNameSuffix) || (is_array($sipUserNameSuffix) && empty($sipUserNameSuffix))) {
            unset($this->sipUserNameSuffix);
        } else {
            $this->sipUserNameSuffix = $sipUserNameSuffix;
        }
        return $this;
    }
}
