<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAdvertisedPatternsReq StructType
 * @subpackage Structs
 */
class UpdateAdvertisedPatternsReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The patternType
     * Meta information extracted from the WSDL
     * - default: Enterprise Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternType;
    /**
     * The hostedRoutePSTNRule
     * Meta information extracted from the WSDL
     * - default: Specify
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostedRoutePSTNRule;
    /**
     * The pstnFailStrip
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailStrip;
    /**
     * The pstnFailPrepend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailPrepend;
    /**
     * Constructor method for UpdateAdvertisedPatternsReq
     * @uses UpdateAdvertisedPatternsReq::setPattern()
     * @uses UpdateAdvertisedPatternsReq::setUuid()
     * @uses UpdateAdvertisedPatternsReq::setDescription()
     * @uses UpdateAdvertisedPatternsReq::setNewPattern()
     * @uses UpdateAdvertisedPatternsReq::setPatternType()
     * @uses UpdateAdvertisedPatternsReq::setHostedRoutePSTNRule()
     * @uses UpdateAdvertisedPatternsReq::setPstnFailStrip()
     * @uses UpdateAdvertisedPatternsReq::setPstnFailPrepend()
     * @param string $pattern
     * @param string $uuid
     * @param string $description
     * @param string $newPattern
     * @param string $patternType
     * @param string $hostedRoutePSTNRule
     * @param string $pstnFailStrip
     * @param string $pstnFailPrepend
     */
    public function __construct($pattern = null, $uuid = null, $description = null, $newPattern = null, $patternType = 'Enterprise Number', $hostedRoutePSTNRule = 'Specify', $pstnFailStrip = '0', $pstnFailPrepend = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setDescription($description)
            ->setNewPattern($newPattern)
            ->setPatternType($patternType)
            ->setHostedRoutePSTNRule($hostedRoutePSTNRule)
            ->setPstnFailStrip($pstnFailStrip)
            ->setPstnFailPrepend($pstnFailPrepend);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPattern method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPattern method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePatternForChoiceConstraintsFromSetPattern($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property pattern can\'t be set as the property %s is already set. Only one property must be set among these properties: pattern, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pattern
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($patternChoiceErrorMessage = self::validatePatternForChoiceConstraintsFromSetPattern($pattern))) {
            throw new \InvalidArgumentException($patternChoiceErrorMessage, __LINE__);
        }
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'pattern',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, pattern)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPattern, true), gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get patternType value
     * @return string|null
     */
    public function getPatternType()
    {
        return $this->patternType;
    }
    /**
     * Set patternType value
     * @uses \EnumType\XGlobalNumber::valueIsValid()
     * @uses \EnumType\XGlobalNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternType
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPatternType($patternType = 'Enterprise Number')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGlobalNumber::valueIsValid($patternType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XGlobalNumber', is_array($patternType) ? implode(', ', $patternType) : var_export($patternType, true), implode(', ', \EnumType\XGlobalNumber::getValidValues())), __LINE__);
        }
        $this->patternType = $patternType;
        return $this;
    }
    /**
     * Get hostedRoutePSTNRule value
     * @return string|null
     */
    public function getHostedRoutePSTNRule()
    {
        return $this->hostedRoutePSTNRule;
    }
    /**
     * Set hostedRoutePSTNRule value
     * @uses \EnumType\XHostedRoutePatternPSTNRule::valueIsValid()
     * @uses \EnumType\XHostedRoutePatternPSTNRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hostedRoutePSTNRule
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setHostedRoutePSTNRule($hostedRoutePSTNRule = 'Specify')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHostedRoutePatternPSTNRule::valueIsValid($hostedRoutePSTNRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XHostedRoutePatternPSTNRule', is_array($hostedRoutePSTNRule) ? implode(', ', $hostedRoutePSTNRule) : var_export($hostedRoutePSTNRule, true), implode(', ', \EnumType\XHostedRoutePatternPSTNRule::getValidValues())), __LINE__);
        }
        $this->hostedRoutePSTNRule = $hostedRoutePSTNRule;
        return $this;
    }
    /**
     * Get pstnFailStrip value
     * @return string|null
     */
    public function getPstnFailStrip()
    {
        return $this->pstnFailStrip;
    }
    /**
     * Set pstnFailStrip value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailStrip
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPstnFailStrip($pstnFailStrip = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pstnFailStrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($pstnFailStrip) ? implode(', ', $pstnFailStrip) : var_export($pstnFailStrip, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pstnFailStrip = $pstnFailStrip;
        return $this;
    }
    /**
     * Get pstnFailPrepend value
     * @return string|null
     */
    public function getPstnFailPrepend()
    {
        return $this->pstnFailPrepend;
    }
    /**
     * Set pstnFailPrepend value
     * @param string $pstnFailPrepend
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPstnFailPrepend($pstnFailPrepend = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailPrepend) && !is_string($pstnFailPrepend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pstnFailPrepend, true), gettype($pstnFailPrepend)), __LINE__);
        }
        $this->pstnFailPrepend = $pstnFailPrepend;
        return $this;
    }
}
