<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unit StructType
 * Meta information extracted from the WSDL
 * - documentation: In the IOS model unit corresponds to a SLOT(Slot Module)
 * @subpackage Structs
 */
class Unit extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $index;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The subunits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Subunits
     */
    public $subunits;
    /**
     * Constructor method for unit
     * @uses Unit::setIndex()
     * @uses Unit::setProduct()
     * @uses Unit::setSubunits()
     * @param string $index
     * @param string $product
     * @param \StructType\Subunits $subunits
     */
    public function __construct($index = '0', $product = null, \StructType\Subunits $subunits = null)
    {
        $this
            ->setIndex($index)
            ->setProduct($product)
            ->setSubunits($subunits);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\Unit
     */
    public function setIndex($index = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XMGCPSlotModule::valueIsValid()
     * @uses \EnumType\XMGCPSlotModule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\Unit
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMGCPSlotModule::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMGCPSlotModule', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\XMGCPSlotModule::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get subunits value
     * @return \StructType\Subunits|null
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \StructType\Subunits $subunits
     * @return \StructType\Unit
     */
    public function setSubunits(\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
}
