<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StandardResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Returns either the GUID of the object that was altered, or returns true if the operation was successful. Whichever is appropriate for the corresponding request.
 * @subpackage Structs
 */
class StandardResponse extends APIResponse
{
    /**
     * The return
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: (true)|(false)|(\{........-....-....-....-............\})
     * @var string
     */
    public $return;
    /**
     * Constructor method for StandardResponse
     * @uses StandardResponse::setReturn()
     * @param string $return
     */
    public function __construct($return = null)
    {
        $this
            ->setReturn($return);
    }
    /**
     * Get return value
     * @return string|null
     */
    public function getReturn()
    {
        return $this->return;
    }
    /**
     * Set return value
     * @param string $return
     * @return \StructType\StandardResponse
     */
    public function setReturn($return = null)
    {
        // validation for constraint: string
        if (!is_null($return) && !is_string($return)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return, true), gettype($return)), __LINE__);
        }
        // validation for constraint: pattern((true)|(false)|(\{........-....-....-....-............\}))
        if (!is_null($return) && !preg_match('/(true)|(false)|(\\{........-....-....-....-............\\})/', $return)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (true)|(false)|(\{........-....-....-....-............\})', var_export($return, true)), __LINE__);
        }
        $this->return = $return;
        return $this;
    }
}
