<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sipPorts StructType
 * @subpackage Structs
 */
class SipPorts extends AbstractStructBase
{
    /**
     * The sipPhonePort
     * Meta information extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhonePort;
    /**
     * The sipPhoneSecurePort
     * Meta information extracted from the WSDL
     * - default: 5061
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhoneSecurePort;
    /**
     * Constructor method for sipPorts
     * @uses SipPorts::setSipPhonePort()
     * @uses SipPorts::setSipPhoneSecurePort()
     * @param string $sipPhonePort
     * @param string $sipPhoneSecurePort
     */
    public function __construct($sipPhonePort = '5060', $sipPhoneSecurePort = '5061')
    {
        $this
            ->setSipPhonePort($sipPhonePort)
            ->setSipPhoneSecurePort($sipPhoneSecurePort);
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhonePort
     * @return \StructType\SipPorts
     */
    public function setSipPhonePort($sipPhonePort = '5060')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sipPhonePort) ? implode(', ', $sipPhonePort) : var_export($sipPhonePort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get sipPhoneSecurePort value
     * @return string|null
     */
    public function getSipPhoneSecurePort()
    {
        return $this->sipPhoneSecurePort;
    }
    /**
     * Set sipPhoneSecurePort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhoneSecurePort
     * @return \StructType\SipPorts
     */
    public function setSipPhoneSecurePort($sipPhoneSecurePort = '5061')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipPhoneSecurePort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($sipPhoneSecurePort) ? implode(', ', $sipPhoneSecurePort) : var_export($sipPhoneSecurePort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhoneSecurePort = $sipPhoneSecurePort;
        return $this;
    }
}
