<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for roles StructType
 * @subpackage Structs
 */
class Roles extends AbstractStructBase
{
    /**
     * The role
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XCertificateRole[]
     */
    public $role;
    /**
     * Constructor method for roles
     * @uses Roles::setRole()
     * @param \StructType\XCertificateRole[] $role
     */
    public function __construct(array $role = array())
    {
        $this
            ->setRole($role);
    }
    /**
     * Get role value
     * @return \StructType\XCertificateRole[]|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * This method is responsible for validating the values passed to the setRole method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRole method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoleForArrayConstraintsFromSetRole(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rolesRoleItem) {
            // validation for constraint: itemType
            if (!$rolesRoleItem instanceof \StructType\XCertificateRole) {
                $invalidValues[] = is_object($rolesRoleItem) ? get_class($rolesRoleItem) : sprintf('%s(%s)', gettype($rolesRoleItem), var_export($rolesRoleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The role property can only contain items of type \StructType\XCertificateRole, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set role value
     * @throws \InvalidArgumentException
     * @param \StructType\XCertificateRole[] $role
     * @return \StructType\Roles
     */
    public function setRole(array $role = array())
    {
        // validation for constraint: array
        if ('' !== ($roleArrayErrorMessage = self::validateRoleForArrayConstraintsFromSetRole($role))) {
            throw new \InvalidArgumentException($roleArrayErrorMessage, __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Add item to role value
     * @throws \InvalidArgumentException
     * @param \StructType\XCertificateRole $item
     * @return \StructType\Roles
     */
    public function addToRole(\StructType\XCertificateRole $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XCertificateRole) {
            throw new \InvalidArgumentException(sprintf('The role property can only contain items of type \StructType\XCertificateRole, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->role[] = $item;
        return $this;
    }
}
