<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveDhcpSubnetReq StructType
 * @subpackage Structs
 */
class RemoveDhcpSubnetReq extends AbstractStructBase
{
    /**
     * The dhcpServerName
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $dhcpServerName;
    /**
     * The subnetIpAddress
     * Meta information extracted from the WSDL
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subnetIpAddress;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | dhcpServerName | subnetIpAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveDhcpSubnetReq
     * @uses RemoveDhcpSubnetReq::setDhcpServerName()
     * @uses RemoveDhcpSubnetReq::setSubnetIpAddress()
     * @uses RemoveDhcpSubnetReq::setUuid()
     * @uses RemoveDhcpSubnetReq::setSequence()
     * @param \StructType\XFkType $dhcpServerName
     * @param string $subnetIpAddress
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct(\StructType\XFkType $dhcpServerName = null, $subnetIpAddress = null, $uuid = null, $sequence = null)
    {
        $this
            ->setDhcpServerName($dhcpServerName)
            ->setSubnetIpAddress($subnetIpAddress)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get dhcpServerName value
     * @return \StructType\XFkType
     */
    public function getDhcpServerName()
    {
        return isset($this->dhcpServerName) ? $this->dhcpServerName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDhcpServerName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDhcpServerName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDhcpServerNameForChoiceConstraintsFromSetDhcpServerName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'subnetIpAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property dhcpServerName can\'t be set as the property %s is already set. Only one property must be set among these properties: dhcpServerName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set dhcpServerName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\XFkType $dhcpServerName
     * @return \StructType\RemoveDhcpSubnetReq
     */
    public function setDhcpServerName(\StructType\XFkType $dhcpServerName = null)
    {
        // validation for constraint: choice(uuid, dhcpServerName, subnetIpAddress)
        if ('' !== ($dhcpServerNameChoiceErrorMessage = self::validateDhcpServerNameForChoiceConstraintsFromSetDhcpServerName($dhcpServerName))) {
            throw new \InvalidArgumentException($dhcpServerNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($dhcpServerName) || (is_array($dhcpServerName) && empty($dhcpServerName))) {
            unset($this->dhcpServerName);
        } else {
            $this->dhcpServerName = $dhcpServerName;
        }
        return $this;
    }
    /**
     * Get subnetIpAddress value
     * @return string
     */
    public function getSubnetIpAddress()
    {
        return isset($this->subnetIpAddress) ? $this->subnetIpAddress : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSubnetIpAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubnetIpAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSubnetIpAddressForChoiceConstraintsFromSetSubnetIpAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'uuid',
            'dhcpServerName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property subnetIpAddress can\'t be set as the property %s is already set. Only one property must be set among these properties: subnetIpAddress, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set subnetIpAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $subnetIpAddress
     * @return \StructType\RemoveDhcpSubnetReq
     */
    public function setSubnetIpAddress($subnetIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subnetIpAddress) && !is_string($subnetIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subnetIpAddress, true), gettype($subnetIpAddress)), __LINE__);
        }
        // validation for constraint: choice(uuid, dhcpServerName, subnetIpAddress)
        if ('' !== ($subnetIpAddressChoiceErrorMessage = self::validateSubnetIpAddressForChoiceConstraintsFromSetSubnetIpAddress($subnetIpAddress))) {
            throw new \InvalidArgumentException($subnetIpAddressChoiceErrorMessage, __LINE__);
        }
        if (is_null($subnetIpAddress) || (is_array($subnetIpAddress) && empty($subnetIpAddress))) {
            unset($this->subnetIpAddress);
        } else {
            $this->subnetIpAddress = $subnetIpAddress;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUuid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUuid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUuidForChoiceConstraintsFromSetUuid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'dhcpServerName',
            'subnetIpAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property uuid can\'t be set as the property %s is already set. Only one property must be set among these properties: uuid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uuid
     * @return \StructType\RemoveDhcpSubnetReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: choice(uuid, dhcpServerName, subnetIpAddress)
        if ('' !== ($uuidChoiceErrorMessage = self::validateUuidForChoiceConstraintsFromSetUuid($uuid))) {
            throw new \InvalidArgumentException($uuidChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\RemoveDhcpSubnetReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
