<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedPolicies StructType
 * @subpackage Structs
 */
class RelatedPolicies extends XCommonMembersExtension
{
    /**
     * The relatedPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XPolicyRelationship[]
     */
    public $relatedPolicy;
    /**
     * Constructor method for relatedPolicies
     * @uses RelatedPolicies::setRelatedPolicy()
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     */
    public function __construct(array $relatedPolicy = array())
    {
        $this
            ->setRelatedPolicy($relatedPolicy);
    }
    /**
     * Get relatedPolicy value
     * @return \StructType\XPolicyRelationship[]|null
     */
    public function getRelatedPolicy()
    {
        return $this->relatedPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedPolicyForArrayConstraintsFromSetRelatedPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedPoliciesRelatedPolicyItem) {
            // validation for constraint: itemType
            if (!$relatedPoliciesRelatedPolicyItem instanceof \StructType\XPolicyRelationship) {
                $invalidValues[] = is_object($relatedPoliciesRelatedPolicyItem) ? get_class($relatedPoliciesRelatedPolicyItem) : sprintf('%s(%s)', gettype($relatedPoliciesRelatedPolicyItem), var_export($relatedPoliciesRelatedPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatedPolicy property can only contain items of type \StructType\XPolicyRelationship, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     * @return \StructType\RelatedPolicies
     */
    public function setRelatedPolicy(array $relatedPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedPolicyArrayErrorMessage = self::validateRelatedPolicyForArrayConstraintsFromSetRelatedPolicy($relatedPolicy))) {
            throw new \InvalidArgumentException($relatedPolicyArrayErrorMessage, __LINE__);
        }
        $this->relatedPolicy = $relatedPolicy;
        return $this;
    }
    /**
     * Add item to relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship $item
     * @return \StructType\RelatedPolicies
     */
    public function addToRelatedPolicy(\StructType\XPolicyRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPolicyRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of type \StructType\XPolicyRelationship, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatedPolicy[] = $item;
        return $this;
    }
}
