<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedLocations StructType
 * @subpackage Structs
 */
class RelatedLocations extends AbstractStructBase
{
    /**
     * The relatedLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XLocationRelationship[]
     */
    public $relatedLocation;
    /**
     * Constructor method for relatedLocations
     * @uses RelatedLocations::setRelatedLocation()
     * @param \StructType\XLocationRelationship[] $relatedLocation
     */
    public function __construct(array $relatedLocation = array())
    {
        $this
            ->setRelatedLocation($relatedLocation);
    }
    /**
     * Get relatedLocation value
     * @return \StructType\XLocationRelationship[]|null
     */
    public function getRelatedLocation()
    {
        return $this->relatedLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedLocationForArrayConstraintsFromSetRelatedLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedLocationsRelatedLocationItem) {
            // validation for constraint: itemType
            if (!$relatedLocationsRelatedLocationItem instanceof \StructType\XLocationRelationship) {
                $invalidValues[] = is_object($relatedLocationsRelatedLocationItem) ? get_class($relatedLocationsRelatedLocationItem) : sprintf('%s(%s)', gettype($relatedLocationsRelatedLocationItem), var_export($relatedLocationsRelatedLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatedLocation property can only contain items of type \StructType\XLocationRelationship, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatedLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\XLocationRelationship[] $relatedLocation
     * @return \StructType\RelatedLocations
     */
    public function setRelatedLocation(array $relatedLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedLocationArrayErrorMessage = self::validateRelatedLocationForArrayConstraintsFromSetRelatedLocation($relatedLocation))) {
            throw new \InvalidArgumentException($relatedLocationArrayErrorMessage, __LINE__);
        }
        $this->relatedLocation = $relatedLocation;
        return $this;
    }
    /**
     * Add item to relatedLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\XLocationRelationship $item
     * @return \StructType\RelatedLocations
     */
    public function addToRelatedLocation(\StructType\XLocationRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XLocationRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedLocation property can only contain items of type \StructType\XLocationRelationship, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatedLocation[] = $item;
        return $this;
    }
}
