<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedGroups StructType
 * Meta information extracted from the WSDL
 * - documentation: Read-only. AXL API automatically adds the required entries in the AARDialPrefixMatrix table.
 * @subpackage Structs
 */
class RelatedGroups extends AbstractStructBase
{
    /**
     * The relatedGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RAarGroupRelationship[]
     */
    public $relatedGroup;
    /**
     * Constructor method for relatedGroups
     * @uses RelatedGroups::setRelatedGroup()
     * @param \StructType\RAarGroupRelationship[] $relatedGroup
     */
    public function __construct(array $relatedGroup = array())
    {
        $this
            ->setRelatedGroup($relatedGroup);
    }
    /**
     * Get relatedGroup value
     * @return \StructType\RAarGroupRelationship[]|null
     */
    public function getRelatedGroup()
    {
        return $this->relatedGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedGroupForArrayConstraintsFromSetRelatedGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatedGroupsRelatedGroupItem) {
            // validation for constraint: itemType
            if (!$relatedGroupsRelatedGroupItem instanceof \StructType\RAarGroupRelationship) {
                $invalidValues[] = is_object($relatedGroupsRelatedGroupItem) ? get_class($relatedGroupsRelatedGroupItem) : sprintf('%s(%s)', gettype($relatedGroupsRelatedGroupItem), var_export($relatedGroupsRelatedGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatedGroup property can only contain items of type \StructType\RAarGroupRelationship, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatedGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\RAarGroupRelationship[] $relatedGroup
     * @return \StructType\RelatedGroups
     */
    public function setRelatedGroup(array $relatedGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedGroupArrayErrorMessage = self::validateRelatedGroupForArrayConstraintsFromSetRelatedGroup($relatedGroup))) {
            throw new \InvalidArgumentException($relatedGroupArrayErrorMessage, __LINE__);
        }
        $this->relatedGroup = $relatedGroup;
        return $this;
    }
    /**
     * Add item to relatedGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\RAarGroupRelationship $item
     * @return \StructType\RelatedGroups
     */
    public function addToRelatedGroup(\StructType\RAarGroupRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RAarGroupRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedGroup property can only contain items of type \StructType\RAarGroupRelationship, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatedGroup[] = $item;
        return $this;
    }
}
