<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RVoiceMailProfile StructType
 * @subpackage Structs
 */
class RVoiceMailProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailProfile as Default. Instead, the corresponding tag of another VoiceMailProfile should be set to true.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The voiceMailboxMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voiceMailboxMask;
    /**
     * The voiceMailPilot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RVmPilot
     */
    public $voiceMailPilot;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RVoiceMailProfile
     * @uses RVoiceMailProfile::setName()
     * @uses RVoiceMailProfile::setDescription()
     * @uses RVoiceMailProfile::setIsDefault()
     * @uses RVoiceMailProfile::setVoiceMailboxMask()
     * @uses RVoiceMailProfile::setVoiceMailPilot()
     * @uses RVoiceMailProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isDefault
     * @param string $voiceMailboxMask
     * @param \StructType\RVmPilot $voiceMailPilot
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isDefault = null, $voiceMailboxMask = null, \StructType\RVmPilot $voiceMailPilot = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setVoiceMailboxMask($voiceMailboxMask)
            ->setVoiceMailPilot($voiceMailPilot)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RVoiceMailProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RVoiceMailProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\RVoiceMailProfile
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isDefault, true)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get voiceMailboxMask value
     * @return string|null
     */
    public function getVoiceMailboxMask()
    {
        return $this->voiceMailboxMask;
    }
    /**
     * Set voiceMailboxMask value
     * @param string $voiceMailboxMask
     * @return \StructType\RVoiceMailProfile
     */
    public function setVoiceMailboxMask($voiceMailboxMask = null)
    {
        // validation for constraint: string
        if (!is_null($voiceMailboxMask) && !is_string($voiceMailboxMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voiceMailboxMask, true), gettype($voiceMailboxMask)), __LINE__);
        }
        $this->voiceMailboxMask = $voiceMailboxMask;
        return $this;
    }
    /**
     * Get voiceMailPilot value
     * @return \StructType\RVmPilot|null
     */
    public function getVoiceMailPilot()
    {
        return $this->voiceMailPilot;
    }
    /**
     * Set voiceMailPilot value
     * @param \StructType\RVmPilot $voiceMailPilot
     * @return \StructType\RVoiceMailProfile
     */
    public function setVoiceMailPilot(\StructType\RVmPilot $voiceMailPilot = null)
    {
        $this->voiceMailPilot = $voiceMailPilot;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RVoiceMailProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
