<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUniversalDeviceTemplate StructType
 * @subpackage Structs
 */
class RUniversalDeviceTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The deviceDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceDescription;
    /**
     * The devicePool
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePool;
    /**
     * The deviceSecurityProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $deviceSecurityProfile;
    /**
     * The sipProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipProfile;
    /**
     * The phoneButtonTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $phoneButtonTemplate;
    /**
     * The sipDialRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipDialRules;
    /**
     * The callingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpace;
    /**
     * The callingPartyTransformationCSSForInboundCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartyTransformationCSSForInboundCalls;
    /**
     * The callingPartyTransformationCSSForOutboundCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartyTransformationCSSForOutboundCalls;
    /**
     * The reroutingCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $reroutingCallingSearchSpace;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    /**
     * The commonPhoneProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonPhoneProfile;
    /**
     * The commonDeviceConfiguration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfiguration;
    /**
     * The softkeyTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $softkeyTemplate;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The phonePersonalization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phonePersonalization;
    /**
     * The mtpPreferredOriginatingCodec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpPreferredOriginatingCodec;
    /**
     * The outboundCallRollover
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The mediaTerminationPointRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mediaTerminationPointRequired;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requiredDtmfReception
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requiredDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The speeddials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Speeddials
     */
    public $speeddials;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The protectedDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $protectedDevice;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The servicesProvisioning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicesProvisioning;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The secureShellUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureShellUser;
    /**
     * The secureShellPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureShellPassword;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The mlppDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mlppDomain;
    /**
     * The mlppIndication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndication;
    /**
     * The mlppPreemption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppPreemption;
    /**
     * The doNotDisturb
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $doNotDisturb;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndIncomingCallAlert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndIncomingCallAlert;
    /**
     * The aarGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarGroup;
    /**
     * The aarCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarCallingSearchSpace;
    /**
     * The blfPresenceGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $blfPresenceGroup;
    /**
     * The blfAudibleAlertSettingPhoneBusy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blfAudibleAlertSettingPhoneBusy;
    /**
     * The blfAudibleAlertSettingPhoneIdle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blfAudibleAlertSettingPhoneIdle;
    /**
     * The userHoldMohAudioSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSource;
    /**
     * The networkHoldMohAudioSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSource;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $location;
    /**
     * The geoLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocation;
    /**
     * The deviceMobilityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The mediaResourceGroupList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mediaResourceGroupList;
    /**
     * The remoteDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The hotlineDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The requireOffPremiseLocation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The ownerUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ownerUserId;
    /**
     * The mobilityUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mobilityUserId;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The builtInBridge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $builtInBridge;
    /**
     * The allowControlOfDeviceFromCti
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowControlOfDeviceFromCti;
    /**
     * The ignorePresentationIndicators
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The enableExtensionMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The recordingOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingOptions;
    /**
     * The privacy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $privacy;
    /**
     * The loggedIntoHuntGroup
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $loggedIntoHuntGroup;
    /**
     * The proxyServer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyServer;
    /**
     * The servicesUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicesUrl;
    /**
     * The idle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idle;
    /**
     * The idleTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleTimer;
    /**
     * The secureDirUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureDirUrl;
    /**
     * The messages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messages;
    /**
     * The secureIdleUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The authenticationServer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationServer;
    /**
     * The directory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directory;
    /**
     * The secureServicesUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The information
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $information;
    /**
     * The secureMessagesUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureMessagesUrl;
    /**
     * The secureInformationUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureAuthenticationUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The externalPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalPhoneNumber;
    /**
     * The audibleMsgWaitingicatorPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMsgWaitingicatorPolicy;
    /**
     * The logMissedCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $logMissedCalls;
    /**
     * The visualMsgWaitingIndicatorPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $visualMsgWaitingIndicatorPolicy;
    /**
     * The lineLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lineLabel;
    /**
     * The displayCallerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayCallerId;
    /**
     * The MaxNumberOfCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaxNumberOfCalls;
    /**
     * The ringSettingWhenPhoneIdle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingWhenPhoneIdle;
    /**
     * The busyTrigger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The ringSettingWhenPhoneInUse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingWhenPhoneInUse;
    /**
     * The directoryNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $directoryNumber;
    /**
     * The recordingProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $recordingProfile;
    /**
     * The callPickupGroupAudioAlertSettingPhoneActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneActive;
    /**
     * The callPickupGroupAudioAlertSettingPhoneIdle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneIdle;
    /**
     * The monitoringCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $monitoringCallingSearchSpace;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUniversalDeviceTemplate
     * @uses RUniversalDeviceTemplate::setName()
     * @uses RUniversalDeviceTemplate::setDeviceDescription()
     * @uses RUniversalDeviceTemplate::setDevicePool()
     * @uses RUniversalDeviceTemplate::setDeviceSecurityProfile()
     * @uses RUniversalDeviceTemplate::setSipProfile()
     * @uses RUniversalDeviceTemplate::setPhoneButtonTemplate()
     * @uses RUniversalDeviceTemplate::setSipDialRules()
     * @uses RUniversalDeviceTemplate::setCallingSearchSpace()
     * @uses RUniversalDeviceTemplate::setCallingPartyTransformationCSSForInboundCalls()
     * @uses RUniversalDeviceTemplate::setCallingPartyTransformationCSSForOutboundCalls()
     * @uses RUniversalDeviceTemplate::setReroutingCallingSearchSpace()
     * @uses RUniversalDeviceTemplate::setSubscribeCallingSearchSpaceName()
     * @uses RUniversalDeviceTemplate::setUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
     * @uses RUniversalDeviceTemplate::setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
     * @uses RUniversalDeviceTemplate::setCommonPhoneProfile()
     * @uses RUniversalDeviceTemplate::setCommonDeviceConfiguration()
     * @uses RUniversalDeviceTemplate::setSoftkeyTemplate()
     * @uses RUniversalDeviceTemplate::setFeatureControlPolicy()
     * @uses RUniversalDeviceTemplate::setPhonePersonalization()
     * @uses RUniversalDeviceTemplate::setMtpPreferredOriginatingCodec()
     * @uses RUniversalDeviceTemplate::setOutboundCallRollover()
     * @uses RUniversalDeviceTemplate::setMediaTerminationPointRequired()
     * @uses RUniversalDeviceTemplate::setUnattendedPort()
     * @uses RUniversalDeviceTemplate::setRequiredDtmfReception()
     * @uses RUniversalDeviceTemplate::setRfc2833Disabled()
     * @uses RUniversalDeviceTemplate::setSpeeddials()
     * @uses RUniversalDeviceTemplate::setUseTrustedRelayPoint()
     * @uses RUniversalDeviceTemplate::setProtectedDevice()
     * @uses RUniversalDeviceTemplate::setAuthenticationMode()
     * @uses RUniversalDeviceTemplate::setAuthenticationString()
     * @uses RUniversalDeviceTemplate::setKeySize()
     * @uses RUniversalDeviceTemplate::setServicesProvisioning()
     * @uses RUniversalDeviceTemplate::setPacketCaptureMode()
     * @uses RUniversalDeviceTemplate::setPacketCaptureDuration()
     * @uses RUniversalDeviceTemplate::setSecureShellUser()
     * @uses RUniversalDeviceTemplate::setSecureShellPassword()
     * @uses RUniversalDeviceTemplate::setUserLocale()
     * @uses RUniversalDeviceTemplate::setNetworkLocale()
     * @uses RUniversalDeviceTemplate::setMlppDomain()
     * @uses RUniversalDeviceTemplate::setMlppIndication()
     * @uses RUniversalDeviceTemplate::setMlppPreemption()
     * @uses RUniversalDeviceTemplate::setDoNotDisturb()
     * @uses RUniversalDeviceTemplate::setDndOption()
     * @uses RUniversalDeviceTemplate::setDndIncomingCallAlert()
     * @uses RUniversalDeviceTemplate::setAarGroup()
     * @uses RUniversalDeviceTemplate::setAarCallingSearchSpace()
     * @uses RUniversalDeviceTemplate::setBlfPresenceGroup()
     * @uses RUniversalDeviceTemplate::setBlfAudibleAlertSettingPhoneBusy()
     * @uses RUniversalDeviceTemplate::setBlfAudibleAlertSettingPhoneIdle()
     * @uses RUniversalDeviceTemplate::setUserHoldMohAudioSource()
     * @uses RUniversalDeviceTemplate::setNetworkHoldMohAudioSource()
     * @uses RUniversalDeviceTemplate::setLocation()
     * @uses RUniversalDeviceTemplate::setGeoLocation()
     * @uses RUniversalDeviceTemplate::setDeviceMobilityMode()
     * @uses RUniversalDeviceTemplate::setMediaResourceGroupList()
     * @uses RUniversalDeviceTemplate::setRemoteDevice()
     * @uses RUniversalDeviceTemplate::setHotlineDevice()
     * @uses RUniversalDeviceTemplate::setRetryVideoCallAsAudio()
     * @uses RUniversalDeviceTemplate::setRequireOffPremiseLocation()
     * @uses RUniversalDeviceTemplate::setOwnerUserId()
     * @uses RUniversalDeviceTemplate::setMobilityUserId()
     * @uses RUniversalDeviceTemplate::setJoinAcrossLines()
     * @uses RUniversalDeviceTemplate::setAlwaysUsePrimeLine()
     * @uses RUniversalDeviceTemplate::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses RUniversalDeviceTemplate::setSingleButtonBarge()
     * @uses RUniversalDeviceTemplate::setBuiltInBridge()
     * @uses RUniversalDeviceTemplate::setAllowControlOfDeviceFromCti()
     * @uses RUniversalDeviceTemplate::setIgnorePresentationIndicators()
     * @uses RUniversalDeviceTemplate::setEnableExtensionMobility()
     * @uses RUniversalDeviceTemplate::setRecordingOptions()
     * @uses RUniversalDeviceTemplate::setPrivacy()
     * @uses RUniversalDeviceTemplate::setLoggedIntoHuntGroup()
     * @uses RUniversalDeviceTemplate::setProxyServer()
     * @uses RUniversalDeviceTemplate::setServicesUrl()
     * @uses RUniversalDeviceTemplate::setIdle()
     * @uses RUniversalDeviceTemplate::setIdleTimer()
     * @uses RUniversalDeviceTemplate::setSecureDirUrl()
     * @uses RUniversalDeviceTemplate::setMessages()
     * @uses RUniversalDeviceTemplate::setSecureIdleUrl()
     * @uses RUniversalDeviceTemplate::setAuthenticationServer()
     * @uses RUniversalDeviceTemplate::setDirectory()
     * @uses RUniversalDeviceTemplate::setSecureServicesUrl()
     * @uses RUniversalDeviceTemplate::setInformation()
     * @uses RUniversalDeviceTemplate::setSecureMessagesUrl()
     * @uses RUniversalDeviceTemplate::setSecureInformationUrl()
     * @uses RUniversalDeviceTemplate::setSecureAuthenticationUrl()
     * @uses RUniversalDeviceTemplate::setExternalPhoneNumber()
     * @uses RUniversalDeviceTemplate::setAudibleMsgWaitingicatorPolicy()
     * @uses RUniversalDeviceTemplate::setLogMissedCalls()
     * @uses RUniversalDeviceTemplate::setVisualMsgWaitingIndicatorPolicy()
     * @uses RUniversalDeviceTemplate::setLineLabel()
     * @uses RUniversalDeviceTemplate::setDisplayCallerId()
     * @uses RUniversalDeviceTemplate::setMaxNumberOfCalls()
     * @uses RUniversalDeviceTemplate::setRingSettingWhenPhoneIdle()
     * @uses RUniversalDeviceTemplate::setBusyTrigger()
     * @uses RUniversalDeviceTemplate::setRingSettingWhenPhoneInUse()
     * @uses RUniversalDeviceTemplate::setDirectoryNumber()
     * @uses RUniversalDeviceTemplate::setRecordingProfile()
     * @uses RUniversalDeviceTemplate::setCallPickupGroupAudioAlertSettingPhoneActive()
     * @uses RUniversalDeviceTemplate::setCallPickupGroupAudioAlertSettingPhoneIdle()
     * @uses RUniversalDeviceTemplate::setMonitoringCallingSearchSpace()
     * @uses RUniversalDeviceTemplate::setConfidentialAccess()
     * @uses RUniversalDeviceTemplate::setServices()
     * @uses RUniversalDeviceTemplate::setUuid()
     * @param string $name
     * @param string $deviceDescription
     * @param \StructType\XFkType $devicePool
     * @param \StructType\XFkType $deviceSecurityProfile
     * @param \StructType\XFkType $sipProfile
     * @param \StructType\XFkType $phoneButtonTemplate
     * @param \StructType\XFkType $sipDialRules
     * @param \StructType\XFkType $callingSearchSpace
     * @param \StructType\XFkType $callingPartyTransformationCSSForInboundCalls
     * @param \StructType\XFkType $callingPartyTransformationCSSForOutboundCalls
     * @param \StructType\XFkType $reroutingCallingSearchSpace
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @param \StructType\XFkType $commonPhoneProfile
     * @param \StructType\XFkType $commonDeviceConfiguration
     * @param \StructType\XFkType $softkeyTemplate
     * @param \StructType\XFkType $featureControlPolicy
     * @param string $phonePersonalization
     * @param string $mtpPreferredOriginatingCodec
     * @param string $outboundCallRollover
     * @param string $mediaTerminationPointRequired
     * @param string $unattendedPort
     * @param string $requiredDtmfReception
     * @param string $rfc2833Disabled
     * @param \StructType\Speeddials $speeddials
     * @param string $useTrustedRelayPoint
     * @param string $protectedDevice
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $servicesProvisioning
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $secureShellUser
     * @param string $secureShellPassword
     * @param string $userLocale
     * @param string $networkLocale
     * @param \StructType\XFkType $mlppDomain
     * @param string $mlppIndication
     * @param string $mlppPreemption
     * @param string $doNotDisturb
     * @param string $dndOption
     * @param string $dndIncomingCallAlert
     * @param \StructType\XFkType $aarGroup
     * @param \StructType\XFkType $aarCallingSearchSpace
     * @param \StructType\XFkType $blfPresenceGroup
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @param string $userHoldMohAudioSource
     * @param string $networkHoldMohAudioSource
     * @param \StructType\XFkType $location
     * @param \StructType\XFkType $geoLocation
     * @param string $deviceMobilityMode
     * @param \StructType\XFkType $mediaResourceGroupList
     * @param string $remoteDevice
     * @param string $hotlineDevice
     * @param string $retryVideoCallAsAudio
     * @param string $requireOffPremiseLocation
     * @param \StructType\XFkType $ownerUserId
     * @param \StructType\XFkType $mobilityUserId
     * @param string $joinAcrossLines
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param string $singleButtonBarge
     * @param string $builtInBridge
     * @param string $allowControlOfDeviceFromCti
     * @param string $ignorePresentationIndicators
     * @param string $enableExtensionMobility
     * @param string $recordingOptions
     * @param string $privacy
     * @param string $loggedIntoHuntGroup
     * @param string $proxyServer
     * @param string $servicesUrl
     * @param string $idle
     * @param string $idleTimer
     * @param string $secureDirUrl
     * @param string $messages
     * @param string $secureIdleUrl
     * @param string $authenticationServer
     * @param string $directory
     * @param string $secureServicesUrl
     * @param string $information
     * @param string $secureMessagesUrl
     * @param string $secureInformationUrl
     * @param string $secureAuthenticationUrl
     * @param string $externalPhoneNumber
     * @param string $audibleMsgWaitingicatorPolicy
     * @param string $logMissedCalls
     * @param string $visualMsgWaitingIndicatorPolicy
     * @param string $lineLabel
     * @param string $displayCallerId
     * @param string $maxNumberOfCalls
     * @param string $ringSettingWhenPhoneIdle
     * @param string $busyTrigger
     * @param string $ringSettingWhenPhoneInUse
     * @param \StructType\XFkType $directoryNumber
     * @param \StructType\XFkType $recordingProfile
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @param \StructType\XFkType $monitoringCallingSearchSpace
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\Services $services
     * @param string $uuid
     */
    public function __construct($name = null, $deviceDescription = null, \StructType\XFkType $devicePool = null, \StructType\XFkType $deviceSecurityProfile = null, \StructType\XFkType $sipProfile = null, \StructType\XFkType $phoneButtonTemplate = null, \StructType\XFkType $sipDialRules = null, \StructType\XFkType $callingSearchSpace = null, \StructType\XFkType $callingPartyTransformationCSSForInboundCalls = null, \StructType\XFkType $callingPartyTransformationCSSForOutboundCalls = null, \StructType\XFkType $reroutingCallingSearchSpace = null, \StructType\XFkType $subscribeCallingSearchSpaceName = null, $useDevicePoolCallingPartyTransformationCSSforInboundCalls = null, $useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null, \StructType\XFkType $commonPhoneProfile = null, \StructType\XFkType $commonDeviceConfiguration = null, \StructType\XFkType $softkeyTemplate = null, \StructType\XFkType $featureControlPolicy = null, $phonePersonalization = null, $mtpPreferredOriginatingCodec = null, $outboundCallRollover = null, $mediaTerminationPointRequired = null, $unattendedPort = null, $requiredDtmfReception = null, $rfc2833Disabled = null, \StructType\Speeddials $speeddials = null, $useTrustedRelayPoint = null, $protectedDevice = null, $authenticationMode = null, $authenticationString = null, $keySize = null, $servicesProvisioning = null, $packetCaptureMode = null, $packetCaptureDuration = null, $secureShellUser = null, $secureShellPassword = null, $userLocale = null, $networkLocale = null, \StructType\XFkType $mlppDomain = null, $mlppIndication = null, $mlppPreemption = null, $doNotDisturb = null, $dndOption = null, $dndIncomingCallAlert = null, \StructType\XFkType $aarGroup = null, \StructType\XFkType $aarCallingSearchSpace = null, \StructType\XFkType $blfPresenceGroup = null, $blfAudibleAlertSettingPhoneBusy = null, $blfAudibleAlertSettingPhoneIdle = null, $userHoldMohAudioSource = null, $networkHoldMohAudioSource = null, \StructType\XFkType $location = null, \StructType\XFkType $geoLocation = null, $deviceMobilityMode = null, \StructType\XFkType $mediaResourceGroupList = null, $remoteDevice = null, $hotlineDevice = null, $retryVideoCallAsAudio = null, $requireOffPremiseLocation = null, \StructType\XFkType $ownerUserId = null, \StructType\XFkType $mobilityUserId = null, $joinAcrossLines = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, $singleButtonBarge = null, $builtInBridge = null, $allowControlOfDeviceFromCti = null, $ignorePresentationIndicators = null, $enableExtensionMobility = null, $recordingOptions = null, $privacy = null, $loggedIntoHuntGroup = null, $proxyServer = null, $servicesUrl = null, $idle = null, $idleTimer = null, $secureDirUrl = null, $messages = null, $secureIdleUrl = null, $authenticationServer = null, $directory = null, $secureServicesUrl = null, $information = null, $secureMessagesUrl = null, $secureInformationUrl = null, $secureAuthenticationUrl = null, $externalPhoneNumber = null, $audibleMsgWaitingicatorPolicy = null, $logMissedCalls = null, $visualMsgWaitingIndicatorPolicy = null, $lineLabel = null, $displayCallerId = null, $maxNumberOfCalls = null, $ringSettingWhenPhoneIdle = null, $busyTrigger = null, $ringSettingWhenPhoneInUse = null, \StructType\XFkType $directoryNumber = null, \StructType\XFkType $recordingProfile = null, $callPickupGroupAudioAlertSettingPhoneActive = null, $callPickupGroupAudioAlertSettingPhoneIdle = null, \StructType\XFkType $monitoringCallingSearchSpace = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\Services $services = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDeviceDescription($deviceDescription)
            ->setDevicePool($devicePool)
            ->setDeviceSecurityProfile($deviceSecurityProfile)
            ->setSipProfile($sipProfile)
            ->setPhoneButtonTemplate($phoneButtonTemplate)
            ->setSipDialRules($sipDialRules)
            ->setCallingSearchSpace($callingSearchSpace)
            ->setCallingPartyTransformationCSSForInboundCalls($callingPartyTransformationCSSForInboundCalls)
            ->setCallingPartyTransformationCSSForOutboundCalls($callingPartyTransformationCSSForOutboundCalls)
            ->setReroutingCallingSearchSpace($reroutingCallingSearchSpace)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls)
            ->setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)
            ->setCommonPhoneProfile($commonPhoneProfile)
            ->setCommonDeviceConfiguration($commonDeviceConfiguration)
            ->setSoftkeyTemplate($softkeyTemplate)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setPhonePersonalization($phonePersonalization)
            ->setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setMediaTerminationPointRequired($mediaTerminationPointRequired)
            ->setUnattendedPort($unattendedPort)
            ->setRequiredDtmfReception($requiredDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setSpeeddials($speeddials)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setProtectedDevice($protectedDevice)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setServicesProvisioning($servicesProvisioning)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSecureShellUser($secureShellUser)
            ->setSecureShellPassword($secureShellPassword)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setMlppDomain($mlppDomain)
            ->setMlppIndication($mlppIndication)
            ->setMlppPreemption($mlppPreemption)
            ->setDoNotDisturb($doNotDisturb)
            ->setDndOption($dndOption)
            ->setDndIncomingCallAlert($dndIncomingCallAlert)
            ->setAarGroup($aarGroup)
            ->setAarCallingSearchSpace($aarCallingSearchSpace)
            ->setBlfPresenceGroup($blfPresenceGroup)
            ->setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy)
            ->setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle)
            ->setUserHoldMohAudioSource($userHoldMohAudioSource)
            ->setNetworkHoldMohAudioSource($networkHoldMohAudioSource)
            ->setLocation($location)
            ->setGeoLocation($geoLocation)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setMediaResourceGroupList($mediaResourceGroupList)
            ->setRemoteDevice($remoteDevice)
            ->setHotlineDevice($hotlineDevice)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setOwnerUserId($ownerUserId)
            ->setMobilityUserId($mobilityUserId)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setBuiltInBridge($builtInBridge)
            ->setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setRecordingOptions($recordingOptions)
            ->setPrivacy($privacy)
            ->setLoggedIntoHuntGroup($loggedIntoHuntGroup)
            ->setProxyServer($proxyServer)
            ->setServicesUrl($servicesUrl)
            ->setIdle($idle)
            ->setIdleTimer($idleTimer)
            ->setSecureDirUrl($secureDirUrl)
            ->setMessages($messages)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAuthenticationServer($authenticationServer)
            ->setDirectory($directory)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setInformation($information)
            ->setSecureMessagesUrl($secureMessagesUrl)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setExternalPhoneNumber($externalPhoneNumber)
            ->setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy)
            ->setLogMissedCalls($logMissedCalls)
            ->setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy)
            ->setLineLabel($lineLabel)
            ->setDisplayCallerId($displayCallerId)
            ->setMaxNumberOfCalls($maxNumberOfCalls)
            ->setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle)
            ->setBusyTrigger($busyTrigger)
            ->setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse)
            ->setDirectoryNumber($directoryNumber)
            ->setRecordingProfile($recordingProfile)
            ->setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive)
            ->setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle)
            ->setMonitoringCallingSearchSpace($monitoringCallingSearchSpace)
            ->setConfidentialAccess($confidentialAccess)
            ->setServices($services)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get deviceDescription value
     * @return string|null
     */
    public function getDeviceDescription()
    {
        return $this->deviceDescription;
    }
    /**
     * Set deviceDescription value
     * @param string $deviceDescription
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDeviceDescription($deviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDescription) && !is_string($deviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceDescription, true), gettype($deviceDescription)), __LINE__);
        }
        $this->deviceDescription = $deviceDescription;
        return $this;
    }
    /**
     * Get devicePool value
     * @return \StructType\XFkType|null
     */
    public function getDevicePool()
    {
        return $this->devicePool;
    }
    /**
     * Set devicePool value
     * @param \StructType\XFkType $devicePool
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDevicePool(\StructType\XFkType $devicePool = null)
    {
        $this->devicePool = $devicePool;
        return $this;
    }
    /**
     * Get deviceSecurityProfile value
     * @return \StructType\XFkType|null
     */
    public function getDeviceSecurityProfile()
    {
        return $this->deviceSecurityProfile;
    }
    /**
     * Set deviceSecurityProfile value
     * @param \StructType\XFkType $deviceSecurityProfile
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDeviceSecurityProfile(\StructType\XFkType $deviceSecurityProfile = null)
    {
        $this->deviceSecurityProfile = $deviceSecurityProfile;
        return $this;
    }
    /**
     * Get sipProfile value
     * @return \StructType\XFkType|null
     */
    public function getSipProfile()
    {
        return $this->sipProfile;
    }
    /**
     * Set sipProfile value
     * @param \StructType\XFkType $sipProfile
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSipProfile(\StructType\XFkType $sipProfile = null)
    {
        $this->sipProfile = $sipProfile;
        return $this;
    }
    /**
     * Get phoneButtonTemplate value
     * @return \StructType\XFkType|null
     */
    public function getPhoneButtonTemplate()
    {
        return $this->phoneButtonTemplate;
    }
    /**
     * Set phoneButtonTemplate value
     * @param \StructType\XFkType $phoneButtonTemplate
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setPhoneButtonTemplate(\StructType\XFkType $phoneButtonTemplate = null)
    {
        $this->phoneButtonTemplate = $phoneButtonTemplate;
        return $this;
    }
    /**
     * Get sipDialRules value
     * @return \StructType\XFkType|null
     */
    public function getSipDialRules()
    {
        return $this->sipDialRules;
    }
    /**
     * Set sipDialRules value
     * @param \StructType\XFkType $sipDialRules
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSipDialRules(\StructType\XFkType $sipDialRules = null)
    {
        $this->sipDialRules = $sipDialRules;
        return $this;
    }
    /**
     * Get callingSearchSpace value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpace()
    {
        return $this->callingSearchSpace;
    }
    /**
     * Set callingSearchSpace value
     * @param \StructType\XFkType $callingSearchSpace
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setCallingSearchSpace(\StructType\XFkType $callingSearchSpace = null)
    {
        $this->callingSearchSpace = $callingSearchSpace;
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForInboundCalls value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSSForInboundCalls()
    {
        return $this->callingPartyTransformationCSSForInboundCalls;
    }
    /**
     * Set callingPartyTransformationCSSForInboundCalls value
     * @param \StructType\XFkType $callingPartyTransformationCSSForInboundCalls
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setCallingPartyTransformationCSSForInboundCalls(\StructType\XFkType $callingPartyTransformationCSSForInboundCalls = null)
    {
        $this->callingPartyTransformationCSSForInboundCalls = $callingPartyTransformationCSSForInboundCalls;
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForOutboundCalls value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSSForOutboundCalls()
    {
        return $this->callingPartyTransformationCSSForOutboundCalls;
    }
    /**
     * Set callingPartyTransformationCSSForOutboundCalls value
     * @param \StructType\XFkType $callingPartyTransformationCSSForOutboundCalls
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setCallingPartyTransformationCSSForOutboundCalls(\StructType\XFkType $callingPartyTransformationCSSForOutboundCalls = null)
    {
        $this->callingPartyTransformationCSSForOutboundCalls = $callingPartyTransformationCSSForOutboundCalls;
        return $this;
    }
    /**
     * Get reroutingCallingSearchSpace value
     * @return \StructType\XFkType|null
     */
    public function getReroutingCallingSearchSpace()
    {
        return $this->reroutingCallingSearchSpace;
    }
    /**
     * Set reroutingCallingSearchSpace value
     * @param \StructType\XFkType $reroutingCallingSearchSpace
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setReroutingCallingSearchSpace(\StructType\XFkType $reroutingCallingSearchSpace = null)
    {
        $this->reroutingCallingSearchSpace = $reroutingCallingSearchSpace;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSubscribeCallingSearchSpaceName(\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCallingPartyTransformationCSSforInboundCalls, true), gettype($useDevicePoolCallingPartyTransformationCSSforInboundCalls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCallingPartyTransformationCSSforInboundCalls, true)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls = $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCallingPartyTransformationCSSforOutboundCalls, true), gettype($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCallingPartyTransformationCSSforOutboundCalls, true)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls = $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
        return $this;
    }
    /**
     * Get commonPhoneProfile value
     * @return \StructType\XFkType|null
     */
    public function getCommonPhoneProfile()
    {
        return $this->commonPhoneProfile;
    }
    /**
     * Set commonPhoneProfile value
     * @param \StructType\XFkType $commonPhoneProfile
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setCommonPhoneProfile(\StructType\XFkType $commonPhoneProfile = null)
    {
        $this->commonPhoneProfile = $commonPhoneProfile;
        return $this;
    }
    /**
     * Get commonDeviceConfiguration value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfiguration()
    {
        return $this->commonDeviceConfiguration;
    }
    /**
     * Set commonDeviceConfiguration value
     * @param \StructType\XFkType $commonDeviceConfiguration
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setCommonDeviceConfiguration(\StructType\XFkType $commonDeviceConfiguration = null)
    {
        $this->commonDeviceConfiguration = $commonDeviceConfiguration;
        return $this;
    }
    /**
     * Get softkeyTemplate value
     * @return \StructType\XFkType|null
     */
    public function getSoftkeyTemplate()
    {
        return $this->softkeyTemplate;
    }
    /**
     * Set softkeyTemplate value
     * @param \StructType\XFkType $softkeyTemplate
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSoftkeyTemplate(\StructType\XFkType $softkeyTemplate = null)
    {
        $this->softkeyTemplate = $softkeyTemplate;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \StructType\XFkType $featureControlPolicy
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setFeatureControlPolicy(\StructType\XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses \EnumType\XPhonePersonalization::valueIsValid()
     * @uses \EnumType\XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setPhonePersonalization($phonePersonalization = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPhonePersonalization', is_array($phonePersonalization) ? implode(', ', $phonePersonalization) : var_export($phonePersonalization, true), implode(', ', \EnumType\XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get mtpPreferredOriginatingCodec value
     * @return string|null
     */
    public function getMtpPreferredOriginatingCodec()
    {
        return $this->mtpPreferredOriginatingCodec;
    }
    /**
     * Set mtpPreferredOriginatingCodec value
     * @uses \EnumType\XSIPCodec::valueIsValid()
     * @uses \EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferredOriginatingCodec
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPCodec::valueIsValid($mtpPreferredOriginatingCodec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XSIPCodec', is_array($mtpPreferredOriginatingCodec) ? implode(', ', $mtpPreferredOriginatingCodec) : var_export($mtpPreferredOriginatingCodec, true), implode(', ', \EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferredOriginatingCodec = $mtpPreferredOriginatingCodec;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @uses \EnumType\XOutboundCallRollover::valueIsValid()
     * @uses \EnumType\XOutboundCallRollover::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outboundCallRollover
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setOutboundCallRollover($outboundCallRollover = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XOutboundCallRollover::valueIsValid($outboundCallRollover)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XOutboundCallRollover', is_array($outboundCallRollover) ? implode(', ', $outboundCallRollover) : var_export($outboundCallRollover, true), implode(', ', \EnumType\XOutboundCallRollover::getValidValues())), __LINE__);
        }
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get mediaTerminationPointRequired value
     * @return string|null
     */
    public function getMediaTerminationPointRequired()
    {
        return $this->mediaTerminationPointRequired;
    }
    /**
     * Set mediaTerminationPointRequired value
     * @param string $mediaTerminationPointRequired
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMediaTerminationPointRequired($mediaTerminationPointRequired = null)
    {
        // validation for constraint: string
        if (!is_null($mediaTerminationPointRequired) && !is_string($mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaTerminationPointRequired, true), gettype($mediaTerminationPointRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($mediaTerminationPointRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($mediaTerminationPointRequired, true)), __LINE__);
        }
        $this->mediaTerminationPointRequired = $mediaTerminationPointRequired;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unattendedPort, true), gettype($unattendedPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($unattendedPort, true)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requiredDtmfReception value
     * @return string|null
     */
    public function getRequiredDtmfReception()
    {
        return $this->requiredDtmfReception;
    }
    /**
     * Set requiredDtmfReception value
     * @param string $requiredDtmfReception
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRequiredDtmfReception($requiredDtmfReception = null)
    {
        // validation for constraint: string
        if (!is_null($requiredDtmfReception) && !is_string($requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requiredDtmfReception, true), gettype($requiredDtmfReception)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($requiredDtmfReception) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($requiredDtmfReception, true)), __LINE__);
        }
        $this->requiredDtmfReception = $requiredDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRfc2833Disabled($rfc2833Disabled = null)
    {
        // validation for constraint: string
        if (!is_null($rfc2833Disabled) && !is_string($rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfc2833Disabled, true), gettype($rfc2833Disabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($rfc2833Disabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($rfc2833Disabled, true)), __LINE__);
        }
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get speeddials value
     * @return \StructType\Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param \StructType\Speeddials $speeddials
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSpeeddials(\StructType\Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get protectedDevice value
     * @return string|null
     */
    public function getProtectedDevice()
    {
        return $this->protectedDevice;
    }
    /**
     * Set protectedDevice value
     * @param string $protectedDevice
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setProtectedDevice($protectedDevice = null)
    {
        // validation for constraint: string
        if (!is_null($protectedDevice) && !is_string($protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protectedDevice, true), gettype($protectedDevice)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($protectedDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($protectedDevice, true)), __LINE__);
        }
        $this->protectedDevice = $protectedDevice;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XAuthenticationMode', is_array($authenticationMode) ? implode(', ', $authenticationMode) : var_export($authenticationMode, true), implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationString, true), gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XKeySize', is_array($keySize) ? implode(', ', $keySize) : var_export($keySize, true), implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get servicesProvisioning value
     * @return string|null
     */
    public function getServicesProvisioning()
    {
        return $this->servicesProvisioning;
    }
    /**
     * Set servicesProvisioning value
     * @uses \EnumType\XPhoneServiceDisplay::valueIsValid()
     * @uses \EnumType\XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicesProvisioning
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setServicesProvisioning($servicesProvisioning = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneServiceDisplay::valueIsValid($servicesProvisioning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPhoneServiceDisplay', is_array($servicesProvisioning) ? implode(', ', $servicesProvisioning) : var_export($servicesProvisioning, true), implode(', ', \EnumType\XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->servicesProvisioning = $servicesProvisioning;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPacketCaptureMode', is_array($packetCaptureMode) ? implode(', ', $packetCaptureMode) : var_export($packetCaptureMode, true), implode(', ', \EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($packetCaptureDuration) ? implode(', ', $packetCaptureDuration) : var_export($packetCaptureDuration, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get secureShellUser value
     * @return string|null
     */
    public function getSecureShellUser()
    {
        return $this->secureShellUser;
    }
    /**
     * Set secureShellUser value
     * @param string $secureShellUser
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureShellUser($secureShellUser = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellUser) && !is_string($secureShellUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureShellUser, true), gettype($secureShellUser)), __LINE__);
        }
        $this->secureShellUser = $secureShellUser;
        return $this;
    }
    /**
     * Get secureShellPassword value
     * @return string|null
     */
    public function getSecureShellPassword()
    {
        return $this->secureShellPassword;
    }
    /**
     * Set secureShellPassword value
     * @param string $secureShellPassword
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureShellPassword($secureShellPassword = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellPassword) && !is_string($secureShellPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureShellPassword, true), gettype($secureShellPassword)), __LINE__);
        }
        $this->secureShellPassword = $secureShellPassword;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \EnumType\XUserLocale::valueIsValid()
     * @uses \EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XUserLocale', is_array($userLocale) ? implode(', ', $userLocale) : var_export($userLocale, true), implode(', ', \EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses \EnumType\XCountry::valueIsValid()
     * @uses \EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCountry', is_array($networkLocale) ? implode(', ', $networkLocale) : var_export($networkLocale, true), implode(', ', \EnumType\XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get mlppDomain value
     * @return \StructType\XFkType|null
     */
    public function getMlppDomain()
    {
        return $this->mlppDomain;
    }
    /**
     * Set mlppDomain value
     * @param \StructType\XFkType $mlppDomain
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMlppDomain(\StructType\XFkType $mlppDomain = null)
    {
        $this->mlppDomain = $mlppDomain;
        return $this;
    }
    /**
     * Get mlppIndication value
     * @return string|null
     */
    public function getMlppIndication()
    {
        return $this->mlppIndication;
    }
    /**
     * Set mlppIndication value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndication
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMlppIndication($mlppIndication = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($mlppIndication) ? implode(', ', $mlppIndication) : var_export($mlppIndication, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndication = $mlppIndication;
        return $this;
    }
    /**
     * Get mlppPreemption value
     * @return string|null
     */
    public function getMlppPreemption()
    {
        return $this->mlppPreemption;
    }
    /**
     * Set mlppPreemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppPreemption
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMlppPreemption($mlppPreemption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($mlppPreemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPreemption', is_array($mlppPreemption) ? implode(', ', $mlppPreemption) : var_export($mlppPreemption, true), implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->mlppPreemption = $mlppPreemption;
        return $this;
    }
    /**
     * Get doNotDisturb value
     * @return string|null
     */
    public function getDoNotDisturb()
    {
        return $this->doNotDisturb;
    }
    /**
     * Set doNotDisturb value
     * @param string $doNotDisturb
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDoNotDisturb($doNotDisturb = null)
    {
        // validation for constraint: string
        if (!is_null($doNotDisturb) && !is_string($doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doNotDisturb, true), gettype($doNotDisturb)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($doNotDisturb) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($doNotDisturb, true)), __LINE__);
        }
        $this->doNotDisturb = $doNotDisturb;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \EnumType\XDNDOption::valueIsValid()
     * @uses \EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDNDOption', is_array($dndOption) ? implode(', ', $dndOption) : var_export($dndOption, true), implode(', ', \EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndIncomingCallAlert value
     * @return string|null
     */
    public function getDndIncomingCallAlert()
    {
        return $this->dndIncomingCallAlert;
    }
    /**
     * Set dndIncomingCallAlert value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndIncomingCallAlert
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDndIncomingCallAlert($dndIncomingCallAlert = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($dndIncomingCallAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($dndIncomingCallAlert) ? implode(', ', $dndIncomingCallAlert) : var_export($dndIncomingCallAlert, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndIncomingCallAlert = $dndIncomingCallAlert;
        return $this;
    }
    /**
     * Get aarGroup value
     * @return \StructType\XFkType|null
     */
    public function getAarGroup()
    {
        return $this->aarGroup;
    }
    /**
     * Set aarGroup value
     * @param \StructType\XFkType $aarGroup
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAarGroup(\StructType\XFkType $aarGroup = null)
    {
        $this->aarGroup = $aarGroup;
        return $this;
    }
    /**
     * Get aarCallingSearchSpace value
     * @return \StructType\XFkType|null
     */
    public function getAarCallingSearchSpace()
    {
        return $this->aarCallingSearchSpace;
    }
    /**
     * Set aarCallingSearchSpace value
     * @param \StructType\XFkType $aarCallingSearchSpace
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAarCallingSearchSpace(\StructType\XFkType $aarCallingSearchSpace = null)
    {
        $this->aarCallingSearchSpace = $aarCallingSearchSpace;
        return $this;
    }
    /**
     * Get blfPresenceGroup value
     * @return \StructType\XFkType|null
     */
    public function getBlfPresenceGroup()
    {
        return $this->blfPresenceGroup;
    }
    /**
     * Set blfPresenceGroup value
     * @param \StructType\XFkType $blfPresenceGroup
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setBlfPresenceGroup(\StructType\XFkType $blfPresenceGroup = null)
    {
        $this->blfPresenceGroup = $blfPresenceGroup;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneBusy value
     * @return string|null
     */
    public function getBlfAudibleAlertSettingPhoneBusy()
    {
        return $this->blfAudibleAlertSettingPhoneBusy;
    }
    /**
     * Set blfAudibleAlertSettingPhoneBusy value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($blfAudibleAlertSettingPhoneBusy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($blfAudibleAlertSettingPhoneBusy) ? implode(', ', $blfAudibleAlertSettingPhoneBusy) : var_export($blfAudibleAlertSettingPhoneBusy, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneBusy = $blfAudibleAlertSettingPhoneBusy;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneIdle value
     * @return string|null
     */
    public function getBlfAudibleAlertSettingPhoneIdle()
    {
        return $this->blfAudibleAlertSettingPhoneIdle;
    }
    /**
     * Set blfAudibleAlertSettingPhoneIdle value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($blfAudibleAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($blfAudibleAlertSettingPhoneIdle) ? implode(', ', $blfAudibleAlertSettingPhoneIdle) : var_export($blfAudibleAlertSettingPhoneIdle, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneIdle = $blfAudibleAlertSettingPhoneIdle;
        return $this;
    }
    /**
     * Get userHoldMohAudioSource value
     * @return string|null
     */
    public function getUserHoldMohAudioSource()
    {
        return $this->userHoldMohAudioSource;
    }
    /**
     * Set userHoldMohAudioSource value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSource
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setUserHoldMohAudioSource($userHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($userHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($userHoldMohAudioSource) ? implode(', ', $userHoldMohAudioSource) : var_export($userHoldMohAudioSource, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSource = $userHoldMohAudioSource;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSource value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSource()
    {
        return $this->networkHoldMohAudioSource;
    }
    /**
     * Set networkHoldMohAudioSource value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSource
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setNetworkHoldMohAudioSource($networkHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($networkHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($networkHoldMohAudioSource) ? implode(', ', $networkHoldMohAudioSource) : var_export($networkHoldMohAudioSource, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSource = $networkHoldMohAudioSource;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\XFkType|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\XFkType $location
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setLocation(\StructType\XFkType $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get geoLocation value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocation()
    {
        return $this->geoLocation;
    }
    /**
     * Set geoLocation value
     * @param \StructType\XFkType $geoLocation
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setGeoLocation(\StructType\XFkType $geoLocation = null)
    {
        $this->geoLocation = $geoLocation;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDeviceMobilityMode($deviceMobilityMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($deviceMobilityMode) ? implode(', ', $deviceMobilityMode) : var_export($deviceMobilityMode, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get mediaResourceGroupList value
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceGroupList()
    {
        return $this->mediaResourceGroupList;
    }
    /**
     * Set mediaResourceGroupList value
     * @param \StructType\XFkType $mediaResourceGroupList
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMediaResourceGroupList(\StructType\XFkType $mediaResourceGroupList = null)
    {
        $this->mediaResourceGroupList = $mediaResourceGroupList;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteDevice, true), gettype($remoteDevice)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($remoteDevice, true)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotlineDevice, true), gettype($hotlineDevice)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($hotlineDevice, true)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retryVideoCallAsAudio, true), gettype($retryVideoCallAsAudio)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = null)
    {
        // validation for constraint: string
        if (!is_null($requireOffPremiseLocation) && !is_string($requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requireOffPremiseLocation, true), gettype($requireOffPremiseLocation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($requireOffPremiseLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($requireOffPremiseLocation, true)), __LINE__);
        }
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get ownerUserId value
     * @return \StructType\XFkType|null
     */
    public function getOwnerUserId()
    {
        return $this->ownerUserId;
    }
    /**
     * Set ownerUserId value
     * @param \StructType\XFkType $ownerUserId
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setOwnerUserId(\StructType\XFkType $ownerUserId = null)
    {
        $this->ownerUserId = $ownerUserId;
        return $this;
    }
    /**
     * Get mobilityUserId value
     * @return \StructType\XFkType|null
     */
    public function getMobilityUserId()
    {
        return $this->mobilityUserId;
    }
    /**
     * Set mobilityUserId value
     * @param \StructType\XFkType $mobilityUserId
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMobilityUserId(\StructType\XFkType $mobilityUserId = null)
    {
        $this->mobilityUserId = $mobilityUserId;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($joinAcrossLines) ? implode(', ', $joinAcrossLines) : var_export($joinAcrossLines, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($alwaysUsePrimeLine) ? implode(', ', $alwaysUsePrimeLine) : var_export($alwaysUsePrimeLine, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($alwaysUsePrimeLineForVoiceMessage) ? implode(', ', $alwaysUsePrimeLineForVoiceMessage) : var_export($alwaysUsePrimeLineForVoiceMessage, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \EnumType\XBarge::valueIsValid()
     * @uses \EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XBarge', is_array($singleButtonBarge) ? implode(', ', $singleButtonBarge) : var_export($singleButtonBarge, true), implode(', ', \EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get builtInBridge value
     * @return string|null
     */
    public function getBuiltInBridge()
    {
        return $this->builtInBridge;
    }
    /**
     * Set builtInBridge value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $builtInBridge
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setBuiltInBridge($builtInBridge = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($builtInBridge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($builtInBridge) ? implode(', ', $builtInBridge) : var_export($builtInBridge, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->builtInBridge = $builtInBridge;
        return $this;
    }
    /**
     * Get allowControlOfDeviceFromCti value
     * @return string|null
     */
    public function getAllowControlOfDeviceFromCti()
    {
        return $this->allowControlOfDeviceFromCti;
    }
    /**
     * Set allowControlOfDeviceFromCti value
     * @param string $allowControlOfDeviceFromCti
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti = null)
    {
        // validation for constraint: string
        if (!is_null($allowControlOfDeviceFromCti) && !is_string($allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowControlOfDeviceFromCti, true), gettype($allowControlOfDeviceFromCti)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowControlOfDeviceFromCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowControlOfDeviceFromCti, true)), __LINE__);
        }
        $this->allowControlOfDeviceFromCti = $allowControlOfDeviceFromCti;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ignorePresentationIndicators, true), gettype($ignorePresentationIndicators)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableExtensionMobility, true), gettype($enableExtensionMobility)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableExtensionMobility, true)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get recordingOptions value
     * @return string|null
     */
    public function getRecordingOptions()
    {
        return $this->recordingOptions;
    }
    /**
     * Set recordingOptions value
     * @uses \EnumType\XRecordingFlag::valueIsValid()
     * @uses \EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingOptions
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRecordingOptions($recordingOptions = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRecordingFlag::valueIsValid($recordingOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRecordingFlag', is_array($recordingOptions) ? implode(', ', $recordingOptions) : var_export($recordingOptions, true), implode(', ', \EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingOptions = $recordingOptions;
        return $this;
    }
    /**
     * Get privacy value
     * @return string|null
     */
    public function getPrivacy()
    {
        return $this->privacy;
    }
    /**
     * Set privacy value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $privacy
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setPrivacy($privacy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($privacy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($privacy) ? implode(', ', $privacy) : var_export($privacy, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->privacy = $privacy;
        return $this;
    }
    /**
     * Get loggedIntoHuntGroup value
     * @return string|null
     */
    public function getLoggedIntoHuntGroup()
    {
        return $this->loggedIntoHuntGroup;
    }
    /**
     * Set loggedIntoHuntGroup value
     * @param string $loggedIntoHuntGroup
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setLoggedIntoHuntGroup($loggedIntoHuntGroup = null)
    {
        // validation for constraint: string
        if (!is_null($loggedIntoHuntGroup) && !is_string($loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loggedIntoHuntGroup, true), gettype($loggedIntoHuntGroup)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($loggedIntoHuntGroup) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($loggedIntoHuntGroup, true)), __LINE__);
        }
        $this->loggedIntoHuntGroup = $loggedIntoHuntGroup;
        return $this;
    }
    /**
     * Get proxyServer value
     * @return string|null
     */
    public function getProxyServer()
    {
        return $this->proxyServer;
    }
    /**
     * Set proxyServer value
     * @param string $proxyServer
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setProxyServer($proxyServer = null)
    {
        // validation for constraint: string
        if (!is_null($proxyServer) && !is_string($proxyServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proxyServer, true), gettype($proxyServer)), __LINE__);
        }
        $this->proxyServer = $proxyServer;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setServicesUrl($servicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($servicesUrl) && !is_string($servicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicesUrl, true), gettype($servicesUrl)), __LINE__);
        }
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get idle value
     * @return string|null
     */
    public function getIdle()
    {
        return $this->idle;
    }
    /**
     * Set idle value
     * @param string $idle
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setIdle($idle = null)
    {
        // validation for constraint: string
        if (!is_null($idle) && !is_string($idle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idle, true), gettype($idle)), __LINE__);
        }
        $this->idle = $idle;
        return $this;
    }
    /**
     * Get idleTimer value
     * @return string|null
     */
    public function getIdleTimer()
    {
        return $this->idleTimer;
    }
    /**
     * Set idleTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idleTimer
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setIdleTimer($idleTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($idleTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($idleTimer) ? implode(', ', $idleTimer) : var_export($idleTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->idleTimer = $idleTimer;
        return $this;
    }
    /**
     * Get secureDirUrl value
     * @return string|null
     */
    public function getSecureDirUrl()
    {
        return $this->secureDirUrl;
    }
    /**
     * Set secureDirUrl value
     * @param string $secureDirUrl
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureDirUrl($secureDirUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureDirUrl) && !is_string($secureDirUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureDirUrl, true), gettype($secureDirUrl)), __LINE__);
        }
        $this->secureDirUrl = $secureDirUrl;
        return $this;
    }
    /**
     * Get messages value
     * @return string|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param string $messages
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMessages($messages = null)
    {
        // validation for constraint: string
        if (!is_null($messages) && !is_string($messages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messages, true), gettype($messages)), __LINE__);
        }
        $this->messages = $messages;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureIdleUrl) && !is_string($secureIdleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureIdleUrl, true), gettype($secureIdleUrl)), __LINE__);
        }
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get authenticationServer value
     * @return string|null
     */
    public function getAuthenticationServer()
    {
        return $this->authenticationServer;
    }
    /**
     * Set authenticationServer value
     * @param string $authenticationServer
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAuthenticationServer($authenticationServer = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationServer) && !is_string($authenticationServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationServer, true), gettype($authenticationServer)), __LINE__);
        }
        $this->authenticationServer = $authenticationServer;
        return $this;
    }
    /**
     * Get directory value
     * @return string|null
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param string $directory
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDirectory($directory = null)
    {
        // validation for constraint: string
        if (!is_null($directory) && !is_string($directory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directory, true), gettype($directory)), __LINE__);
        }
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServicesUrl) && !is_string($secureServicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureServicesUrl, true), gettype($secureServicesUrl)), __LINE__);
        }
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($information, true), gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Get secureMessagesUrl value
     * @return string|null
     */
    public function getSecureMessagesUrl()
    {
        return $this->secureMessagesUrl;
    }
    /**
     * Set secureMessagesUrl value
     * @param string $secureMessagesUrl
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureMessagesUrl($secureMessagesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureMessagesUrl) && !is_string($secureMessagesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureMessagesUrl, true), gettype($secureMessagesUrl)), __LINE__);
        }
        $this->secureMessagesUrl = $secureMessagesUrl;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureInformationUrl) && !is_string($secureInformationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureInformationUrl, true), gettype($secureInformationUrl)), __LINE__);
        }
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureAuthenticationUrl) && !is_string($secureAuthenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secureAuthenticationUrl, true), gettype($secureAuthenticationUrl)), __LINE__);
        }
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get externalPhoneNumber value
     * @return string|null
     */
    public function getExternalPhoneNumber()
    {
        return $this->externalPhoneNumber;
    }
    /**
     * Set externalPhoneNumber value
     * @param string $externalPhoneNumber
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setExternalPhoneNumber($externalPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalPhoneNumber) && !is_string($externalPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalPhoneNumber, true), gettype($externalPhoneNumber)), __LINE__);
        }
        $this->externalPhoneNumber = $externalPhoneNumber;
        return $this;
    }
    /**
     * Get audibleMsgWaitingicatorPolicy value
     * @return string|null
     */
    public function getAudibleMsgWaitingicatorPolicy()
    {
        return $this->audibleMsgWaitingicatorPolicy;
    }
    /**
     * Set audibleMsgWaitingicatorPolicy value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMsgWaitingicatorPolicy
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($audibleMsgWaitingicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($audibleMsgWaitingicatorPolicy) ? implode(', ', $audibleMsgWaitingicatorPolicy) : var_export($audibleMsgWaitingicatorPolicy, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMsgWaitingicatorPolicy = $audibleMsgWaitingicatorPolicy;
        return $this;
    }
    /**
     * Get logMissedCalls value
     * @return string|null
     */
    public function getLogMissedCalls()
    {
        return $this->logMissedCalls;
    }
    /**
     * Set logMissedCalls value
     * @param string $logMissedCalls
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setLogMissedCalls($logMissedCalls = null)
    {
        // validation for constraint: string
        if (!is_null($logMissedCalls) && !is_string($logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logMissedCalls, true), gettype($logMissedCalls)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($logMissedCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($logMissedCalls, true)), __LINE__);
        }
        $this->logMissedCalls = $logMissedCalls;
        return $this;
    }
    /**
     * Get visualMsgWaitingIndicatorPolicy value
     * @return string|null
     */
    public function getVisualMsgWaitingIndicatorPolicy()
    {
        return $this->visualMsgWaitingIndicatorPolicy;
    }
    /**
     * Set visualMsgWaitingIndicatorPolicy value
     * @uses \EnumType\XMWLPolicy::valueIsValid()
     * @uses \EnumType\XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $visualMsgWaitingIndicatorPolicy
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMWLPolicy::valueIsValid($visualMsgWaitingIndicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XMWLPolicy', is_array($visualMsgWaitingIndicatorPolicy) ? implode(', ', $visualMsgWaitingIndicatorPolicy) : var_export($visualMsgWaitingIndicatorPolicy, true), implode(', ', \EnumType\XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->visualMsgWaitingIndicatorPolicy = $visualMsgWaitingIndicatorPolicy;
        return $this;
    }
    /**
     * Get lineLabel value
     * @return string|null
     */
    public function getLineLabel()
    {
        return $this->lineLabel;
    }
    /**
     * Set lineLabel value
     * @param string $lineLabel
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setLineLabel($lineLabel = null)
    {
        // validation for constraint: string
        if (!is_null($lineLabel) && !is_string($lineLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineLabel, true), gettype($lineLabel)), __LINE__);
        }
        $this->lineLabel = $lineLabel;
        return $this;
    }
    /**
     * Get displayCallerId value
     * @return string|null
     */
    public function getDisplayCallerId()
    {
        return $this->displayCallerId;
    }
    /**
     * Set displayCallerId value
     * @param string $displayCallerId
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDisplayCallerId($displayCallerId = null)
    {
        // validation for constraint: string
        if (!is_null($displayCallerId) && !is_string($displayCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayCallerId, true), gettype($displayCallerId)), __LINE__);
        }
        $this->displayCallerId = $displayCallerId;
        return $this;
    }
    /**
     * Get MaxNumberOfCalls value
     * @return string|null
     */
    public function getMaxNumberOfCalls()
    {
        return $this->MaxNumberOfCalls;
    }
    /**
     * Set MaxNumberOfCalls value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumberOfCalls
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMaxNumberOfCalls($maxNumberOfCalls = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxNumberOfCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($maxNumberOfCalls) ? implode(', ', $maxNumberOfCalls) : var_export($maxNumberOfCalls, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->MaxNumberOfCalls = $maxNumberOfCalls;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneIdle value
     * @return string|null
     */
    public function getRingSettingWhenPhoneIdle()
    {
        return $this->ringSettingWhenPhoneIdle;
    }
    /**
     * Set ringSettingWhenPhoneIdle value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneIdle
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($ringSettingWhenPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($ringSettingWhenPhoneIdle) ? implode(', ', $ringSettingWhenPhoneIdle) : var_export($ringSettingWhenPhoneIdle, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingWhenPhoneIdle = $ringSettingWhenPhoneIdle;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($busyTrigger) ? implode(', ', $busyTrigger) : var_export($busyTrigger, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneInUse value
     * @return string|null
     */
    public function getRingSettingWhenPhoneInUse()
    {
        return $this->ringSettingWhenPhoneInUse;
    }
    /**
     * Set ringSettingWhenPhoneInUse value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneInUse
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($ringSettingWhenPhoneInUse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($ringSettingWhenPhoneInUse) ? implode(', ', $ringSettingWhenPhoneInUse) : var_export($ringSettingWhenPhoneInUse, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingWhenPhoneInUse = $ringSettingWhenPhoneInUse;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return \StructType\XFkType|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param \StructType\XFkType $directoryNumber
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setDirectoryNumber(\StructType\XFkType $directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get recordingProfile value
     * @return \StructType\XFkType|null
     */
    public function getRecordingProfile()
    {
        return $this->recordingProfile;
    }
    /**
     * Set recordingProfile value
     * @param \StructType\XFkType $recordingProfile
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setRecordingProfile(\StructType\XFkType $recordingProfile = null)
    {
        $this->recordingProfile = $recordingProfile;
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneActive value
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneActive()
    {
        return $this->callPickupGroupAudioAlertSettingPhoneActive;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneActive value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($callPickupGroupAudioAlertSettingPhoneActive) ? implode(', ', $callPickupGroupAudioAlertSettingPhoneActive) : var_export($callPickupGroupAudioAlertSettingPhoneActive, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->callPickupGroupAudioAlertSettingPhoneActive = $callPickupGroupAudioAlertSettingPhoneActive;
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneIdle value
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneIdle()
    {
        return $this->callPickupGroupAudioAlertSettingPhoneIdle;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneIdle value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XRingSetting', is_array($callPickupGroupAudioAlertSettingPhoneIdle) ? implode(', ', $callPickupGroupAudioAlertSettingPhoneIdle) : var_export($callPickupGroupAudioAlertSettingPhoneIdle, true), implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->callPickupGroupAudioAlertSettingPhoneIdle = $callPickupGroupAudioAlertSettingPhoneIdle;
        return $this;
    }
    /**
     * Get monitoringCallingSearchSpace value
     * @return \StructType\XFkType|null
     */
    public function getMonitoringCallingSearchSpace()
    {
        return $this->monitoringCallingSearchSpace;
    }
    /**
     * Set monitoringCallingSearchSpace value
     * @param \StructType\XFkType $monitoringCallingSearchSpace
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setMonitoringCallingSearchSpace(\StructType\XFkType $monitoringCallingSearchSpace = null)
    {
        $this->monitoringCallingSearchSpace = $monitoringCallingSearchSpace;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RUniversalDeviceTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
