<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTODAccessMember StructType
 * @subpackage Structs
 */
class RTODAccessMember extends AbstractStructBase
{
    /**
     * The timeScheduleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $timeScheduleName;
    /**
     * The accessListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $accessListName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTODAccessMember
     * @uses RTODAccessMember::setTimeScheduleName()
     * @uses RTODAccessMember::setAccessListName()
     * @uses RTODAccessMember::setUuid()
     * @param \StructType\XFkType $timeScheduleName
     * @param \StructType\XFkType $accessListName
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $timeScheduleName = null, \StructType\XFkType $accessListName = null, $uuid = null)
    {
        $this
            ->setTimeScheduleName($timeScheduleName)
            ->setAccessListName($accessListName)
            ->setUuid($uuid);
    }
    /**
     * Get timeScheduleName value
     * @return \StructType\XFkType|null
     */
    public function getTimeScheduleName()
    {
        return $this->timeScheduleName;
    }
    /**
     * Set timeScheduleName value
     * @param \StructType\XFkType $timeScheduleName
     * @return \StructType\RTODAccessMember
     */
    public function setTimeScheduleName(\StructType\XFkType $timeScheduleName = null)
    {
        $this->timeScheduleName = $timeScheduleName;
        return $this;
    }
    /**
     * Get accessListName value
     * @return \StructType\XFkType|null
     */
    public function getAccessListName()
    {
        return $this->accessListName;
    }
    /**
     * Set accessListName value
     * @param \StructType\XFkType $accessListName
     * @return \StructType\RTODAccessMember
     */
    public function setAccessListName(\StructType\XFkType $accessListName = null)
    {
        $this->accessListName = $accessListName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RTODAccessMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
