<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RT1Port StructType
 * @subpackage Structs
 */
class RT1Port extends AbstractStructBase
{
    /**
     * The portNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $portNumber;
    /**
     * The attendantDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $attendantDn;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callerIdEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callerIdEnable;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The digitSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitSending;
    /**
     * The expectedDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $expectedDigits;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The prefixDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDn;
    /**
     * The presentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presentationBit;
    /**
     * The silenceSuppressionThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $silenceSuppressionThreshold;
    /**
     * The startDialProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startDialProtocol;
    /**
     * The trunk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunk;
    /**
     * The trunkDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkDirection;
    /**
     * The trunkLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkLevel;
    /**
     * The trunkPadRx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadRx;
    /**
     * The trunkPadTx
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkPadTx;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: Arbitrary XML defined by 3rd party vendors.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The callerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerId;
    /**
     * The endpointId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endpointId;
    /**
     * The timer1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer1;
    /**
     * The timer2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer2;
    /**
     * The timer3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer3;
    /**
     * The timer4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer4;
    /**
     * The timer5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer5;
    /**
     * The timer6
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer6;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RT1Port
     * @uses RT1Port::setPortNumber()
     * @uses RT1Port::setAttendantDn()
     * @uses RT1Port::setUnattendedPort()
     * @uses RT1Port::setCallerIdDn()
     * @uses RT1Port::setCallerIdEnable()
     * @uses RT1Port::setCallingPartySelection()
     * @uses RT1Port::setDigitSending()
     * @uses RT1Port::setExpectedDigits()
     * @uses RT1Port::setSigDigits()
     * @uses RT1Port::setPrefixDn()
     * @uses RT1Port::setPresentationBit()
     * @uses RT1Port::setSilenceSuppressionThreshold()
     * @uses RT1Port::setStartDialProtocol()
     * @uses RT1Port::setTrunk()
     * @uses RT1Port::setTrunkDirection()
     * @uses RT1Port::setTrunkLevel()
     * @uses RT1Port::setTrunkPadRx()
     * @uses RT1Port::setTrunkPadTx()
     * @uses RT1Port::setVendorConfig()
     * @uses RT1Port::setCallerId()
     * @uses RT1Port::setEndpointId()
     * @uses RT1Port::setTimer1()
     * @uses RT1Port::setTimer2()
     * @uses RT1Port::setTimer3()
     * @uses RT1Port::setTimer4()
     * @uses RT1Port::setTimer5()
     * @uses RT1Port::setTimer6()
     * @uses RT1Port::setUuid()
     * @param string $portNumber
     * @param string $attendantDn
     * @param string $unattendedPort
     * @param string $callerIdDn
     * @param string $callerIdEnable
     * @param string $callingPartySelection
     * @param string $digitSending
     * @param string $expectedDigits
     * @param \StructType\SigDigits $sigDigits
     * @param string $prefixDn
     * @param string $presentationBit
     * @param string $silenceSuppressionThreshold
     * @param string $startDialProtocol
     * @param string $trunk
     * @param string $trunkDirection
     * @param string $trunkLevel
     * @param string $trunkPadRx
     * @param string $trunkPadTx
     * @param \StructType\XVendorConfig $vendorConfig
     * @param string $callerId
     * @param string $endpointId
     * @param string $timer1
     * @param string $timer2
     * @param string $timer3
     * @param string $timer4
     * @param string $timer5
     * @param string $timer6
     * @param string $uuid
     */
    public function __construct($portNumber = null, $attendantDn = null, $unattendedPort = null, $callerIdDn = null, $callerIdEnable = null, $callingPartySelection = null, $digitSending = null, $expectedDigits = null, \StructType\SigDigits $sigDigits = null, $prefixDn = null, $presentationBit = null, $silenceSuppressionThreshold = null, $startDialProtocol = null, $trunk = null, $trunkDirection = null, $trunkLevel = null, $trunkPadRx = null, $trunkPadTx = null, \StructType\XVendorConfig $vendorConfig = null, $callerId = null, $endpointId = null, $timer1 = null, $timer2 = null, $timer3 = null, $timer4 = null, $timer5 = null, $timer6 = null, $uuid = null)
    {
        $this
            ->setPortNumber($portNumber)
            ->setAttendantDn($attendantDn)
            ->setUnattendedPort($unattendedPort)
            ->setCallerIdDn($callerIdDn)
            ->setCallerIdEnable($callerIdEnable)
            ->setCallingPartySelection($callingPartySelection)
            ->setDigitSending($digitSending)
            ->setExpectedDigits($expectedDigits)
            ->setSigDigits($sigDigits)
            ->setPrefixDn($prefixDn)
            ->setPresentationBit($presentationBit)
            ->setSilenceSuppressionThreshold($silenceSuppressionThreshold)
            ->setStartDialProtocol($startDialProtocol)
            ->setTrunk($trunk)
            ->setTrunkDirection($trunkDirection)
            ->setTrunkLevel($trunkLevel)
            ->setTrunkPadRx($trunkPadRx)
            ->setTrunkPadTx($trunkPadTx)
            ->setVendorConfig($vendorConfig)
            ->setCallerId($callerId)
            ->setEndpointId($endpointId)
            ->setTimer1($timer1)
            ->setTimer2($timer2)
            ->setTimer3($timer3)
            ->setTimer4($timer4)
            ->setTimer5($timer5)
            ->setTimer6($timer6)
            ->setUuid($uuid);
    }
    /**
     * Get portNumber value
     * @return string|null
     */
    public function getPortNumber()
    {
        return $this->portNumber;
    }
    /**
     * Set portNumber value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $portNumber
     * @return \StructType\RT1Port
     */
    public function setPortNumber($portNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($portNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($portNumber) ? implode(', ', $portNumber) : var_export($portNumber, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->portNumber = $portNumber;
        return $this;
    }
    /**
     * Get attendantDn value
     * @return string|null
     */
    public function getAttendantDn()
    {
        return $this->attendantDn;
    }
    /**
     * Set attendantDn value
     * @param string $attendantDn
     * @return \StructType\RT1Port
     */
    public function setAttendantDn($attendantDn = null)
    {
        // validation for constraint: string
        if (!is_null($attendantDn) && !is_string($attendantDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attendantDn, true), gettype($attendantDn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($attendantDn) && mb_strlen($attendantDn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($attendantDn)), __LINE__);
        }
        $this->attendantDn = $attendantDn;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \StructType\RT1Port
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unattendedPort, true), gettype($unattendedPort)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($unattendedPort, true)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \StructType\RT1Port
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdDn, true), gettype($callerIdDn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($callerIdDn) && mb_strlen($callerIdDn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callerIdEnable value
     * @return string|null
     */
    public function getCallerIdEnable()
    {
        return $this->callerIdEnable;
    }
    /**
     * Set callerIdEnable value
     * @param string $callerIdEnable
     * @return \StructType\RT1Port
     */
    public function setCallerIdEnable($callerIdEnable = null)
    {
        // validation for constraint: string
        if (!is_null($callerIdEnable) && !is_string($callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callerIdEnable, true), gettype($callerIdEnable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($callerIdEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($callerIdEnable, true)), __LINE__);
        }
        $this->callerIdEnable = $callerIdEnable;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \EnumType\XCallingPartySelection::valueIsValid()
     * @uses \EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \StructType\RT1Port
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCallingPartySelection', is_array($callingPartySelection) ? implode(', ', $callingPartySelection) : var_export($callingPartySelection, true), implode(', ', \EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string|null
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses \EnumType\XDigitSending::valueIsValid()
     * @uses \EnumType\XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return \StructType\RT1Port
     */
    public function setDigitSending($digitSending = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDigitSending', is_array($digitSending) ? implode(', ', $digitSending) : var_export($digitSending, true), implode(', ', \EnumType\XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get expectedDigits value
     * @return string|null
     */
    public function getExpectedDigits()
    {
        return $this->expectedDigits;
    }
    /**
     * Set expectedDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedDigits
     * @return \StructType\RT1Port
     */
    public function setExpectedDigits($expectedDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($expectedDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($expectedDigits) ? implode(', ', $expectedDigits) : var_export($expectedDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->expectedDigits = $expectedDigits;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \StructType\SigDigits $sigDigits
     * @return \StructType\RT1Port
     */
    public function setSigDigits(\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get prefixDn value
     * @return string|null
     */
    public function getPrefixDn()
    {
        return $this->prefixDn;
    }
    /**
     * Set prefixDn value
     * @param string $prefixDn
     * @return \StructType\RT1Port
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefixDn, true), gettype($prefixDn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($prefixDn) && mb_strlen($prefixDn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($prefixDn)), __LINE__);
        }
        $this->prefixDn = $prefixDn;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string|null
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $presentationBit
     * @return \StructType\RT1Port
     */
    public function setPresentationBit($presentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($presentationBit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XPresentationBit', is_array($presentationBit) ? implode(', ', $presentationBit) : var_export($presentationBit, true), implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get silenceSuppressionThreshold value
     * @return string|null
     */
    public function getSilenceSuppressionThreshold()
    {
        return $this->silenceSuppressionThreshold;
    }
    /**
     * Set silenceSuppressionThreshold value
     * @uses \EnumType\XSilenceSuppressionThreshold::valueIsValid()
     * @uses \EnumType\XSilenceSuppressionThreshold::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $silenceSuppressionThreshold
     * @return \StructType\RT1Port
     */
    public function setSilenceSuppressionThreshold($silenceSuppressionThreshold = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSilenceSuppressionThreshold::valueIsValid($silenceSuppressionThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XSilenceSuppressionThreshold', is_array($silenceSuppressionThreshold) ? implode(', ', $silenceSuppressionThreshold) : var_export($silenceSuppressionThreshold, true), implode(', ', \EnumType\XSilenceSuppressionThreshold::getValidValues())), __LINE__);
        }
        $this->silenceSuppressionThreshold = $silenceSuppressionThreshold;
        return $this;
    }
    /**
     * Get startDialProtocol value
     * @return string|null
     */
    public function getStartDialProtocol()
    {
        return $this->startDialProtocol;
    }
    /**
     * Set startDialProtocol value
     * @uses \EnumType\XStartDialProtocol::valueIsValid()
     * @uses \EnumType\XStartDialProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDialProtocol
     * @return \StructType\RT1Port
     */
    public function setStartDialProtocol($startDialProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStartDialProtocol::valueIsValid($startDialProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStartDialProtocol', is_array($startDialProtocol) ? implode(', ', $startDialProtocol) : var_export($startDialProtocol, true), implode(', ', \EnumType\XStartDialProtocol::getValidValues())), __LINE__);
        }
        $this->startDialProtocol = $startDialProtocol;
        return $this;
    }
    /**
     * Get trunk value
     * @return string|null
     */
    public function getTrunk()
    {
        return $this->trunk;
    }
    /**
     * Set trunk value
     * @uses \EnumType\XTrunk::valueIsValid()
     * @uses \EnumType\XTrunk::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunk
     * @return \StructType\RT1Port
     */
    public function setTrunk($trunk = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunk::valueIsValid($trunk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTrunk', is_array($trunk) ? implode(', ', $trunk) : var_export($trunk, true), implode(', ', \EnumType\XTrunk::getValidValues())), __LINE__);
        }
        $this->trunk = $trunk;
        return $this;
    }
    /**
     * Get trunkDirection value
     * @return string|null
     */
    public function getTrunkDirection()
    {
        return $this->trunkDirection;
    }
    /**
     * Set trunkDirection value
     * @uses \EnumType\XTrunkDirection::valueIsValid()
     * @uses \EnumType\XTrunkDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkDirection
     * @return \StructType\RT1Port
     */
    public function setTrunkDirection($trunkDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkDirection::valueIsValid($trunkDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTrunkDirection', is_array($trunkDirection) ? implode(', ', $trunkDirection) : var_export($trunkDirection, true), implode(', ', \EnumType\XTrunkDirection::getValidValues())), __LINE__);
        }
        $this->trunkDirection = $trunkDirection;
        return $this;
    }
    /**
     * Get trunkLevel value
     * @return string|null
     */
    public function getTrunkLevel()
    {
        return $this->trunkLevel;
    }
    /**
     * Set trunkLevel value
     * @uses \EnumType\XTrunkLevel::valueIsValid()
     * @uses \EnumType\XTrunkLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkLevel
     * @return \StructType\RT1Port
     */
    public function setTrunkLevel($trunkLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkLevel::valueIsValid($trunkLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTrunkLevel', is_array($trunkLevel) ? implode(', ', $trunkLevel) : var_export($trunkLevel, true), implode(', ', \EnumType\XTrunkLevel::getValidValues())), __LINE__);
        }
        $this->trunkLevel = $trunkLevel;
        return $this;
    }
    /**
     * Get trunkPadRx value
     * @return string|null
     */
    public function getTrunkPadRx()
    {
        return $this->trunkPadRx;
    }
    /**
     * Set trunkPadRx value
     * @uses \EnumType\XTrunkPad::valueIsValid()
     * @uses \EnumType\XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadRx
     * @return \StructType\RT1Port
     */
    public function setTrunkPadRx($trunkPadRx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkPad::valueIsValid($trunkPadRx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTrunkPad', is_array($trunkPadRx) ? implode(', ', $trunkPadRx) : var_export($trunkPadRx, true), implode(', ', \EnumType\XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadRx = $trunkPadRx;
        return $this;
    }
    /**
     * Get trunkPadTx value
     * @return string|null
     */
    public function getTrunkPadTx()
    {
        return $this->trunkPadTx;
    }
    /**
     * Set trunkPadTx value
     * @uses \EnumType\XTrunkPad::valueIsValid()
     * @uses \EnumType\XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadTx
     * @return \StructType\RT1Port
     */
    public function setTrunkPadTx($trunkPadTx = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkPad::valueIsValid($trunkPadTx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTrunkPad', is_array($trunkPadTx) ? implode(', ', $trunkPadTx) : var_export($trunkPadTx, true), implode(', ', \EnumType\XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadTx = $trunkPadTx;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \StructType\XVendorConfig $vendorConfig
     * @return \StructType\RT1Port
     */
    public function setVendorConfig(\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get callerId value
     * @return string|null
     */
    public function getCallerId()
    {
        return $this->callerId;
    }
    /**
     * Set callerId value
     * @uses \EnumType\XCallerID::valueIsValid()
     * @uses \EnumType\XCallerID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerId
     * @return \StructType\RT1Port
     */
    public function setCallerId($callerId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallerID::valueIsValid($callerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCallerID', is_array($callerId) ? implode(', ', $callerId) : var_export($callerId, true), implode(', ', \EnumType\XCallerID::getValidValues())), __LINE__);
        }
        $this->callerId = $callerId;
        return $this;
    }
    /**
     * Get endpointId value
     * @return string|null
     */
    public function getEndpointId()
    {
        return $this->endpointId;
    }
    /**
     * Set endpointId value
     * @param string $endpointId
     * @return \StructType\RT1Port
     */
    public function setEndpointId($endpointId = null)
    {
        // validation for constraint: string
        if (!is_null($endpointId) && !is_string($endpointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endpointId, true), gettype($endpointId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($endpointId) && mb_strlen($endpointId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($endpointId)), __LINE__);
        }
        $this->endpointId = $endpointId;
        return $this;
    }
    /**
     * Get timer1 value
     * @return string|null
     */
    public function getTimer1()
    {
        return $this->timer1;
    }
    /**
     * Set timer1 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer1
     * @return \StructType\RT1Port
     */
    public function setTimer1($timer1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timer1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timer1) ? implode(', ', $timer1) : var_export($timer1, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer1 = $timer1;
        return $this;
    }
    /**
     * Get timer2 value
     * @return string|null
     */
    public function getTimer2()
    {
        return $this->timer2;
    }
    /**
     * Set timer2 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer2
     * @return \StructType\RT1Port
     */
    public function setTimer2($timer2 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timer2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timer2) ? implode(', ', $timer2) : var_export($timer2, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer2 = $timer2;
        return $this;
    }
    /**
     * Get timer3 value
     * @return string|null
     */
    public function getTimer3()
    {
        return $this->timer3;
    }
    /**
     * Set timer3 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer3
     * @return \StructType\RT1Port
     */
    public function setTimer3($timer3 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timer3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timer3) ? implode(', ', $timer3) : var_export($timer3, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer3 = $timer3;
        return $this;
    }
    /**
     * Get timer4 value
     * @return string|null
     */
    public function getTimer4()
    {
        return $this->timer4;
    }
    /**
     * Set timer4 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer4
     * @return \StructType\RT1Port
     */
    public function setTimer4($timer4 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timer4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timer4) ? implode(', ', $timer4) : var_export($timer4, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer4 = $timer4;
        return $this;
    }
    /**
     * Get timer5 value
     * @return string|null
     */
    public function getTimer5()
    {
        return $this->timer5;
    }
    /**
     * Set timer5 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer5
     * @return \StructType\RT1Port
     */
    public function setTimer5($timer5 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timer5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timer5) ? implode(', ', $timer5) : var_export($timer5, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer5 = $timer5;
        return $this;
    }
    /**
     * Get timer6 value
     * @return string|null
     */
    public function getTimer6()
    {
        return $this->timer6;
    }
    /**
     * Set timer6 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer6
     * @return \StructType\RT1Port
     */
    public function setTimer6($timer6 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timer6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($timer6) ? implode(', ', $timer6) : var_export($timer6, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timer6 = $timer6;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RT1Port
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
