<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSoftKeyMember StructType
 * @subpackage Structs
 */
class RSoftKeyMember extends AbstractStructBase
{
    /**
     * The positionId
     * Meta information extracted from the WSDL
     * - documentation: Read-Only.The positionId has values starting with 0 and get incremented by 1 for each call state.
     * - minOccurs: 0
     * @var int
     */
    public $positionId;
    /**
     * The softKeyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $softKeyName;
    /**
     * Constructor method for RSoftKeyMember
     * @uses RSoftKeyMember::setPositionId()
     * @uses RSoftKeyMember::setSoftKeyName()
     * @param int $positionId
     * @param string $softKeyName
     */
    public function __construct($positionId = null, $softKeyName = null)
    {
        $this
            ->setPositionId($positionId)
            ->setSoftKeyName($softKeyName);
    }
    /**
     * Get positionId value
     * @return int|null
     */
    public function getPositionId()
    {
        return $this->positionId;
    }
    /**
     * Set positionId value
     * @param int $positionId
     * @return \StructType\RSoftKeyMember
     */
    public function setPositionId($positionId = null)
    {
        // validation for constraint: int
        if (!is_null($positionId) && !(is_int($positionId) || ctype_digit($positionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionId, true), gettype($positionId)), __LINE__);
        }
        $this->positionId = $positionId;
        return $this;
    }
    /**
     * Get softKeyName value
     * @return string|null
     */
    public function getSoftKeyName()
    {
        return $this->softKeyName;
    }
    /**
     * Set softKeyName value
     * @param string $softKeyName
     * @return \StructType\RSoftKeyMember
     */
    public function setSoftKeyName($softKeyName = null)
    {
        // validation for constraint: string
        if (!is_null($softKeyName) && !is_string($softKeyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softKeyName, true), gettype($softKeyName)), __LINE__);
        }
        $this->softKeyName = $softKeyName;
        return $this;
    }
}
