<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSafForwarderMember StructType
 * @subpackage Structs
 */
class RSafForwarderMember extends AbstractStructBase
{
    /**
     * The callManagerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callManagerName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSafForwarderMember
     * @uses RSafForwarderMember::setCallManagerName()
     * @uses RSafForwarderMember::setUuid()
     * @param \StructType\XFkType $callManagerName
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $callManagerName = null, $uuid = null)
    {
        $this
            ->setCallManagerName($callManagerName)
            ->setUuid($uuid);
    }
    /**
     * Get callManagerName value
     * @return \StructType\XFkType|null
     */
    public function getCallManagerName()
    {
        return $this->callManagerName;
    }
    /**
     * Set callManagerName value
     * @param \StructType\XFkType $callManagerName
     * @return \StructType\RSafForwarderMember
     */
    public function setCallManagerName(\StructType\XFkType $callManagerName = null)
    {
        $this->callManagerName = $callManagerName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RSafForwarderMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
