<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSNMPCommunityString StructType
 * @subpackage Structs
 */
class RSNMPCommunityString extends AbstractStructBase
{
    /**
     * The communityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $communityName;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * The accessPrivilege
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessPrivilege;
    /**
     * The ArrayOfHosts
     * @var \ArrayType\RArrayOfHosts
     */
    public $ArrayOfHosts;
    /**
     * Constructor method for RSNMPCommunityString
     * @uses RSNMPCommunityString::setCommunityName()
     * @uses RSNMPCommunityString::setVersion()
     * @uses RSNMPCommunityString::setAccessPrivilege()
     * @uses RSNMPCommunityString::setArrayOfHosts()
     * @param string $communityName
     * @param string $version
     * @param string $accessPrivilege
     * @param \ArrayType\RArrayOfHosts $arrayOfHosts
     */
    public function __construct($communityName = null, $version = null, $accessPrivilege = null, \ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this
            ->setCommunityName($communityName)
            ->setVersion($version)
            ->setAccessPrivilege($accessPrivilege)
            ->setArrayOfHosts($arrayOfHosts);
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return \StructType\RSNMPCommunityString
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communityName, true), gettype($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\RSNMPCommunityString
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get accessPrivilege value
     * @return string|null
     */
    public function getAccessPrivilege()
    {
        return $this->accessPrivilege;
    }
    /**
     * Set accessPrivilege value
     * @param string $accessPrivilege
     * @return \StructType\RSNMPCommunityString
     */
    public function setAccessPrivilege($accessPrivilege = null)
    {
        // validation for constraint: string
        if (!is_null($accessPrivilege) && !is_string($accessPrivilege)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessPrivilege, true), gettype($accessPrivilege)), __LINE__);
        }
        $this->accessPrivilege = $accessPrivilege;
        return $this;
    }
    /**
     * Get ArrayOfHosts value
     * @return \ArrayType\RArrayOfHosts|null
     */
    public function getArrayOfHosts()
    {
        return $this->ArrayOfHosts;
    }
    /**
     * Set ArrayOfHosts value
     * @param \ArrayType\RArrayOfHosts $arrayOfHosts
     * @return \StructType\RSNMPCommunityString
     */
    public function setArrayOfHosts(\ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this->ArrayOfHosts = $arrayOfHosts;
        return $this;
    }
}
