<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RProcessNodes StructType
 * @subpackage Structs
 */
class RProcessNodes extends AbstractStructBase
{
    /**
     * The lbmAssignedServices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $lbmAssignedServices;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RProcessNodes
     * @uses RProcessNodes::setLbmAssignedServices()
     * @uses RProcessNodes::setUuid()
     * @param \StructType\XFkType $lbmAssignedServices
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $lbmAssignedServices = null, $uuid = null)
    {
        $this
            ->setLbmAssignedServices($lbmAssignedServices)
            ->setUuid($uuid);
    }
    /**
     * Get lbmAssignedServices value
     * @return \StructType\XFkType|null
     */
    public function getLbmAssignedServices()
    {
        return $this->lbmAssignedServices;
    }
    /**
     * Set lbmAssignedServices value
     * @param \StructType\XFkType $lbmAssignedServices
     * @return \StructType\RProcessNodes
     */
    public function setLbmAssignedServices(\StructType\XFkType $lbmAssignedServices = null)
    {
        $this->lbmAssignedServices = $lbmAssignedServices;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RProcessNodes
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
