<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLdapDirectory StructType
 * @subpackage Structs
 */
class RLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userSearchBase;
    /**
     * The repeatable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The intervalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intervalValue;
    /**
     * The scheduleUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scheduleUnit;
    /**
     * The nextExecTime
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Servers
     */
    public $servers;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The mailId
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailId;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The managerId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $managerId;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The ldapFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ldapFilter;
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUri;
    /**
     * The accessControlGroupInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The featureGroupTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $featureGroupTemplate;
    /**
     * The applyMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyMask;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mask;
    /**
     * The applyPoolList
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyPoolList;
    /**
     * The addDns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddDns
     */
    public $addDns;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLdapDirectory
     * @uses RLdapDirectory::setName()
     * @uses RLdapDirectory::setLdapDn()
     * @uses RLdapDirectory::setLdapPassword()
     * @uses RLdapDirectory::setUserSearchBase()
     * @uses RLdapDirectory::setRepeatable()
     * @uses RLdapDirectory::setIntervalValue()
     * @uses RLdapDirectory::setScheduleUnit()
     * @uses RLdapDirectory::setNextExecTime()
     * @uses RLdapDirectory::setServers()
     * @uses RLdapDirectory::setMiddleName()
     * @uses RLdapDirectory::setPhoneNumber()
     * @uses RLdapDirectory::setMailId()
     * @uses RLdapDirectory::setUserId()
     * @uses RLdapDirectory::setManagerId()
     * @uses RLdapDirectory::setFirstName()
     * @uses RLdapDirectory::setLastName()
     * @uses RLdapDirectory::setDepartment()
     * @uses RLdapDirectory::setLdapFilter()
     * @uses RLdapDirectory::setDirectoryUri()
     * @uses RLdapDirectory::setAccessControlGroupInfo()
     * @uses RLdapDirectory::setFeatureGroupTemplate()
     * @uses RLdapDirectory::setApplyMask()
     * @uses RLdapDirectory::setMask()
     * @uses RLdapDirectory::setApplyPoolList()
     * @uses RLdapDirectory::setAddDns()
     * @uses RLdapDirectory::setUuid()
     * @param string $name
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $repeatable
     * @param string $intervalValue
     * @param string $scheduleUnit
     * @param string $nextExecTime
     * @param \StructType\Servers $servers
     * @param string $middleName
     * @param string $phoneNumber
     * @param string $mailId
     * @param string $userId
     * @param string $managerId
     * @param string $firstName
     * @param string $lastName
     * @param string $department
     * @param \StructType\XFkType $ldapFilter
     * @param string $directoryUri
     * @param \StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @param \StructType\XFkType $featureGroupTemplate
     * @param string $applyMask
     * @param string $mask
     * @param string $applyPoolList
     * @param \StructType\AddDns $addDns
     * @param string $uuid
     */
    public function __construct($name = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $repeatable = null, $intervalValue = null, $scheduleUnit = null, $nextExecTime = null, \StructType\Servers $servers = null, $middleName = null, $phoneNumber = null, $mailId = null, $userId = null, $managerId = null, $firstName = null, $lastName = null, $department = null, \StructType\XFkType $ldapFilter = null, $directoryUri = null, \StructType\AccessControlGroupInfo $accessControlGroupInfo = null, \StructType\XFkType $featureGroupTemplate = null, $applyMask = null, $mask = null, $applyPoolList = null, \StructType\AddDns $addDns = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setRepeatable($repeatable)
            ->setIntervalValue($intervalValue)
            ->setScheduleUnit($scheduleUnit)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setMiddleName($middleName)
            ->setPhoneNumber($phoneNumber)
            ->setMailId($mailId)
            ->setUserId($userId)
            ->setManagerId($managerId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setDepartment($department)
            ->setLdapFilter($ldapFilter)
            ->setDirectoryUri($directoryUri)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setFeatureGroupTemplate($featureGroupTemplate)
            ->setApplyMask($applyMask)
            ->setMask($mask)
            ->setApplyPoolList($applyPoolList)
            ->setAddDns($addDns)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RLdapDirectory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \StructType\RLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        // validation for constraint: string
        if (!is_null($ldapDn) && !is_string($ldapDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapDn, true), gettype($ldapDn)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapDn) && mb_strlen($ldapDn) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapDn)), __LINE__);
        }
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \StructType\RLdapDirectory
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ldapPassword, true), gettype($ldapPassword)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($ldapPassword) && mb_strlen($ldapPassword) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \StructType\RLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userSearchBase, true), gettype($userSearchBase)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($userSearchBase) && mb_strlen($userSearchBase) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \StructType\RLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        // validation for constraint: string
        if (!is_null($repeatable) && !is_string($repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repeatable, true), gettype($repeatable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($repeatable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($repeatable, true)), __LINE__);
        }
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string|null
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intervalValue
     * @return \StructType\RLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($intervalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($intervalValue) ? implode(', ', $intervalValue) : var_export($intervalValue, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @uses \EnumType\XScheduleUnit::valueIsValid()
     * @uses \EnumType\XScheduleUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleUnit
     * @return \StructType\RLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XScheduleUnit::valueIsValid($scheduleUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XScheduleUnit', is_array($scheduleUnit) ? implode(', ', $scheduleUnit) : var_export($scheduleUnit, true), implode(', ', \EnumType\XScheduleUnit::getValidValues())), __LINE__);
        }
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string|null
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \StructType\RLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        // validation for constraint: string
        if (!is_null($nextExecTime) && !is_string($nextExecTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextExecTime, true), gettype($nextExecTime)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($nextExecTime) && mb_strlen($nextExecTime) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($nextExecTime)), __LINE__);
        }
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return \StructType\Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \StructType\Servers $servers
     * @return \StructType\RLdapDirectory
     */
    public function setServers(\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\RLdapDirectory
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($middleName) && mb_strlen($middleName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \StructType\RLdapDirectory
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get mailId value
     * @return string|null
     */
    public function getMailId()
    {
        return $this->mailId;
    }
    /**
     * Set mailId value
     * @param string $mailId
     * @return \StructType\RLdapDirectory
     */
    public function setMailId($mailId = null)
    {
        // validation for constraint: string
        if (!is_null($mailId) && !is_string($mailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailId, true), gettype($mailId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($mailId) && mb_strlen($mailId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($mailId)), __LINE__);
        }
        $this->mailId = $mailId;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\RLdapDirectory
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($userId) && mb_strlen($userId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get managerId value
     * @return string|null
     */
    public function getManagerId()
    {
        return $this->managerId;
    }
    /**
     * Set managerId value
     * @param string $managerId
     * @return \StructType\RLdapDirectory
     */
    public function setManagerId($managerId = null)
    {
        // validation for constraint: string
        if (!is_null($managerId) && !is_string($managerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($managerId, true), gettype($managerId)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($managerId) && mb_strlen($managerId) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($managerId)), __LINE__);
        }
        $this->managerId = $managerId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\RLdapDirectory
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($firstName) && mb_strlen($firstName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\RLdapDirectory
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($lastName) && mb_strlen($lastName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \StructType\RLdapDirectory
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($department) && mb_strlen($department) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get ldapFilter value
     * @return \StructType\XFkType|null
     */
    public function getLdapFilter()
    {
        return $this->ldapFilter;
    }
    /**
     * Set ldapFilter value
     * @param \StructType\XFkType $ldapFilter
     * @return \StructType\RLdapDirectory
     */
    public function setLdapFilter(\StructType\XFkType $ldapFilter = null)
    {
        $this->ldapFilter = $ldapFilter;
        return $this;
    }
    /**
     * Get directoryUri value
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * Set directoryUri value
     * @param string $directoryUri
     * @return \StructType\RLdapDirectory
     */
    public function setDirectoryUri($directoryUri = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUri) && !is_string($directoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryUri, true), gettype($directoryUri)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($directoryUri) && mb_strlen($directoryUri) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($directoryUri)), __LINE__);
        }
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return \StructType\AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return $this->accessControlGroupInfo;
    }
    /**
     * Set accessControlGroupInfo value
     * @param \StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @return \StructType\RLdapDirectory
     */
    public function setAccessControlGroupInfo(\StructType\AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        $this->accessControlGroupInfo = $accessControlGroupInfo;
        return $this;
    }
    /**
     * Get featureGroupTemplate value
     * @return \StructType\XFkType|null
     */
    public function getFeatureGroupTemplate()
    {
        return $this->featureGroupTemplate;
    }
    /**
     * Set featureGroupTemplate value
     * @param \StructType\XFkType $featureGroupTemplate
     * @return \StructType\RLdapDirectory
     */
    public function setFeatureGroupTemplate(\StructType\XFkType $featureGroupTemplate = null)
    {
        $this->featureGroupTemplate = $featureGroupTemplate;
        return $this;
    }
    /**
     * Get applyMask value
     * @return string|null
     */
    public function getApplyMask()
    {
        return $this->applyMask;
    }
    /**
     * Set applyMask value
     * @param string $applyMask
     * @return \StructType\RLdapDirectory
     */
    public function setApplyMask($applyMask = null)
    {
        // validation for constraint: string
        if (!is_null($applyMask) && !is_string($applyMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyMask, true), gettype($applyMask)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($applyMask) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applyMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($applyMask, true)), __LINE__);
        }
        $this->applyMask = $applyMask;
        return $this;
    }
    /**
     * Get mask value
     * @return string|null
     */
    public function getMask()
    {
        return $this->mask;
    }
    /**
     * Set mask value
     * @param string $mask
     * @return \StructType\RLdapDirectory
     */
    public function setMask($mask = null)
    {
        // validation for constraint: string
        if (!is_null($mask) && !is_string($mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mask, true), gettype($mask)), __LINE__);
        }
        $this->mask = $mask;
        return $this;
    }
    /**
     * Get applyPoolList value
     * @return string|null
     */
    public function getApplyPoolList()
    {
        return $this->applyPoolList;
    }
    /**
     * Set applyPoolList value
     * @param string $applyPoolList
     * @return \StructType\RLdapDirectory
     */
    public function setApplyPoolList($applyPoolList = null)
    {
        // validation for constraint: string
        if (!is_null($applyPoolList) && !is_string($applyPoolList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyPoolList, true), gettype($applyPoolList)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($applyPoolList) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applyPoolList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($applyPoolList, true)), __LINE__);
        }
        $this->applyPoolList = $applyPoolList;
        return $this;
    }
    /**
     * Get addDns value
     * @return \StructType\AddDns|null
     */
    public function getAddDns()
    {
        return $this->addDns;
    }
    /**
     * Set addDns value
     * @param \StructType\AddDns $addDns
     * @return \StructType\RLdapDirectory
     */
    public function setAddDns(\StructType\AddDns $addDns = null)
    {
        $this->addDns = $addDns;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RLdapDirectory
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
