<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeServer StructType
 * @subpackage Structs
 */
class RImeServer extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Value shpuld be between 1024 and 65535
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $applicationUser;
    /**
     * The reconnectInterval
     * Meta information extracted from the WSDL
     * - documentation: Value should be between 60 and 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reconnectInterval;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeServer
     * @uses RImeServer::setName()
     * @uses RImeServer::setDescription()
     * @uses RImeServer::setIpAddress()
     * @uses RImeServer::setPort()
     * @uses RImeServer::setDeviceSecurityMode()
     * @uses RImeServer::setApplicationUser()
     * @uses RImeServer::setReconnectInterval()
     * @uses RImeServer::setUuid()
     * @param string $name
     * @param string $description
     * @param string $ipAddress
     * @param string $port
     * @param string $deviceSecurityMode
     * @param \StructType\XFkType $applicationUser
     * @param string $reconnectInterval
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $ipAddress = null, $port = null, $deviceSecurityMode = null, \StructType\XFkType $applicationUser = null, $reconnectInterval = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setApplicationUser($applicationUser)
            ->setReconnectInterval($reconnectInterval)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RImeServer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RImeServer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\RImeServer
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\RImeServer
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($port) ? implode(', ', $port) : var_export($port, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @uses \EnumType\XServerSecurityMode::valueIsValid()
     * @uses \EnumType\XServerSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return \StructType\RImeServer
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XServerSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XServerSecurityMode', is_array($deviceSecurityMode) ? implode(', ', $deviceSecurityMode) : var_export($deviceSecurityMode, true), implode(', ', \EnumType\XServerSecurityMode::getValidValues())), __LINE__);
        }
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return \StructType\XFkType|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \StructType\XFkType $applicationUser
     * @return \StructType\RImeServer
     */
    public function setApplicationUser(\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get reconnectInterval value
     * @return string|null
     */
    public function getReconnectInterval()
    {
        return $this->reconnectInterval;
    }
    /**
     * Set reconnectInterval value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reconnectInterval
     * @return \StructType\RImeServer
     */
    public function setReconnectInterval($reconnectInterval = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($reconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($reconnectInterval) ? implode(', ', $reconnectInterval) : var_export($reconnectInterval, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->reconnectInterval = $reconnectInterval;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RImeServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
